package com.igaworks.v2.core;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class AbxGame {

    private AbxGame() {
    }

    public static void tutorialComplete() {
        tutorialComplete(null);
    }

    public static void tutorialComplete(AdBrixRm.GameProperties.TutorialComplete tutorialComplete) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (tutorialComplete == null) {
            AbxLog.i("tutorialComplete: tutorialComplete parameter is null >> Auto change null to empty TutorialComplete", true);
            tutorialComplete = new AdBrixRm.GameProperties.TutorialComplete();
        }

        AdBrixRm.postAbxEvent(CompatConstants.EVENT_GAME_TUTORIAL_COMPLETED, CommonUtils.parseValueWithDataType(tutorialComplete.toJSONObject(), CommonUtils.FixType.PREFIX));
    }

    public static void levelAchieved() {
        levelAchieved(null);
    }

    public static void levelAchieved(AdBrixRm.GameProperties.LevelAchieved levelAchieved) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (levelAchieved == null) {
            AbxLog.i("levelAchieved: levelAchieved parameter is null >> Auto change null to empty LevelAchieved", true);
            levelAchieved = new AdBrixRm.GameProperties.LevelAchieved();
        }

        AdBrixRm.postAbxEvent(CompatConstants.EVENT_GAME_LEVEL_ACHIEVED, CommonUtils.parseValueWithDataType(levelAchieved.toJSONObject(), CommonUtils.FixType.PREFIX));
    }

    public static void characterCreated() {
        characterCreated(null);
    }

    public static void characterCreated(AdBrixRm.GameProperties.CharacterCreated characterCreated) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (characterCreated == null) {
            AbxLog.i("characterCreated: characterCreated parameter is null >> Auto change null to empty CharacterCreated", true);
            characterCreated = new AdBrixRm.GameProperties.CharacterCreated();
        }

        AdBrixRm.postAbxEvent(CompatConstants.EVENT_GAME_CHARACTER_CREATED, CommonUtils.parseValueWithDataType(characterCreated.toJSONObject(), CommonUtils.FixType.PREFIX));
    }

    public static void stageCleared() {
        stageCleared(null);
    }

    public static void stageCleared(AdBrixRm.GameProperties.StageCleared stageCleared) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (stageCleared == null) {
            AbxLog.i("stageCleared: stageCleared parameter is null >> Auto change null to empty StageCleared", true);
            stageCleared = new AdBrixRm.GameProperties.StageCleared();
        }

        AdBrixRm.postAbxEvent(CompatConstants.EVENT_GAME_STAGE_CLEARED, CommonUtils.parseValueWithDataType(stageCleared.toJSONObject(), CommonUtils.FixType.PREFIX));
    }
}
