package com.igaworks.v2.core;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.ExtraUtils;

public class AbxCommerce {
    static int MAX_COMMERCE_CATEGORY_NUMBER = 5;

    private AbxCommerce() {
    }

    // 1 홈화면 열기
    public static void viewHome() {
        AdBrixRm.AttrModel temp = null;
        viewHome(temp);
    }

    public static void viewHome(AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("viewHome");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        AdBrixRm.postAbxEvent(CompatConstants.EVENT_VIEW_HOME, ExtraUtils.getCommerceEventParams(null, CommonUtils.parseValueWithDataType(cloneCommerceExtraAttributes, CommonUtils.FixType.PREFIX)));
    }

    // 2 카테고리(기획전) 진입
    public static void categoryView(AdBrixRm.CommerceCategoriesModel categories, List<AdBrixRm.CommerceProductModel> products) {
        AdBrixRm.AttrModel attr = null;
        categoryView(categories, products, attr);
    }

    public static void categoryView(AdBrixRm.CommerceCategoriesModel categories, List<AdBrixRm.CommerceProductModel> products, AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("categoryView");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        if (categories == null) {
            AbxLog.i("categoryView: categoryModel is null >> Auto change null to empty CommerceCategoriesModel", true);
            categories = new AdBrixRm.CommerceCategoriesModel();
        }
        if (products == null) {
            AbxLog.i("categoryView: productModelList is null >> Auto change null to empty CommerceProductModel list", true);
            products = new ArrayList<>();
        }

        Iterator<String> itr = categories.categoriesLinkedList.iterator();
        for (int index = 1; index <= MAX_COMMERCE_CATEGORY_NUMBER; index++) {
            try {
                String tempValue = itr.hasNext() ? itr.next() : "";
                attributes.put(CompatConstants.ABX_CATEGORY + index, CommonUtils.replaceWithJSONNull(tempValue));
            } catch (Exception e) {
                AbxLog.e(e, true);
            }
        }

        AdBrixRm.postSameAbxEvent(products, CompatConstants.EVENT_CATEGORY_VIEW, attributes);
    }

    public static void categoryView(AdBrixRm.CommerceCategoriesModel categories) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        JSONObject attributes = new JSONObject();

        if (categories == null) {
            AbxLog.i("categoryView: categoryModel is null >> Auto change null to empty CommerceCategoriesModel", true);
            categories = new AdBrixRm.CommerceCategoriesModel();
        }

        Iterator<String> itr = categories.categoriesLinkedList.iterator();
        int index = 0;
        while (itr.hasNext()) {
            try {
                index++;
                attributes.put(CompatConstants.ABX_CATEGORY + index, CommonUtils.replaceWithJSONNull(itr.next()));
            } catch (Exception e) {
                AbxLog.e(e, true);
            }
        }
        try {
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_CATEGORY_VIEW, ExtraUtils.getCommerceEventParams(null, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX)));
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    // 3 상품 상세보기
    public static void productView(AdBrixRm.CommerceProductModel product) {
        AdBrixRm.AttrModel attr = null;
        productView(product, attr);
    }

    public static void productView(AdBrixRm.CommerceProductModel product, AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("productView");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        List<AdBrixRm.CommerceProductModel> products = new ArrayList<>();

        if (product == null)
            AbxLog.i("productView: product is null", true);
        else
            products.add(product);

        try {
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_PRODUCT_VIEW, ExtraUtils.getCommerceEventParams(
                    ExtraUtils.getProductJsonArray(products), CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX))
            );
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    // 4 장바구니 담기
    public static void addToCart(List<AdBrixRm.CommerceProductModel> products) {
        AdBrixRm.AttrModel attr = null;
        addToCart(products, attr);
    }

    public static void addToCart(List<AdBrixRm.CommerceProductModel> products, AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("addToCart");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);

        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;

        if (products == null) {
            AbxLog.i("addToCart: product list is null >> Auto change null to empty CommerceProductModel list", true);
            products = new ArrayList<>();
        }

        AdBrixRm.postSameAbxEvent(products, CompatConstants.EVENT_ADD_TO_CART, attributes);
    }

    // 5 위시리스트(관심상품) 추가
    public static void addToWishList(AdBrixRm.CommerceProductModel product) {
        AdBrixRm.AttrModel attr = null;
        addToWishList(product, attr);
    }

    public static void addToWishList(AdBrixRm.CommerceProductModel product, AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("addToWishList");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        List<AdBrixRm.CommerceProductModel> products = new ArrayList<>();

        if (product == null)
            AbxLog.i("addToWishList: product is null", true);
        else
            products.add(product);

        try {
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_ADD_TO_WISHLIST, ExtraUtils.getCommerceEventParams(
                    ExtraUtils.getProductJsonArray(products), CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX))
            );
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    // 6 주문 내역 검토
    public static void reviewOrder(String orderId, List<AdBrixRm.CommerceProductModel> products, double discount, double deliveryCharge) {
        AdBrixRm.AttrModel attr = null;
        reviewOrder(orderId, products, discount, deliveryCharge, attr);
    }

    public static void reviewOrder(String orderId, List<AdBrixRm.CommerceProductModel> products, double discount, double deliveryCharge, AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("reviewOrder");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        try {
            attributes.put(CompatConstants.ABX_ORDER_ID, CommonUtils.replaceWithJSONNull(orderId));
            attributes.put(CompatConstants.ABX_DISCOUNT, discount);
            attributes.put(CompatConstants.ABX_DELIVERY_CHARGE, deliveryCharge);
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }

        if (products == null) {
            AbxLog.i("reviewOrder: product list is null >> Auto change null to empty CommerceProductModel list", true);
            products = new ArrayList<>();
        }

        AdBrixRm.postSameAbxEvent(products, CompatConstants.EVENT_REVIEW_ORDER, attributes);
    }

    // 8 주문 취소(환불)
    public static void refund(String orderId, List<AdBrixRm.CommerceProductModel> products, double penaltyCharge) {
        AdBrixRm.AttrModel attr = null;
        refund(orderId, products, penaltyCharge, attr);
    }

    public static void refund(String orderID, List<AdBrixRm.CommerceProductModel> products, double penaltyCharge, AdBrixRm.AttrModel commerceExtraAttributes) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (products == null) {
            AbxLog.i("refund: product list is null >> Auto change null to empty CommerceProductModel list", true);
            products = new ArrayList<>();
        }

        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("refund");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        try {
            attributes.put(CompatConstants.ABX_ORDER_ID, CommonUtils.replaceWithJSONNull(orderID));
            attributes.put(CompatConstants.ABX_PENALTY_CHARGE, penaltyCharge);
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }
        AdBrixRm.postSameAbxEvent(products, CompatConstants.EVENT_REFUND, attributes);
    }

    // 9 상품 검색
    public static void search(String keyword, List<AdBrixRm.CommerceProductModel> resultProducts) {
        AdBrixRm.AttrModel attr = null;
        search(keyword, resultProducts, attr);
    }

    public static void search(String keyword, List<AdBrixRm.CommerceProductModel> resultProducts, AdBrixRm.AttrModel commerceExtraAttributes) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (keyword == null) {
            AbxLog.i("search: keyword is null >> Auto change null to empty String", true);
            keyword = "";
        }
        if (resultProducts == null) {
            AbxLog.i("search: resultProducts is null >> Auto change null to empty CommerceProductModel list", true);
            resultProducts = new ArrayList<>();
        }
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("search");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        try {
            attributes.put(CompatConstants.ABX_KEYWORD, CommonUtils.replaceWithJSONNull(keyword));
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }

        AdBrixRm.postSameAbxEvent(resultProducts, CompatConstants.EVENT_SEARCH, attributes);
    }

    // 10 상품 공유
    public static void share(AdBrixRm.CommerceSharingChannel sharingChannel, AdBrixRm.CommerceProductModel product) {
        AdBrixRm.AttrModel attr = null;
        share(sharingChannel, product, attr);
    }

    public static void share(AdBrixRm.CommerceSharingChannel sharingChannel, AdBrixRm.CommerceProductModel product, AdBrixRm.AttrModel commerceExtraAttributes) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (sharingChannel == null) {
            AbxLog.i("share: sharingChannel is null >> Auto change null to empty CommerceSharingChannel", true);
            sharingChannel = new AdBrixRm.CommerceSharingChannel(null);
        }

        List<AdBrixRm.CommerceProductModel> products = new ArrayList<>();

        if (product == null)
            AbxLog.i("share: product is null", true);
        else
            products.add(product);

        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("share");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        try {
            attributes.put(CompatConstants.ABX_SHARING_CHANNEL, CommonUtils.replaceWithJSONNull(sharingChannel.toString()));
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }

        try {
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_SHARE, ExtraUtils.getCommerceEventParams(
                    ExtraUtils.getProductJsonArray(products), CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX))
            );
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    // 상품 목록 조회
    public static void listView(List<AdBrixRm.CommerceProductModel> resultProducts) {
        AdBrixRm.AttrModel attr = null;
        listView(resultProducts, attr);
    }

    public static void listView(List<AdBrixRm.CommerceProductModel> resultProducts, AdBrixRm.AttrModel commerceExtraAttributes) {
        if (AdBrixRm.isAdbrixDisabled()) return;

        if (resultProducts == null) {
            AbxLog.i("listView: resultProducts is null >> Auto change null to empty CommerceProductModel list", true);
            resultProducts = new ArrayList<>();
        }
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("listView");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;

        AdBrixRm.postSameAbxEvent(resultProducts, CompatConstants.EVENT_LIST_VIEW, attributes);
    }

    // 장바구니 상품 목록 조회
    public static void cartView(List<AdBrixRm.CommerceProductModel> cartProducts) {
        AdBrixRm.AttrModel attr = null;
        cartView(cartProducts, attr);
    }

    public static void cartView(List<AdBrixRm.CommerceProductModel> cartProducts, AdBrixRm.AttrModel commerceExtraAttributes) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (cartProducts == null) {
            AbxLog.i("cartView: cartProducts is null >> Auto change null to empty CommerceProductModel list", true);
            cartProducts = new ArrayList<>();
        }
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("cartView");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);
        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;

        AdBrixRm.postSameAbxEvent(cartProducts, CompatConstants.EVENT_CART_VIEW, attributes);
    }

    // 구매정보 입력
    public static void paymentInfoAdded() {
        AdBrixRm.AttrModel attr = null;
        paymentInfoAdded(attr);
    }

    public static void paymentInfoAdded(AdBrixRm.AttrModel commerceExtraAttributes) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commerceExtraAttributes == null) commerceExtraAttributes = new AdBrixRm.AttrModel();
        JSONObject attrs = commerceExtraAttributes.toJSONObject("paymentInfoAdded");
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);

        AdBrixRm.postAbxEvent(CompatConstants.EVENT_PAYMENTINFO_ADDED, ExtraUtils.getCommerceEventParams(
                null, CommonUtils.parseValueWithDataType(cloneCommerceExtraAttributes, CommonUtils.FixType.PREFIX))
        );
    }

}
