package com.igaworks.v2.core.push.notification;

import com.igaworks.v2.core.push.PushEventSqliteStore;

import org.json.JSONArray;
import org.json.JSONException;

import io.adbrix.sdk.configuration.CoreWrapper;

public class AbxPushCommonDAO {
    /*
    DB에 설정 세팅.
    세팅이 되어있지 않다면 디폴트값 리턴
     */

    private AbxPushCommonDAO() {
    }

    public static void setPushIconStyle(String smallIconName, String largeIconName, int argb) {
        CoreWrapper.setPushIconStyle(smallIconName, largeIconName, argb);
    }

    public static void setNotificationOption(int priority, int visibility) {
        CoreWrapper.setNotificationOption(priority, visibility);
    }

    public static String getSmallIconName() {
        return CoreWrapper.getSmallIconName();
    }

    public static String getLargeiconName() {
        return CoreWrapper.getLargeiconName();
    }

    public static int getARGB() {
        return CoreWrapper.getARGB();
    }

    public static int getPriority() {
        return CoreWrapper.getPriority();
    }

    public static int getVisibility() {
        return CoreWrapper.getVisibility();
    }

    public static int getImportance() {
        return CoreWrapper.getImportance();
    }

    protected static void setStackingNotificationOption(boolean useStacking, boolean useTitleForStacking, String contentTitle, String contentText, String bigContentTitle, String bigContentSummaryText) {
        CoreWrapper.setStackingNotificationOption(useStacking, useTitleForStacking, contentTitle, contentText, bigContentTitle, bigContentSummaryText);
    }

    protected static boolean getUseStacking() {
        return CoreWrapper.getUseStacking();
    }

    public static boolean getUseTitleforStacking() {
        return CoreWrapper.getUseTitleforStacking();
    }

    public static String getStackingContentTitle() {
        return CoreWrapper.getStackingContentTitle();
    }

    public static String getStackingContentText() {
        return CoreWrapper.getStackingContentText();
    }

    public static String getStackingBigContentTitle() {
        return CoreWrapper.getStackingBigContentTitle();
    }

    public static String getStackingBigContentSummaryText() {
        return CoreWrapper.getStackingBigContentSummaryText();
    }

    public static void setNotificationChannel(String channelName, String channelDescription,
                                              int importance, boolean vibrateEnable) {
        CoreWrapper.setNotificationChannel(channelName, channelDescription, importance, vibrateEnable);
    }

    public static String getNotificationChannelName() {
        return CoreWrapper.getNotificationChannelName();
    }

    public static String getNotificationChannelDescription() {
        return CoreWrapper.getNotificationChannelDescription();
    }

    public static int getNotificationChannelLight() {
        return CoreWrapper.getNotificationChannelLight();
    }

    public static int getNotificationChannelVibrate() {
        return CoreWrapper.getNotificationChannelVibrate();
    }

    public static void insertOrReplacePushEvent(String title, String content, int eventId, long notificationTime, int isStacked) {
        try {
            PushEventSqliteStore.getInstance(null).insertOrReplacePushEventToTable(title, content, eventId, notificationTime, isStacked);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getPushEventList() {
        try {
            return PushEventSqliteStore.getInstance(null).getPushEventList();
        } catch (Exception e) {
            e.printStackTrace();
            return new JSONArray();
        }
    }

    public static JSONArray getStackedPushList(int isStacked) {
        try {
            return PushEventSqliteStore.getInstance(null).getPushEventList(isStacked);
        } catch (Exception e) {
            e.printStackTrace();
            return new JSONArray();
        }
    }

    protected static void updatePushEventState(int id, boolean state) {
        PushEventSqliteStore.getInstance(null).updatePushEventState(id, state);
    }

    public static long deletePushEvent(int eventId) {
        return PushEventSqliteStore.getInstance(null).deletePushEvent(eventId);
    }

    protected static void flushStackedPushList() {
        JSONArray temp = AbxPushCommonDAO.getStackedPushList(1);
        for (int i = 0; i < temp.length(); i++) {
            try {
                AbxPushCommonDAO.updatePushEventState((int) (temp.getJSONObject(i).get("id")), false);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}
