package com.igaworks.v2.core;

import static com.igaworks.v2.core.CompatConstants.EVENT_USER_PROPERTY_CHANGED;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;

import com.igaworks.v2.core.push.PushController;
import com.igaworks.v2.core.push.PushEventSqliteStore;
import com.igaworks.v2.core.push.notification.AbxPushCommonDAO;
import com.igaworks.v2.core.push.notification.AbxPushReceiver;
import com.igaworks.v2.core.push.notification.PushCreator;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.IPairObserver;
import io.adbrix.sdk.configuration.CoreWrapper;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryError;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.DfnInAppMessageFetchMode;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.utils.CommonUtils;

//import com.igaworks.v2.core.push.popup.Model.InAppBar;
//import com.igaworks.v2.core.push.popup.Model.InAppCarousel;
//import com.igaworks.v2.core.push.popup.Model.InAppFullImage;
//import com.igaworks.v2.core.push.popup.Model.InAppFullWebView;
//import com.igaworks.v2.core.push.popup.Model.InAppModal;
//import com.igaworks.v2.core.push.popup.PopUpHandler;
//import com.igaworks.v2.core.push.popup.PopUpUtils;

public class AdBrixRm {

    public static AbxGame Game;
    public static AbxCommon Common;
    public static AbxCommerce Commerce;
    private static DeferredDeeplinkListener deferredDeeplinkListener;
    private static DeeplinkListener deeplinkListener;
    private static InAppMessageClickListener inAppMessageClickListener;
    private static DfnInAppMessageAutoFetchListener dfnInAppMessageAutoFetchListener;
    private static LogListener logListener;
    private static boolean isLogListenerAvailable = false;
    private static boolean isDeeplinkEventWithIntentAvailable = false;
    private AdBrixRm() {
    }

    public static void init(Context appContext, String appKey, String secretKey) {
        try {
            isLogListenerAvailable = isLogListenerAvailable(appContext);

            isDeeplinkEventWithIntentAvailable = isDeeplinkEventWithIntentAvailable(appContext);

            AbxLog.checkDebugAppInstalled(appContext);

            CoreWrapper.setServerMode(appContext);

            CoreWrapper.startController(appContext);

            CoreWrapper.addObserverToDeferredDeeplinkPostingObservable(new DeferredDeeplinkObserver());
            CoreWrapper.addObserverToDeeplinkPostingObservable(new DeeplinkObserver());
            CoreWrapper.addObserverToInAppMessageClickPostingObservable(new InAppMessageClickObserver());
            CoreWrapper.addObserverToInAppMessageAutoFetchObservable(new InAppMessageFetchObserver());

            CoreWrapper.initialize(appContext, appKey, secretKey);

            CoreWrapper.runInBackGroundWithoutOrder(new Runnable() {
                @Override
                public void run() {
                    PushController.getInstance().init();
                }
            });

            CoreWrapper.addObserverToOsPushEnableObservable(new OsPushEnableObserver());

            PushEventSqliteStore.initPushEventSqliteStore(appContext, null);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void stopController() {
        try {
            CoreWrapper.stopController();
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void login(final String userId) {
        try {
            CoreWrapper.runInBackGroundInOrder(new Runnable() {
                @Override
                public void run() {
                    if (isAdbrixDisabled()) return;
                    String userIdParam = userId;

                    if (CommonUtils.isNullOrEmpty(userIdParam)) {
                        userIdParam = "";
                        AbxLog.i("login: userId is null or empty >> Auto change to empty String", true);
                    }

                    boolean isLoginIdExist = CoreWrapper.isLoginIdExist(userIdParam);

                    AdBrixRm.UserProperties userProperties = new AdBrixRm.UserProperties();
                    userProperties.setAttrs("user_id", userIdParam);

                    // Updating userProperties before login to update user_id in user profile
                    if (userProperties.propertiesJson.length() > 0) {
                        saveUserPropertiesWithoutEvent(userProperties);
                    }

                    postAbxEvent(CompatConstants.EVENT_LOGIN);

                    // Updating userProperties after login to update user property and ci
                    if (userProperties.propertiesJson.length() > 0) {
                        if (!isLoginIdExist)
                            postAbxEvent(EVENT_USER_PROPERTY_CHANGED);
                    }
                }
            });

        } catch (Exception e) {
            AbxLog.e("login >> Error: " + e.toString(), false);
        }
    }

    public static void logout() {
        try {
            CoreWrapper.runInBackGroundInOrder(new Runnable() {
                @Override
                public void run() {
                    if (isAdbrixDisabled()) return;

                    clearUserProperties();
                    CoreWrapper.clearAllActionHistoryInLocalDB();

                    if (CoreWrapper.isInAppMessageUserFetchMode())
                        CoreWrapper.deleteAllInAppMessageDBContents();

                    postAbxEvent(CompatConstants.EVENT_LOGOUT);
                }
            });
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void gdprForgetMe(Context appContext) {
        try {
            CoreWrapper.gdprForgetMe();
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setAge(final int age) {
        try {
            if (isAdbrixDisabled()) return;

            UserProperties userProperties = new UserProperties();
            userProperties.setAttrs("age", age);

            saveUserProperties(userProperties);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setGender(final AbxGender gender) {
        try {
            if (isAdbrixDisabled()) return;

            AbxGender genderParam = gender;

            if (gender == null) {
                AbxLog.i("setGender: null value for gender >> Auto change null to AbxGender.UNKNOWN", true);
                genderParam = AbxGender.UNKNOWN;
            }

            UserProperties userProperties = new UserProperties();
            userProperties.setAttrs("gender", genderParam.getIntValue());

            saveUserProperties(userProperties);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    //With Event
    public static void saveUserProperties(final UserProperties userProperties) {
        try {
            CoreWrapper.runInBackGroundInOrder(new Runnable() {
                @Override
                public void run() {
                    if (isAdbrixDisabled()) return;

                    if (userProperties == null) {
                        AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
                        return;
                    }

                    CoreWrapper.saveUserProperty(userProperties.propertiesJson);
                }
            });

        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    //Without Event
    private static void saveUserPropertiesWithoutEvent(final UserProperties userProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (userProperties == null) {
                AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
                return;
            }

            CoreWrapper.saveUserPropertyWithoutEvent(userProperties.propertiesJson);

        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void clearUserProperties() {
        try {
            if (isAdbrixDisabled()) return;

            CoreWrapper.clearUserProperties();
        } catch (Exception e){
            AbxLog.e(e.toString(), true);
        }
    }

    public static void setEnableLocationListening(final Boolean isEnable) {
        try {
            if (isAdbrixDisabled()) return;

            CoreWrapper.setEnableLocationListening(isEnable);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setLocation(final double latitude, final double longitude) {
        try {
            if (isAdbrixDisabled()) return;

            CoreWrapper.setLocation(latitude, longitude);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void event(final String eventName) {
        try {
            if (isAdbrixDisabled()) return;

            if (eventName == null) {
                AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
                return;
            }

            CoreWrapper.event(eventName);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void event(final String eventName, final AttrModel attrModel) {
        try {
            if (isAdbrixDisabled()) return;

            if (eventName == null) {
                AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
                return;
            }

            AttrModel attrModelParam = attrModel;
            if (attrModel == null) {
                AbxLog.e("event:: null value for attrModel. Auto change null to Empty AttrModel.", false);
                attrModelParam = new AttrModel();
            }

            CoreWrapper.event(eventName, CommonUtils.parseValueWithDataType(attrModelParam.toJSONObject("custom event"), CommonUtils.FixType.PREFIX));

        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void flushAllEvents(final Completion<Result<Empty>> completion) {
        try {
            CoreWrapper.flushAllEvents(completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    private static void postAbxEvent(String eventName) {
        try {
            CoreWrapper.postAbxEvent(eventName);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    static void postAbxEvent(String eventName, JSONObject eventParam) {
        try {
            CoreWrapper.postAbxEvent(eventName, eventParam);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    static void postSameAbxEvent(List<CommerceProductModel> products, String eventName, JSONObject attributes) {
        try {
            List<List<CommerceProductModel>> listOfList = CommonUtils.split(products, CompatConstants.MAX_PRODUCT_LIST_LENGTH);
            List<JSONArray> jsonArrayList = new ArrayList<>();
            List<JSONObject> jsonObjectList = new ArrayList<>();
            for (List<CommerceProductModel> commerceProductModelList : listOfList) {
                JSONArray array = new JSONArray();
                try {
                    array = ExtraUtils.getProductJsonArrayForPurchase(commerceProductModelList);
                    jsonArrayList.add(array);
                } catch (JSONException e) {
                    AbxLog.e(e.toString(), false);
                }
            }

            for (JSONArray productJsonArray : jsonArrayList) {
                jsonObjectList.add(
                        ExtraUtils.getCommerceEventParams(productJsonArray, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX)));
            }

            CoreWrapper.postSameAbxEvent(eventName, jsonObjectList);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void onPause() {
        try {
            CoreWrapper.onPause();
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void onDestroy(final Activity activity) {
        try {
            CoreWrapper.onDestroy(activity);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void onResume(final Activity activity) {
        try {
            CoreWrapper.onResume(activity);
            if(isPushOpenClickIntentActionOnResume(activity.getIntent())){
                broadcastToAbxPushReceiver(activity);
            }
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    private static boolean isPushOpenClickIntentActionOnResume(Intent intent){
        boolean isOpenClick = false;
        if(intent == null){
            AbxLog.i("intent is null", true);
            return isOpenClick;
        }
        String action = intent.getAction();
        if(CommonUtils.isNullOrEmpty(action)) {
            AbxLog.i("intent action is null", true);
            return isOpenClick;
        }
        if(CompatConstants.REMOTE_PUSH_OPEN_CLICKED.equals(action)){
            isOpenClick = true;
            return isOpenClick;
        }
        if(CompatConstants.LOCAL_PUSH_OPEN_CLCKED.equals(action)){
            isOpenClick = true;
            return isOpenClick;
        }

        return isOpenClick;
    }

    private static void broadcastToAbxPushReceiver(Activity activity){
        AbxLog.i("broadcast to AbxPushReceiver", true);
        Intent intent = activity.getIntent();
        intent.setClass(activity.getApplicationContext(), AbxPushReceiver.class);
        activity.sendBroadcast(intent);
    }

    static boolean isAdbrixDisabled() {
        boolean result = false;
        try {
            result = CoreWrapper.isAdbrixDisabled();
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
        return result;
    }

    public static void setDeferredDeeplinkListener(DeferredDeeplinkListener deferredDeeplinkListener) {
        try {
            AdBrixRm.deferredDeeplinkListener = deferredDeeplinkListener;
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setDeeplinkListener(DeeplinkListener deeplinkListener) {
        try {
            AdBrixRm.deeplinkListener = deeplinkListener;
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setInAppMessageClickListener(InAppMessageClickListener inAppMessageClickListener) {
        try {
            AdBrixRm.inAppMessageClickListener = inAppMessageClickListener;
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setDfnInAppMessageAutoFetchListener(DfnInAppMessageAutoFetchListener dfnInAppMessageAutoFetchListener) {
        try {
            AdBrixRm.dfnInAppMessageAutoFetchListener = dfnInAppMessageAutoFetchListener;
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void deeplinkEvent(final Activity deeplinkActivity) {
        try {
            if (isAdbrixDisabled()) return;
            CoreWrapper.deeplink(deeplinkActivity);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void deeplinkEventWithIntent(final Intent deeplinkIntent) {
        try {
            if (isAdbrixDisabled()) return;

            if (!isDeeplinkEventWithIntentAvailable) {
                AbxLog.d("deeplinkEventWithIntent API is not available!", true);
                return;
            }

            CoreWrapper.deeplinkWithIntent(deeplinkIntent);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setEventUploadCountInterval(AdBrixEventUploadCountInterval eventUploadCountInterval) {
        try {
            if (isAdbrixDisabled()) return;

            int minValue = AdBrixEventUploadCountInterval.MIN.getIntValue();
            int defValue = AdBrixEventUploadCountInterval.NORMAL.getIntValue();
            int maxValue = AdBrixEventUploadCountInterval.MAX.getIntValue();

            int countIntervalValue = eventUploadCountInterval.getIntValue();

            if (countIntervalValue != minValue && countIntervalValue != defValue && countIntervalValue != maxValue) {
                countIntervalValue = defValue;
            }

            CoreWrapper.setCountInterval(countIntervalValue);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setEventUploadTimeInterval(AdBrixEventUploadTimeInterval eventUploadTimeInterval) {
        try {
            if (isAdbrixDisabled()) return;

            int minValue = AdBrixEventUploadTimeInterval.MIN.getIntValue();
            int defValue = AdBrixEventUploadTimeInterval.NORMAL.getIntValue();
            int maxValue = AdBrixEventUploadTimeInterval.MAX.getIntValue();

            int timeIntervalValue = eventUploadTimeInterval.getIntValue();

            if (timeIntervalValue != minValue && timeIntervalValue != defValue && timeIntervalValue != maxValue) {
                timeIntervalValue = defValue;
            }

            CoreWrapper.setTimeInterval(timeIntervalValue);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setAppScanEnable(boolean enable) {
        try {
            if (isAdbrixDisabled()) return;

            CoreWrapper.setAppScanEnable(enable);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setRemotePushMessageListener(onTouchRemotePushListener remotePushMessageListener) {
        try {
            PushController.getInstance().setRemotePushMessageListener(remotePushMessageListener);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setLocalPushMessageListener(onTouchLocalPushListener localPushMessageListener) {
        try {
            PushController.getInstance().setLocalPushMessageListener(localPushMessageListener);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setPushEnable(final boolean enable) {
        try {
            if (isAdbrixDisabled()) return;
            PushController.getInstance().setPushEnable(enable);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setRegistrationId(final String token) {
        try {
            if (isAdbrixDisabled()) return;
            PushController.getInstance().setRegistrationID(token);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setBigTextClientPushEvent(Context ctx, BigTextPushProperties bigTextPushProp, boolean alwaysIsShown) {
        try {
            if (isAdbrixDisabled()) return;
            PushController.getInstance().setBigTextClientPushEvent(ctx, bigTextPushProp, alwaysIsShown);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setBigPictureClientPushEvent(Context ctx, AdBrixRm.BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        try {
            if (isAdbrixDisabled()) return;

            if (bigPicturePushProperties == null) {
                AbxLog.d("bigPicturePushProperties are null!", false);
                return;
            }

            PushController.getInstance().setBigPictureClientPushEvent(ctx, bigPicturePushProperties, alwaysIsShown);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void cancelClientPushEvent(Context ctx, int eventId) {
        try {
            if (isAdbrixDisabled()) return;
            PushController.getInstance().cancelClientPushEvent(ctx, eventId);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static JSONArray getPushEventList() {
        JSONArray result = new JSONArray();
        try {
            if (isAdbrixDisabled()) return result;
            result = AbxPushCommonDAO.getPushEventList();
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
        return result;
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, int argb) {
        try {
            if (isAdbrixDisabled()) return;
            AbxPushCommonDAO.setPushIconStyle(smallIconName, largeIconName, argb);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, PushColor color) {
        try {
            int rgb = -1;
            switch (color) {
                case RED:
                    rgb = Color.rgb(255, 0, 0);
                    break;
                case BLACK:
                    rgb = Color.rgb(0, 0, 0);
                    break;
                case BLUE:
                    rgb = Color.rgb(0, 0, 255);
                    break;
                case WHITE:
                    rgb = Color.rgb(255, 255, 255);
                    break;
                case GREEN:
                    rgb = Color.rgb(0, 255, 0);
                    break;
                case YELLOW:
                    rgb = Color.rgb(255, 255, 0);
                    break;
                default:
            }
            AbxPushCommonDAO.setPushIconStyle(smallIconName, largeIconName, rgb);

        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconname) {
        try {
            setPushIconStyle(context, smallIconName, largeIconname, -1);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    /**
     * For under the oreo.
     *
     * @param context
     * @param priority   See e.g. {@link android.app.Notification#PRIORITY_DEFAULT}
     * @param visibility See e.g. {@link android.app.Notification#VISIBILITY_PUBLIC}
     */
    public static void setNotificationOption(Context context, int priority, int visibility) {
        try {
            if (isAdbrixDisabled()) return;
            AbxPushCommonDAO.setNotificationOption(priority, visibility);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    /**
     * To use notification channel, use this API.<br>
     * You must call {@code AdBrixRm.setPushEnable(true)} before use this API.<br>
     * You can change channelName and channelDescription whenever you want.<br>
     * But you cannot change channel importance and vibration once you create channel.
     *
     * @param channelName
     * @param channelDescription
     * @param importance         See e.g. {@link android.app.NotificationManager#IMPORTANCE_DEFAULT}
     * @param vibrateEnable      You can enable or disable vibration
     *                           when you have channel with an {@code importance} of at
     *                           least {@link android.app.NotificationManager#IMPORTANCE_DEFAULT}
     */
    public static void setNotificationChannel(Context context, String channelName, String channelDescription, int importance, boolean vibrateEnable) {
        try {
            if (isAdbrixDisabled()) return;

            if (!CoreWrapper.getPushEnable()) return;
            PushCreator.createNotificationChannel(context, channelName, channelDescription, importance, vibrateEnable);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setKakaoId(final String kakaoId) {
        try {
            if (isAdbrixDisabled()) return;

            if (kakaoId == null) {
                AbxLog.w("Ignore setKakaoId function :: null value for kakaoId", true);
                return;
            }

            CiProperties ciProperties = new CiProperties();
            ciProperties.setAttrs("kakao_id", kakaoId);

            CoreWrapper.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void saveCiProperties(final String key, final Object value) {
        try {
            if (isAdbrixDisabled()) return;

            if (key == null || value == null) {
                AbxLog.w("Ignore setCustomci function :: null value for key or value", true);
                return;
            }

            CiProperties ciProperties = new CiProperties();
            ciProperties.setAttrs(key, value);

            CoreWrapper.saveCi(ciProperties.propertiesJson);

        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void saveCiProperties(CiProperties ciProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (ciProperties == null) {
                AbxLog.d("ciProperties are null!", false);
                return;
            }

            CoreWrapper.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static AbxRemotePushModel parsePushData(Map<String, String> pushDataMap) throws JSONException {
        if (pushDataMap == null) {
            throw new JSONException("pushDataMap is null!");
        }

        try {
            JSONObject pushJson = new JSONObject();
            String abxGfFcm = pushDataMap.get("abx:gf:fcm");

            if (abxGfFcm != null) {
                pushJson.put("abx:gf:fcm", new JSONObject(abxGfFcm));
                return new AbxRemotePushModel(pushJson);
            }
            else
                return null;
        }catch(Exception e){
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
            return null;
        }

    }

    public static void openPush(AbxRemotePushModel abxRemotePushModel) {
        try {
            if (isAdbrixDisabled()) {
                AbxLog.e("openPush :: Adbrix is disabled because of (GdprForgetMe || Pause || Stop || Delete)", false);
                return;
            }

            if (abxRemotePushModel == null) {
                AbxLog.e("abxRemotePushModel is null", false);
                return;
            }

            AbxLog.d("openPush event called! param : " + abxRemotePushModel.toOpenPushEventParamJson(), true);
            postAbxEvent("open_push", CommonUtils.parseValueWithDataType(abxRemotePushModel.toOpenPushEventParamJson(),
                    CommonUtils.FixType.PREFIX));
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void deleteUserDataAndStopSDK(String userId, Runnable onSuccess, Runnable onFail) {
        try {
            CoreWrapper.deleteUserDataAndStopSDK(userId, onSuccess, onFail);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void restartSDK(String userId, Runnable onSuccess, Runnable onFail) {
        try {
            CoreWrapper.restartSDK(userId, onSuccess, onFail);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static String SDKVersion() {
        String result = "";
        try {
            result = CoreWrapper.getSDKVersion();
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
        return result;
    }

    public static void setLogListener(LogListener logListener) {
        try {
            AdBrixRm.logListener = logListener;
            AbxLog.setLogObserver(new LogObserver());
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    private static boolean isLogListenerAvailable(Context context) {
        boolean result = false;
        try {
            ApplicationInfo appInfo;
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = appInfo.metaData;
                int bitcode = bundle.getInt("AdBrixCustomLogicFlag");
                boolean tempIsLogListenerAvailable = (bitcode % 2) == 1;

                AbxLog.d("isLogListenerAvailable: " + tempIsLogListenerAvailable, true);
                result = tempIsLogListenerAvailable;
            } catch (Exception e) {
                AbxLog.e(e.toString(), false);
            }
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
        return result;
    }

    private static boolean isDeeplinkEventWithIntentAvailable(Context context) {
        boolean result = false;
        try {
            ApplicationInfo appInfo;
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = appInfo.metaData;
                int bitcode = bundle.getInt("AdBrixCustomLogicFlag");

                boolean tempIsDeeplinkEventWithIntentAvailable = ((bitcode >> 1) % 2) == 1;

                AbxLog.d("isDeeplinkEventWithIntentAvailable: " + tempIsDeeplinkEventWithIntentAvailable, true);
                result = tempIsDeeplinkEventWithIntentAvailable;

            } catch (PackageManager.NameNotFoundException e) {
                AbxLog.e(e.toString(), false);
                return result;
            }
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
        return result;
    }

    public static void fetchActionHistoryByUserId(String token, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.fetchActionHistoryFromServer(token, ActionHistoryIdType.USER_ID, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void fetchActionHistoryByAdid(String token, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.fetchActionHistoryFromServer(token, ActionHistoryIdType.ADID, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void insertPushData(Map<String, String> data) {
        try {
            if (isAdbrixDisabled()) {
                AbxLog.d(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getErrorMessage(), false);
                return;
            }

            String pushDataString = data.get(ABXConstants.PUSH_REMOTE_FCM_KEY);

            if (pushDataString != null) {
                CoreWrapper.insertPushData(pushDataString);
            }
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.getActionHistory(skip, limit, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.getAllActionHistory(actionType, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void deleteActionHistory(
            String token,
            String historyId,
            long timestamp,
            Completion<Result<Empty>> completion
    ) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.deleteActionHistory(token, historyId, timestamp, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void deleteAllActionHistoryByUserId(String token, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.deleteAllActionHistory(token, ActionHistoryIdType.USER_ID, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void deleteAllActionHistoryByAdid(String token, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.deleteAllActionHistory(token, ActionHistoryIdType.ADID, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.clearSyncedActionHistoryInLocalDB(completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setInAppMessageFetchMode(DfnInAppMessageFetchMode mode) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            CoreWrapper.setInAppMessageFetchMode(mode);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void setInAppMessageToken(String token) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            CoreWrapper.setInAppMessageToken(token);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void fetchInAppMessage(Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.fetchInAppMessage(completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.getAllInAppMessage(completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public static void openInAppMessage(String campaignId, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            CoreWrapper.openInAppMessage(campaignId, completion);
        } catch (Exception e){
            AbxLog.e(e.toString(), false);
        }
    }

    public enum AbxGender {
        MALE(2),
        FEMALE(1),
        UNKNOWN(0);

        private final int value;

        AbxGender(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public enum AdBrixEventUploadCountInterval {
        MIN(10),
        NORMAL(30),
        MAX(60);

        private final int value;

        AdBrixEventUploadCountInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public enum AdBrixEventUploadTimeInterval {
        MIN(30_000),
        NORMAL(60_000),
        MAX(120_000);

        private final int value;

        AdBrixEventUploadTimeInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    /*
    Push notification, Pop-Up
     */
    public enum PushColor {
        WHITE, BLACK, BLUE, YELLOW, RED, GREEN
    }

    public interface DeferredDeeplinkListener {
        void onReceiveDeferredDeeplink(String uriStr);
    }

    public interface DeeplinkListener {
        void onReceiveDeeplink(String uriStr);
    }

    public interface InAppMessageClickListener {
        void onReceiveInAppMessageClick(
                String actionId,
                String actionType,
                String actionArg,
                boolean isClosed
        );
    }

    public interface onTouchLocalPushListener {
        void onTouchLocalPush(String callbackJsonString);
    }

    public interface onTouchRemotePushListener {
        void onTouchRemotePush(String callbackJsonString);
    }

    public interface LogListener {
        void onPrintLog(int level, String message);
    }

    public interface DfnInAppMessageAutoFetchListener {
        void onFetchInAppMessage(Result<Empty> result);
    }

    private static class DeferredDeeplinkObserver implements IObserver<String> {

        @Override
        public void update(String deferredDeeplink) {
            if (deferredDeeplinkListener == null) {
                AbxLog.w("deferredDeeplinkListener is null", true);
                return;
            }

            if (deferredDeeplink == null) {
                AbxLog.d("deferredDeeplink is null", true);
                return;
            }
            deferredDeeplinkListener.onReceiveDeferredDeeplink(deferredDeeplink);
        }
    }

    private static class DeeplinkObserver implements IObserver<String> {

        @Override
        public void update(String deeplink) {
            if (deeplinkListener == null) {
                AbxLog.w("deeplinkListener is null", true);
                return;
            }

            if (deeplink == null) {
                AbxLog.d("deeplink is null", true);
                return;
            }
            deeplinkListener.onReceiveDeeplink(deeplink);
        }
    }

    private static class InAppMessageClickObserver implements IObserver<HashMap<String, Object>> {
        private final String actionId = "actionId";
        private final String actionType = "actionType";
        private final String actionArg = "actionArg";
        private final String isClosed = "isClosed";

        @Override
        public void update(HashMap<String, Object> clickInformation) {
            if (inAppMessageClickListener == null) {
                AbxLog.w("inAppMessageClickListener is null", true);
                return;
            }

            if (clickInformation == null) {
                AbxLog.w("InAppMessage click information is null", true);
                return;
            }

            inAppMessageClickListener.onReceiveInAppMessageClick(
                    (String) clickInformation.get(actionId),
                    (String) clickInformation.get(actionType),
                    (String) clickInformation.get(actionArg),
                    (boolean) clickInformation.get(isClosed)
            );
        }
    }

    private static class OsPushEnableObserver implements IObserver<Boolean> {

        @Override
        public void update(Boolean object) {
            try {
                PushController.getInstance().updateOSNotificationEnabled(object);
            } catch (Exception e){
                AbxLog.e(e.toString(), false);
            }
        }
    }

    private static class InAppMessageFetchObserver implements IObserver<Result<Empty>> {

        @Override
        public void update(Result<Empty> result) {
            if(dfnInAppMessageAutoFetchListener == null){
                AbxLog.w("dfnInAppMessageAutoFetchListener is null", true);
                return;
            }
            dfnInAppMessageAutoFetchListener.onFetchInAppMessage(result);
        }
    }

    public static class UserProperties {
        protected JSONObject propertiesJson = new JSONObject();

        public UserProperties setAttrs(String property, Object value) {
            addToUserProperties(property, value);
            return this;
        }

        private void addToUserProperties(String property, Object value) {
            if (isAdbrixDisabled()) return;

            if (CommonUtils.isNullOrEmpty(property)) {
                AbxLog.w("Ignore addToUserProperties function :: property is null or empty string", true);
                return;
            }

            if (value == null) {
                AbxLog.w(String.format("Ignore addToUserProperties function :: null value for property %s", property), true);
                return;
            }
            try {
                String convertKey = ExtraUtils.convertPermittedStr(property);
                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return;
                }
                if (convertKey.length() > ABXConstants.MAX_KEY_LENGTH) {
                    return;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    propertiesJson.put(convertKey, value);
                }

            } catch (JSONException e) {
                AbxLog.e("addToUserProperties JSONObject Error: " + e.getMessage(), true);
            }
        }
    }

    public static class CiProperties extends UserProperties {
        @Override
        public CiProperties setAttrs(String property, Object value) {
            super.setAttrs(property, value);
            return this;
        }
    }

    public static class AttrModel {
        protected JSONObject properties = new JSONObject();

        public AttrModel setAttrs(String property, Object value) {
            try {

                String convertKey = ExtraUtils.convertPermittedStr(property);

                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return this;
                }
                if (convertKey.length() > ABXConstants.MAX_KEY_LENGTH) {
                    return this;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    properties.put(convertKey, value);
                }

            } catch (JSONException e) {
                AbxLog.e(e.toString(), false);
            }
            return this;
        }

        public JSONObject toJSONObject(String tag) {
            JSONObject obj = new JSONObject();
            try {
                if(properties != null){
                    obj = properties;
                }
                obj = CommonUtils.truncate(ExtraUtils.limitCustomKeyNumber(ExtraUtils.cloneJSONObject(obj), tag));
            } catch (Exception e) {
                AbxLog.e(e.toString(), false);
            }

            return obj;
        }
    }

//    public static void showBarPopUp(Activity activity, InAppBar resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.BAR, resource);
//    }
//
//    public static void showModalPopUp(Activity activity, InAppModal resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.MODAL, resource);
//    }
//
//    public static void showWebViewPopUp(Activity activity, InAppFullWebView resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_WEB_VIEW, resource);
//    }
//
//    public static void showCarouselPopUp(Activity activity, InAppCarousel resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.CAROUSEL, resource);
//    }
//
//    public static void showFullImagePopUp(Activity activity, InAppFullImage resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_IMAGE, resource);
//    }

    public static class GameProperties {

        public static class TutorialComplete {

            protected Boolean isSkip = null;
            protected JSONObject gameProperties;

            public TutorialComplete() {
                gameProperties = new JSONObject();
            }

            public TutorialComplete setIsSkip(boolean isSkip) {
                this.isSkip = isSkip;
                return this;
            }

            public TutorialComplete setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                gameProperties = attrModel.toJSONObject("TutorialComplete");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.isSkip != null) {
                        obj.put(CompatConstants.ABX_GAME_IS_SKIP, isSkip);
                    }
                } catch (Exception e) {
                    AbxLog.e(e.toString(), false);
                }
                return obj;
            }
        }

        public static class LevelAchieved {

            protected Integer level = null;
            protected JSONObject gameProperties;

            public LevelAchieved() {
                this.gameProperties = new JSONObject();
            }

            public LevelAchieved setLevel(int level) {
                this.level = level;
                return this;
            }

            public LevelAchieved setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("LevelAchieved");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.level != null) {
                        obj.put(CompatConstants.ABX_GAME_LEVEL, level);
                    }
                }catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }
                return obj;
            }
        }

        public static class CharacterCreated {

            protected JSONObject gameProperties;

            public CharacterCreated() {
                this.gameProperties = new JSONObject();
            }

            public CharacterCreated setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("CharacterCreated");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                }catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }
                return obj;
            }
        }

        public static class StageCleared {

            protected String stageName = null;
            protected JSONObject gameProperties;

            public StageCleared() {
                this.gameProperties = new JSONObject();
            }

            public StageCleared setStageName(String stageName) {
                this.stageName = stageName;
                return this;
            }

            public StageCleared setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("StageCleared");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.stageName != null){
                        obj.put(CompatConstants.ABX_GAME_STAGE_NAME, stageName);
                    }
                } catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }
                return obj;
            }
        }
    }

    /*
     Excluded for privacy reasons
     */
//    public static void setPhoneNumber(String phoneNumber){
//        if (checkAdbrixPause()) return;
//
//        if (phoneNumber == null) {
//            Log.w(ABXConstants.LOGTAG, "Ignore setPhoneNumber function :: null value for phoneNumber");
//            return;
//        }
//
//        CiProperties ciProperties = new CiProperties();
//        ciProperties.setAttrs("phone_number", phoneNumber);
//
//        CoreWrapper.saveCi(ciProperties.propertiesJson);
//    }

    public static class CommonProperties {

        public static class Purchase {

            protected JSONObject commonProperties;

            public Purchase() {
                this.commonProperties = new JSONObject();
            }

            public Purchase setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Purchase");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "Purchase");
                } catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }
                return obj;
            }
        }

        public static class SignUp {

            protected JSONObject commonProperties;

            public SignUp() {
                this.commonProperties = new JSONObject();
            }

            public SignUp setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("SignUp");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "SignUp");
                } catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }

                return obj;
            }
        }

        public static class UseCredit {
            protected JSONObject commonProperties;

            public UseCredit() {
                this.commonProperties = new JSONObject();
            }

            public UseCredit setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("UseCredit");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "UseCredit");
                } catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }

                return obj;
            }
        }

        public static class AppUpdate {

            protected JSONObject commonProperties;

            protected String prevVer;
            protected String currVer;

            public AppUpdate() {
                this.commonProperties = new JSONObject();
                this.prevVer = null;
                this.currVer = null;
            }

            public AppUpdate setPrevVersion(String prevVer) {
                this.prevVer = prevVer;
                return this;
            }

            public AppUpdate setCurrVersion(String currVer) {
                this.currVer = currVer;
                return this;
            }

            public String getPrevVer() {
                return this.prevVer;
            }

            public String getCurrVer() {
                return this.currVer;
            }

            public AppUpdate setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("AppUpdate");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.prevVer != null) obj.put(CompatConstants.ABX_APP_PREV_VER, prevVer);
                    if (this.currVer != null) obj.put(CompatConstants.ABX_APP_CURR_VER, currVer);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "AppUpdate");
                } catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }

                return obj;
            }
        }

        public static class Invite {

            protected JSONObject commonProperties;

            public Invite() {
                this.commonProperties = new JSONObject();
            }

            public Invite setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Invite");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "Invite");
                } catch (Exception e){
                    AbxLog.e(e.toString(), false);
                }
                return obj;
            }
        }
    }

    public static class CommonSignUpChannel {
        public static final CommonSignUpChannel Kakao = new CommonSignUpChannel("Kakao");
        public static final CommonSignUpChannel Naver = new CommonSignUpChannel("Naver");
        public static final CommonSignUpChannel Line = new CommonSignUpChannel("Line");
        public static final CommonSignUpChannel Google = new CommonSignUpChannel("Google");
        public static final CommonSignUpChannel Facebook = new CommonSignUpChannel("Facebook");
        public static final CommonSignUpChannel Twitter = new CommonSignUpChannel("Twitter");
        public static final CommonSignUpChannel whatsApp = new CommonSignUpChannel("whatsApp");
        public static final CommonSignUpChannel QQ = new CommonSignUpChannel("QQ");
        public static final CommonSignUpChannel WeChat = new CommonSignUpChannel("WeChat");
        public static final CommonSignUpChannel UserId = new CommonSignUpChannel("UserId");
        public static final CommonSignUpChannel ETC = new CommonSignUpChannel("ETC");
        public static final CommonSignUpChannel SkTid = new CommonSignUpChannel("SkTid");
        public static final CommonSignUpChannel AppleId = new CommonSignUpChannel("AppleId");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int UserIdIdx = 10;
        public static final int ETCIdx = 11;
        public static final int SkTidIdx = 12;
        public static final int AppleIdIdx = 13;

        public String channel;

        public CommonSignUpChannel(String channel) {
            this.channel = channel;
        }

        public static CommonSignUpChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(UserId.getChannel())) {
                return UserId;
            } else if (channel.equalsIgnoreCase(SkTid.getChannel())) {
                return SkTid;
            } else if (channel.equalsIgnoreCase(AppleId.getChannel())) {
                return AppleId;
            } else {
                return ETC;
            }

        }

        public static CommonSignUpChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else if (channel == UserIdIdx) {
                return UserId;
            } else if (channel == SkTidIdx) {
                return SkTid;
            } else if (channel == AppleIdIdx) {
                return AppleId;
            } else {
                return ETC;
            }
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommonInviteChannel {
        public static final CommonInviteChannel Kakao = new CommonInviteChannel("Kakao");
        public static final CommonInviteChannel Naver = new CommonInviteChannel("Naver");
        public static final CommonInviteChannel Line = new CommonInviteChannel("Line");
        public static final CommonInviteChannel Google = new CommonInviteChannel("Google");
        public static final CommonInviteChannel Facebook = new CommonInviteChannel("Facebook");
        public static final CommonInviteChannel Twitter = new CommonInviteChannel("Twitter");
        public static final CommonInviteChannel whatsApp = new CommonInviteChannel("whatsApp");
        public static final CommonInviteChannel QQ = new CommonInviteChannel("QQ");
        public static final CommonInviteChannel WeChat = new CommonInviteChannel("WeChat");
        public static final CommonInviteChannel ETC = new CommonInviteChannel("ETC");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int ETCIdx = 10;

        public String channel;

        public CommonInviteChannel(String channel) {
            this.channel = channel;
        }

        public static CommonInviteChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public static CommonInviteChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommerceProductModel {
        protected String productID = "";
        protected String productName = "";
        protected double price = 0.0;
        protected int quantity = 1;
        protected double discount = 0.0;
        protected double sales = 0.0;
        protected AdBrixRm.Currency currency;
        protected CommerceCategoriesModel category;
        protected JSONObject extraAttrs;

        public CommerceProductModel() {
            this.extraAttrs = new JSONObject();
        }

        public String getProductID() {
            return productID;
        }

        public CommerceProductModel setProductID(String productID) {
            this.productID = productID;
            return this;
        }

        public String getProductName() {
            return productName;
        }

        public CommerceProductModel setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public double getPrice() {
            return price;
        }

        public CommerceProductModel setPrice(double price) {
            this.price = price;
            return this;
        }

        public int getQuantity() {
            return quantity;
        }

        public CommerceProductModel setQuantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public double getDiscount() {
            return discount;
        }

        public CommerceProductModel setDiscount(double discount) {
            this.discount = discount;
            return this;
        }

        public AdBrixRm.Currency getCurrency() {
            return currency;
        }

        public CommerceProductModel setCurrency(AdBrixRm.Currency currency) {
            this.currency = currency;
            return this;
        }

        public CommerceCategoriesModel getCategory() {
            return category;
        }

        public CommerceProductModel setCategory(CommerceCategoriesModel category) {
            this.category = category;
            return this;
        }

        public CommerceProductModel setAttrModel(AttrModel attrModel) {
            if (attrModel == null) return this;

            this.extraAttrs = attrModel.toJSONObject("CommerceProductModel");
            return this;
        }

        public JSONObject getAttrs() {
            return extraAttrs;
        }
    }

    public static class CommerceCategoriesModel {
        static final int MAX_COMMERCE_CATEGORY_NUMBER = 5;
        public LinkedList<String> categoriesLinkedList = new LinkedList<String>();

        public CommerceCategoriesModel() {
        }

        public CommerceCategoriesModel setCategory(String category) {
            if (categoriesLinkedList.size() >= MAX_COMMERCE_CATEGORY_NUMBER){
                AbxLog.d("Skip adding more categories, MAX_COMMERCE_CATEGORY_NUMBER is " + MAX_COMMERCE_CATEGORY_NUMBER, true);
                return this;
            }
            if (CommonUtils.isNullOrEmpty(category)){
                return this;
            }
            this.categoriesLinkedList.add(category);
            return this;
        }
    }

    public static class Currency {
        public static final Currency KR_KRW = new Currency("KR", "KRW");
        public static final Currency US_USD = new Currency("US", "USD");
        public static final Currency JP_JPY = new Currency("JP", "JPY");
        public static final Currency EU_EUR = new Currency("EU", "EUR");
        public static final Currency UK_GBP = new Currency("UK", "GBP");
        public static final Currency CN_CNY = new Currency("CH", "CNY");
        public static final Currency TW_TWD = new Currency("TW", "TWD");
        public static final Currency HK_HKD = new Currency("HK", "HKD");
        //added new currency 2017-09-08 by john
        public static final Currency ID_IDR = new Currency("ID", "IDR"); //Indonesia
        public static final Currency IN_INR = new Currency("IN", "INR"); //India
        public static final Currency RU_RUB = new Currency("RU", "RUB"); //Russia
        public static final Currency TH_THB = new Currency("TH", "THB"); //Thailand
        public static final Currency VN_VND = new Currency("VN", "VND"); //Vietnam
        public static final Currency MY_MYR = new Currency("MY", "MYR"); //Malaysia

        public String country;
        public String code;

        public Currency(String country, String code) {
            this.country = country;
            this.code = code;
        }

        public static Currency getCurrencyByCurrencyCode(String currencyCode) {

            if (currencyCode.equalsIgnoreCase(KR_KRW.toString())) {
                return KR_KRW;
            } else if (currencyCode.equalsIgnoreCase(US_USD.toString())) {
                return US_USD;
            } else if (currencyCode.equalsIgnoreCase(JP_JPY.toString())) {
                return JP_JPY;
            } else if (currencyCode.equalsIgnoreCase(EU_EUR.toString())) {
                return EU_EUR;
            } else if (currencyCode.equalsIgnoreCase(UK_GBP.toString())) {
                return UK_GBP;
            } else if (currencyCode.equalsIgnoreCase(CN_CNY.toString())) {
                return CN_CNY;
            } else if (currencyCode.equalsIgnoreCase(TW_TWD.toString())) {
                return TW_TWD;
            } else if (currencyCode.equalsIgnoreCase(HK_HKD.toString())) {
                return HK_HKD;
            } else if (currencyCode.equalsIgnoreCase(ID_IDR.toString())) {
                return ID_IDR;
            } else if (currencyCode.equalsIgnoreCase(IN_INR.toString())) {
                return IN_INR;
            } else if (currencyCode.equalsIgnoreCase(RU_RUB.toString())) {
                return RU_RUB;
            } else if (currencyCode.equalsIgnoreCase(TH_THB.toString())) {
                return TH_THB;
            } else if (currencyCode.equalsIgnoreCase(VN_VND.toString())) {
                return VN_VND;
            } else if (currencyCode.equalsIgnoreCase(MY_MYR.toString())) {
                return MY_MYR;
            } else {
                return new Currency(currencyCode, currencyCode);
            }
        }

        public static Currency getCurrencyByCountryCode(String countryCode) {
            if (countryCode.equalsIgnoreCase(KR_KRW.getCountry())) {
                return KR_KRW;
            } else if (countryCode.equalsIgnoreCase(US_USD.getCountry())) {
                return US_USD;
            } else if (countryCode.equalsIgnoreCase(JP_JPY.getCountry())) {
                return JP_JPY;
            } else if (countryCode.equalsIgnoreCase(EU_EUR.getCountry())) {
                return EU_EUR;
            } else if (countryCode.equalsIgnoreCase(UK_GBP.getCountry())) {
                return UK_GBP;
            } else if (countryCode.equalsIgnoreCase(CN_CNY.getCountry())) {
                return CN_CNY;
            } else if (countryCode.equalsIgnoreCase(TW_TWD.getCountry())) {
                return TW_TWD;
            } else if (countryCode.equalsIgnoreCase(HK_HKD.getCountry())) {
                return HK_HKD;
            } else if (countryCode.equalsIgnoreCase(ID_IDR.getCountry())) {
                return ID_IDR;
            } else if (countryCode.equalsIgnoreCase(IN_INR.getCountry())) {
                return IN_INR;
            } else if (countryCode.equalsIgnoreCase(RU_RUB.getCountry())) {
                return RU_RUB;
            } else if (countryCode.equalsIgnoreCase(TH_THB.getCountry())) {
                return TH_THB;
            } else if (countryCode.equalsIgnoreCase(VN_VND.getCountry())) {
                return VN_VND;
            } else if (countryCode.equalsIgnoreCase(MY_MYR.getCountry())) {
                return MY_MYR;
            } else {
                return new Currency(countryCode, countryCode);
            }
        }

        public String getCountry() {
            return country;
        }

        @Override
        public String toString() {
            return code;
        }
    }

    public static class CommercePaymentMethod {
        public static final CommercePaymentMethod CreditCard = new CommercePaymentMethod("CreditCard");
        public static final CommercePaymentMethod BankTransfer = new CommercePaymentMethod("BankTransfer");
        public static final CommercePaymentMethod MobilePayment = new CommercePaymentMethod("MobilePayment");
        public static final CommercePaymentMethod ETC = new CommercePaymentMethod("ETC");

        public static final int CreditCardIdx = 1;
        public static final int BankTransferIdx = 2;
        public static final int MobilePaymentIdx = 3;
        public static final int ETCIdx = 4;


        public String method;

        public CommercePaymentMethod(String method) {
            this.method = method;
        }

        public static CommercePaymentMethod getMethodByMethodCode(String mehod) {
            if (mehod.equalsIgnoreCase(CreditCard.getMethod())) {
                return CreditCard;
            } else if (mehod.equalsIgnoreCase(BankTransfer.getMethod())) {
                return BankTransfer;
            } else if (mehod.equalsIgnoreCase(MobilePayment.getMethod())) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public static CommercePaymentMethod getMethodByMethodCode(int mehod) {
            if (mehod == CreditCardIdx) {
                return CreditCard;
            } else if (mehod == BankTransferIdx) {
                return BankTransfer;
            } else if (mehod == MobilePaymentIdx) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public String getMethod() {
            return method;
        }

        @Override
        public String toString() {
            return method;
        }
    }

    public static class CommerceSharingChannel {
        public static final CommerceSharingChannel Facebook = new CommerceSharingChannel("Facebook");
        public static final CommerceSharingChannel KakaoTalk = new CommerceSharingChannel("KakaoTalk");
        public static final CommerceSharingChannel KakaoStory = new CommerceSharingChannel("KakaoStory");
        public static final CommerceSharingChannel Line = new CommerceSharingChannel("Line");
        public static final CommerceSharingChannel whatsApp = new CommerceSharingChannel("whatsApp");
        public static final CommerceSharingChannel QQ = new CommerceSharingChannel("QQ");
        public static final CommerceSharingChannel WeChat = new CommerceSharingChannel("WeChat");
        public static final CommerceSharingChannel SMS = new CommerceSharingChannel("SMS");
        public static final CommerceSharingChannel Email = new CommerceSharingChannel("Email");
        public static final CommerceSharingChannel copyUrl = new CommerceSharingChannel("copyUrl");
        public static final CommerceSharingChannel ETC = new CommerceSharingChannel("ETC");

        public String channel;

        public CommerceSharingChannel(String channel) {
            this.channel = channel;
        }

        public static CommerceSharingChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(KakaoTalk.getChannel())) {
                return KakaoTalk;
            } else if (channel.equalsIgnoreCase(KakaoStory.getChannel())) {
                return KakaoStory;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(SMS.getChannel())) {
                return SMS;
            } else if (channel.equalsIgnoreCase(Email.getChannel())) {
                return Email;
            } else if (channel.equalsIgnoreCase(copyUrl.getChannel())) {
                return copyUrl;
            } else if (channel.equalsIgnoreCase(ETC.getChannel())) {
                return ETC;
            } else {
                return new CommerceSharingChannel(channel);
            }
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class PushProperties {
        protected long second = 0;
        protected int eventId = 0;
        protected String contentText = "";
        protected String summaryText = "";
        protected String bigContentTitle = "";
        protected String title = "";
        protected String deepLinkUri = "";

        public PushProperties() {

        }

        public String getDeepLinkUri() {
            return deepLinkUri;
        }

        public String getTitle() {
            return title;
        }

        public long getSecond() {
            return second;
        }

        public String getContentText() {
            return contentText;
        }

        public String getSummaryText() {
            return summaryText;
        }

        public String getBigContentTitle() {
            return bigContentTitle;
        }

        public int getEventId() {
            return eventId;
        }

    }

    public static class BigTextPushProperties extends PushProperties {
        private String bigText = "";

        public BigTextPushProperties() {

        }

        public static BigTextPushProperties fromJSONObject(JSONObject jsonObject) {

            BigTextPushProperties bigTextPushProperties = new BigTextPushProperties();

            try {
                bigTextPushProperties
                        .setSecond(jsonObject.getLong("second"))
                        .setEventId(jsonObject.getInt("eventId"))
                        .setTitle(CommonUtils.convertNullStringToNull(jsonObject.getString("title")))
                        .setContentText(CommonUtils.convertNullStringToNull(jsonObject.getString("contentText")))
                        .setSummaryText(CommonUtils.convertNullStringToNull(jsonObject.getString("summaryText")))
                        .setBigContentTitle(CommonUtils.convertNullStringToNull(jsonObject.getString("bigContentTitle")))
                        .setBigText(CommonUtils.convertNullStringToNull(jsonObject.getString("bigText")))
                        .setDeepLinkUri(CommonUtils.convertNullStringToNull(jsonObject.getString("deepLinkUri")));
            } catch (Exception e){
                AbxLog.e(e.toString(), false);
            }

            return bigTextPushProperties;
        }

        public String getBigText() {
            return bigText;
        }

        public BigTextPushProperties setBigText(String bigText) {
            this.bigText = bigText;
            return this;
        }

        public BigTextPushProperties setTitle(String title) {
            this.title = title;
            return this;
        }

        public BigTextPushProperties setSecond(long second) {
            this.second = second;
            return this;
        }

        public BigTextPushProperties setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public BigTextPushProperties setSummaryText(String summaryText) {
            this.summaryText = summaryText;
            return this;
        }

        public BigTextPushProperties setBigContentTitle(String bigContentTitle) {
            this.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigTextPushProperties setEventId(int eventId) {
            this.eventId = eventId;
            return this;
        }

        public BigTextPushProperties setDeepLinkUri(String deepLinkUri) {
            this.deepLinkUri = deepLinkUri;
            return this;
        }

        public JSONObject toJSONObject() {
            JSONObject obj = new JSONObject();
            try {
                obj
                        .put("second", second)
                        .put("eventId", eventId)
                        .put("title", title)
                        .put("contentText", contentText)
                        .put("summaryText", summaryText)
                        .put("bigContentTitle", bigContentTitle)
                        .put("bigText", bigText)
                        .put("deepLinkUri", deepLinkUri);
            } catch (Exception e){
                AbxLog.e(e.toString(), false);
            }
            return obj;
        }
    }

    public static class BigPicturePushProperties extends PushProperties {

        private String bigPictureUrl = "";
        private int resourceId = 0;

        public BigPicturePushProperties() {

        }

        public static BigPicturePushProperties fromJSONObject(JSONObject jsonObject) {

            BigPicturePushProperties bigPicturePushProperties = new BigPicturePushProperties();

            try {
                bigPicturePushProperties
                        .setSecond(jsonObject.getLong("second"))
                        .setEventId(jsonObject.getInt("eventId"))
                        .setResourceId(jsonObject.getInt("resourceId"))
                        .setTitle(CommonUtils.convertNullStringToNull(jsonObject.getString("title")))
                        .setContentText(CommonUtils.convertNullStringToNull(jsonObject.getString("contentText")))
                        .setSummaryText(CommonUtils.convertNullStringToNull(jsonObject.getString("summaryText")))
                        .setBigContentTitle(CommonUtils.convertNullStringToNull(jsonObject.getString("bigContentTitle")))
                        .setBigPictureUrl(CommonUtils.convertNullStringToNull(jsonObject.getString("bigPictureUrl")))
                        .setDeepLinkUri(CommonUtils.convertNullStringToNull(jsonObject.getString("deepLinkUri")));
            } catch (Exception e){
                AbxLog.e(e.toString(), false);
            }

            return bigPicturePushProperties;
        }

        public int getResourceId() {
            return resourceId;
        }

        public BigPicturePushProperties setResourceId(int resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public String getBigPictureUrl() {
            return bigPictureUrl;
        }

        public BigPicturePushProperties setBigPictureUrl(String bigPictureUrl) {
            this.bigPictureUrl = bigPictureUrl;
            return this;
        }

        public BigPicturePushProperties setTitle(String title) {
            this.title = title;
            return this;
        }

        public BigPicturePushProperties setSecond(long second) {
            this.second = second;
            return this;
        }

        public BigPicturePushProperties setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public BigPicturePushProperties setSummaryText(String summaryText) {
            this.summaryText = summaryText;
            return this;
        }

        public BigPicturePushProperties setBigContentTitle(String bigContentTitle) {
            this.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigPicturePushProperties setEventId(int eventId) {
            this.eventId = eventId;
            return this;
        }

        public BigPicturePushProperties setDeepLinkUri(String deepLinkUri) {
            this.deepLinkUri = deepLinkUri;
            return this;
        }

        public JSONObject toJSONObject() {
            JSONObject obj = new JSONObject();
            try {
                obj
                        .put("second", second)
                        .put("eventId", eventId)
                        .put("resourceId", resourceId)
                        .put("title", title)
                        .put("contentText", contentText)
                        .put("summaryText", summaryText)
                        .put("bigContentTitle", bigContentTitle)
                        .put("bigPictureUrl", bigPictureUrl)
                        .put("deepLinkUri", deepLinkUri);
            } catch (Exception e){
                AbxLog.e(e.toString(), false);
            }
            return obj;
        }
    }

    public static class AbxRemotePushModel {
        public final String title;
        public final String body;
        public final String bigTextTitle;
        public final String bigTextBody;
        public final String summaryText;
        public final String imageUrl;
        public final String largeIconUrl;
        public final boolean genWhileRun;
        public final boolean genVibe;
        public final boolean genSound;
        public final String deeplinkUrl;
        public final JSONObject deeplinkJson;

        public final String campaignId;
        public final int campaignRevisionNo;
        public final String stepId;
        public final String cycleTime;
        public final int notificationId;

        AbxRemotePushModel(JSONObject pushJson) throws JSONException {
            JSONObject abxGfFcm;
            JSONObject alert;

            try {
                abxGfFcm = pushJson.getJSONObject("abx:gf:fcm");
                alert = abxGfFcm.getJSONObject("alert");
            } catch (JSONException e) {
                throw new JSONException("Adbrix push data don't exist!\n" + e.getMessage());
            }

            try {
                this.campaignId = abxGfFcm.getString(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_ID);
                this.campaignRevisionNo = abxGfFcm.getInt(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_REVISION_NO);
                this.stepId = abxGfFcm.getString(ABXConstants.GROWTH_EVENT_KEY_STEP_ID);
                this.cycleTime = abxGfFcm.getString(ABXConstants.GROWTH_EVENT_KEY_CYCLE_TIME);
            } catch (JSONException e) {
                throw new JSONException("Adbrix push tracking parameters don't exist!\n" + e.getMessage());
            }

            this.title = alert.optString("title", "");
            this.body = alert.optString("body", "");
            this.bigTextTitle = alert.optString("big_text_title", "");
            this.bigTextBody = alert.optString("big_text_body", "");
            this.summaryText = alert.optString("summary_text", "");
            this.imageUrl = alert.optString("img", "");
            this.largeIconUrl = alert.optString("large_icon", "");
            this.genWhileRun = abxGfFcm.optBoolean(ABXConstants.PUSH_REMOTE_KEY_PUSH_ALWAYS_SHOWN, false);
            this.genVibe = abxGfFcm.optBoolean(ABXConstants.PUSH_REMOTE_KEY_PUSH_GEN_VIBE, false);
            this.genSound = abxGfFcm.optBoolean(ABXConstants.PUSH_REMOTE_KEY_PUSH_GEN_SOUND, false);
            this.deeplinkUrl = abxGfFcm.optString(ABXConstants.PUSH_REMOTE_KEY_DEEPLINKURL, "");
            this.deeplinkJson = abxGfFcm.optJSONObject(ABXConstants.PUSH_REMOTE_KEY_DEEPLINKJSON);
            this.notificationId = abxGfFcm.optInt(ABXConstants.PUSH_REMOTE_KEY_NOTIFICATION_ID, 0);
        }

        public AbxRemotePushModel(String campaignId, int campaignRevisionNo, String stepId, String cycleTime) throws Exception {
            this.title = null;
            this.body = null;
            this.bigTextTitle = null;
            this.bigTextBody = null;
            this.summaryText = null;
            this.imageUrl = null;
            this.largeIconUrl = null;
            this.genWhileRun = false;
            this.genVibe = false;
            this.genSound = false;
            this.deeplinkUrl = null;
            this.deeplinkJson = null;
            this.notificationId = 0;

            if (!CommonUtils.isNullOrEmpty(campaignId) && !CommonUtils.isNullOrEmpty(stepId) && !CommonUtils.isNullOrEmpty(cycleTime)) {
                this.campaignId = campaignId;
                this.campaignRevisionNo = campaignRevisionNo;
                this.stepId = stepId;
                this.cycleTime = cycleTime;
            } else throw new Exception("Adbrix push tracking parameters don't exist!");
        }

        JSONObject toOpenPushEventParamJson() {
            JSONObject pushParam = new JSONObject();

            try {
                pushParam
                        .put(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_ID, this.campaignId)
                        .put(ABXConstants.GROWTH_EVENT_KEY_STEP_ID, this.stepId)
                        .put(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_REVISION_NO, this.campaignRevisionNo)
                        .put(ABXConstants.GROWTH_EVENT_KEY_CYCLE_TIME, this.cycleTime);

            } catch (JSONException e) {
                AbxLog.e(e.getMessage(), true);
                e.printStackTrace();
            }

            return pushParam;
        }

        @Override
        public String toString() {
            return "AbxRemotePushModel{\n" +
                    " title='" + title + '\'' +
                    ",\n body='" + body + '\'' +
                    ",\n bigTextTitle='" + bigTextTitle + '\'' +
                    ",\n bigTextBody='" + bigTextBody + '\'' +
                    ",\n summaryText='" + summaryText + '\'' +
                    ",\n imageUrl='" + imageUrl + '\'' +
                    ",\n largeIconUrl='" + largeIconUrl + '\'' +
                    ",\n genWhileRun=" + genWhileRun +
                    ",\n genVibe=" + genVibe +
                    ",\n genSound=" + genSound +
                    ",\n deeplinkUrl='" + deeplinkUrl + '\'' +
                    ",\n deeplinkJson=" + deeplinkJson +
                    ",\n campaignId='" + campaignId + '\'' +
                    ",\n campaignRevisionNo=" + campaignRevisionNo +
                    ",\n stepId='" + stepId + '\'' +
                    ",\n cycleTime='" + cycleTime + '\'' +
                    ",\n notificationId=" + notificationId +
                    "\n}";
        }
    }

    public static class LogObserver implements IPairObserver<Integer, String> {

        @Override
        public void update(Integer level, String message) {
            if (!isLogListenerAvailable)
                return;

            if (AdBrixRm.logListener == null) {
                Log.w("abxrm", "LogListener is null!");
                return;
            }

            AdBrixRm.logListener.onPrintLog(level, message);
        }
    }
}
