package com.igaworks.v2.core.push.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;

import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.CompatConstants;
import com.igaworks.v2.core.push.PushController;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.CoreWrapper;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class PushCreator {

    private static int stackingRandomNumber = 8751;
    private static Map<String, Object> settingMap = new HashMap<String, Object>();

    private PushCreator() {
    }

    protected static void initPushSetting(Context context) {
        settingMap.put(CompatConstants.PUSH_PROP_PRIORITY, AbxPushCommonDAO.getPriority());
        settingMap.put(CompatConstants.PUSH_PROP_VISIBILITY, AbxPushCommonDAO.getVisibility());
        settingMap.put(CompatConstants.PUSH_PROP_ARGB, AbxPushCommonDAO.getARGB());
//        settingMap.put("useStacking", AbxPushCommonDAO.getUseStacking(context));

        PackageManager packageManager;
        ApplicationInfo applicationInfo = null;
        Bitmap largeBmp;
        String smallIconName;
        String appName;
        int smallIcon = 0;
        int stringId;


        smallIconName = AbxPushCommonDAO.getSmallIconName();
        packageManager = context.getPackageManager();
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }


        if (applicationInfo != null) {
            stringId = applicationInfo.labelRes;
            appName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
            settingMap.put(CompatConstants.PUSH_PROP_APP_NAME, appName);
        }
        if (!CommonUtils.isNullOrEmpty(smallIconName))
            smallIcon = context.getResources().getIdentifier(smallIconName, "drawable", context.getPackageName());
        /*
        small Icon Setting
         */
        if (smallIcon > 0) {
            AbxLog.d("A custom small icon is set", true);
        } else {
            AbxLog.d("A default small icon is set", true);
            if (applicationInfo != null) {
                smallIcon = applicationInfo.icon;
            }
        }
        settingMap.put(CompatConstants.PUSH_PROP_SMALL_ICON, smallIcon);
        /*
        large Icon Setting
         */
        if (AbxPushCommonDAO.getLargeiconName() != null) {
            largeBmp = PushUtils.getImageResource(context, AbxPushCommonDAO.getLargeiconName());
            AbxLog.d("large icon name : " + AbxPushCommonDAO.getLargeiconName(), true);
            if (largeBmp != null) settingMap.put(CompatConstants.PUSH_PROP_LARGE_ICON, largeBmp);
            else {
                AbxLog.d("Custom large icon is set!", true);
            }
        }
    }

    protected static void generateRemoteNotification(final Context context, final Bundle bundle) {
        if (bundle.getString(ABXConstants.PUSH_REMOTE_FCM_KEY) != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                CoreWrapper.runInBackGroundWithoutOrder(new Runnable() {
                    @Override
                    public void run() {
                        AbxLog.d("Remote Notification Arrived ! ", true);
                        try {
                            String body = "";
                            String title = "";
                            String imageUri = "";
                            String customIcon = "";
                            String bigTextTitle = "";
                            String bigTextBody = "";
                            String summaryText = "";
                            String campaignId = "";
                            String stepId = "";
                            String cycleTime = "";
                            int notificationIdFromServer = 0;
                            int revisionNo = -1;
                            boolean genVibe = true;
                            boolean genSound = true;
                            boolean alwaysShown;
                            Bitmap image = null;
                            Bitmap customIconImage = null;
                            String receivedJSONString;
                            JSONObject objFromServer;
                            JSONObject languageJson;
                            Intent notificationIntent;
//                        JSONArray buttons = null;

                            receivedJSONString = bundle.getString(ABXConstants.PUSH_REMOTE_FCM_KEY);
                            try {
                                CoreWrapper.insertPushData(receivedJSONString);
                                objFromServer = new JSONObject(receivedJSONString);
                            } catch (Exception e) {
                                AbxLog.e("ERROR::Can't create JSON Object from received data", false);
                                return;
                            }

                            if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_CAMPAIGN_ID)) {
                                campaignId = objFromServer.getString(ABXConstants.PUSH_REMOTE_KEY_CAMPAIGN_ID);
                            }
                            if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_STEP_ID)) {
                                stepId = objFromServer.getString(ABXConstants.PUSH_REMOTE_KEY_STEP_ID);
                            }
                            if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_CAMPAIGN_REVISION_NO)) {
                                revisionNo = objFromServer.getInt(ABXConstants.PUSH_REMOTE_KEY_CAMPAIGN_REVISION_NO);
                            }
                            if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_CYCLE_TIME)) {
                                cycleTime = objFromServer.getString(ABXConstants.PUSH_REMOTE_KEY_CYCLE_TIME);
                            }
                            if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_NOTIFICATION_ID)) {
                                notificationIdFromServer = objFromServer.getInt(ABXConstants.PUSH_REMOTE_KEY_NOTIFICATION_ID);
                            }
                            if (PushController.getInstance().checkDuplicatedNotification(notificationIdFromServer)) {
                                AbxLog.d("Duplicated notification.. return", false);
                                return;
                            }

                            JSONObject pushReceiveParam = new JSONObject();
                            pushReceiveParam
                                    .put(ABXConstants.PUSH_REMOTE_KEY_CAMPAIGN_ID, campaignId)
                                    .put(ABXConstants.PUSH_REMOTE_KEY_STEP_ID, stepId)
                                    .put(ABXConstants.PUSH_REMOTE_KEY_CAMPAIGN_REVISION_NO, revisionNo)
                                    .put(ABXConstants.PUSH_REMOTE_KEY_CYCLE_TIME, cycleTime);

                            if (objFromServer.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_ALWAYS_SHOWN)) {
                                if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_PUSH_ALWAYS_SHOWN) && objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_PUSH_ALWAYS_SHOWN) instanceof Boolean) {
                                    alwaysShown = objFromServer.getBoolean(ABXConstants.PUSH_REMOTE_KEY_PUSH_ALWAYS_SHOWN);
                                    if (!alwaysShown && CoreWrapper.inForeground())
                                        return;
                                }
                            }
                            if (objFromServer.has(ABXConstants.PUSH_REMOTE_KEY_CUSTOM_ALERT)) {
                                if (PushUtils.checkHasVaildKey(objFromServer, ABXConstants.PUSH_REMOTE_KEY_CUSTOM_ALERT) && objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_CUSTOM_ALERT) instanceof JSONObject) {

                                    JSONObject customAlertJSON = (JSONObject) objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_CUSTOM_ALERT);
                                    String language = CommonUtils.getLanguage(context);
                                    AbxLog.d("Notification setting default language : " + language, false);
                                    if (customAlertJSON.has(language)) {
                                        languageJson = customAlertJSON.getJSONObject(language);
                                    } else if (customAlertJSON.has(language.substring(0, 2))) {
                                        languageJson = customAlertJSON.getJSONObject(language.substring(0, 2));
                                    } else {
                                        if (objFromServer.has(ABXConstants.PUSH_REMOTE_KEY_ALERT)) {
                                            Object object = objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_ALERT);
                                            if (object != null && object instanceof JSONObject) {
                                                languageJson = (JSONObject) object;
                                            } else return;
                                        } else return;
                                    }
                                    if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_TITLE)) {
                                        if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_TITLE) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_TITLE))) {
                                            title = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_TITLE);
                                        }
                                    }
                                    if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_BODY)) {
                                        if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_BODY) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BODY))) {
                                            body = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BODY);
                                        }
                                    }
                                    if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_BIG_TITLE)) {
                                        if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_BIG_TITLE) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BIG_TITLE)))
                                            bigTextTitle = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BIG_TITLE);
                                    }
                                    if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY)) {
                                        if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_BIG_BODY) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY)))
                                            bigTextBody = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY);
                                    }
                                    if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE)) {
                                        if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE)))
                                            imageUri = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE);
                                    }
                                    if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_SUMMARY_TEXT)) {
                                        if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_SUMMARY_TEXT) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_SUMMARY_TEXT)))
                                            summaryText = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_SUMMARY_TEXT);
                                    }
                                    if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_PUSH_LARGE_ICON) && languageJson.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_LARGE_ICON)) {
                                        if (!CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_PUSH_LARGE_ICON))) {
                                            customIcon = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_PUSH_LARGE_ICON);
                                        }
                                    }
                                }
                            }

                            if (objFromServer.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_GEN_VIBE)) {
                                Object tempObj = objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_PUSH_GEN_VIBE);
                                if (tempObj instanceof Boolean) {
                                    genVibe = (boolean) tempObj;
                                }
                            }
                            if (objFromServer.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_GEN_SOUND)) {
                                Object tempObj = objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_PUSH_GEN_SOUND);
                                if (tempObj instanceof Boolean) {
                                    genSound = (boolean) tempObj;
                                }
                            }

                        /*
                        6월 이후 출시 될 푸시 액션 버튼
                        if (objFromServer.has(IgawConstant.PUSH_REMOTE_KEY_PUSH_BUTTONS)) {
                            buttons = new JSONArray();
                            if (objFromServer.get(IgawConstant.PUSH_REMOTE_KEY_PUSH_BUTTONS) instanceof JSONArray) {
                                buttons = (JSONArray) objFromServer.get(IgawConstant.PUSH_REMOTE_KEY_PUSH_BUTTONS);
                            }
                        }

                        6월 이후 출시 될 알림 요약 기능 Inbox Style notification
                        AbxPushCommonDAO.inserOrReplacePushEvent(title, body, stackingRandomNumber++, System.currentTimeMillis(), 1);
                        if ((boolean) settingMap.get("useStacking") && AbxPushCommonDAO.getStackedPushList(1).length() > 1) {
                            generateInboxStyleNotification(context);
                            return;
                        }
                        */

                            if (CommonUtils.isNullOrEmpty(title)) {
                                title = (String) settingMap.get(CompatConstants.PUSH_PROP_APP_NAME);
                            }

                            Notification.Builder notificationBuilder = getDefaultNotificationBuilder(context, title, body);


                            if (!CommonUtils.isNullOrEmpty(customIcon)) {
                                customIconImage = PushUtils.getBitmapFromURL(customIcon);
                                if (customIconImage != null)
                                    notificationBuilder.setLargeIcon(customIconImage);
                            } else if (settingMap.get(CompatConstants.PUSH_PROP_LARGE_ICON) != null) {
                                notificationBuilder.setLargeIcon((Bitmap) settingMap.get(CompatConstants.PUSH_PROP_LARGE_ICON));
                            }
                                /*
                                Android Group Notifications.. 5월 말에 나오는 푸시에는 포함 X
                                .setGroup("hongukWorld")

                                if(notificationId == 2045) {
                                    notificationBuilder.setGroupSummary(true);
                                    Log.d("HONG", "set Group summary true ");
                                }
                                */

                        /*
                        Android Action Button Feature.. 5월 말에 나오는 푸시에는 포함 X
                        if (null != buttons && buttons.length() > 0 && buttons.length() <= 2) {
                            notificationBuilder = AddActionButton(context, notificationBuilder, buttons);
                        }
                        */

                            if (!CommonUtils.isNullOrEmpty(imageUri))
                                image = PushUtils.getBitmapFromURL(imageUri);
                            if (image != null) {
                                Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle();
                                if (!CommonUtils.isNullOrEmpty(bigTextTitle)) {
                                    bigPictureStyle.setBigContentTitle(bigTextTitle);
                                } else {
                                    bigPictureStyle.setBigContentTitle(title);
                                }
                                if (!CommonUtils.isNullOrEmpty(summaryText)) {
                                    bigPictureStyle.setSummaryText(summaryText);
                                }
                                bigPictureStyle.bigPicture(image);
                                notificationBuilder.setStyle(bigPictureStyle);
                            } else if (!CommonUtils.isNullOrEmpty(bigTextBody)) {
                                Notification.BigTextStyle bigTextStyle = new Notification.BigTextStyle();
                                bigTextStyle.bigText(PushUtils.fromHtml(bigTextBody));
                                if (!CommonUtils.isNullOrEmpty(bigTextTitle)) {
                                    bigTextStyle.setBigContentTitle(bigTextTitle);
                                }
                                if (!CommonUtils.isNullOrEmpty(summaryText)) {
                                    bigTextStyle.setSummaryText(summaryText);
                                }
                                notificationBuilder.setStyle(bigTextStyle);
                            }

                            Bundle remotePushData = new Bundle();
                            remotePushData.putString(ABXConstants.PUSH_REMOTE_DATA, receivedJSONString);

                            notificationIntent = new Intent(context, AbxPushReceiver.class);
                            notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
                            notificationIntent.setAction(CompatConstants.REMOTE_PUSH_OPEN_CLICKED);
                            notificationIntent.putExtras(remotePushData);

                            notifyPush(context, notificationIdFromServer, notificationIntent, notificationBuilder, genSound, genVibe);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
            }
        } else {
            AbxLog.e("ERROR::Can't send push : There is no information of PUSH notification.", true);
        }
    }

    protected static void generateBigTextPushEvent(Context context, Bundle bundle) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            Bitmap largeIcon;
            int eventId;
            boolean alwaysIsShown;
            String contentText;
            String bigContentTitle;
            String summaryText;
            String title;
            String bigText;
            String deepLinkUri;
            AdBrixRm.BigTextPushProperties bigTextPushProperties;
            Intent notificationIntent;

            alwaysIsShown = bundle.getBoolean(CompatConstants.PUSH_USER_INPUT_ALWAYS_IS_SHOWN, true);
            if (!alwaysIsShown && CoreWrapper.inForeground()) return;

            if (bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES) == null) {
                AbxLog.d("ERROR :: Properties of notification = null", false);
                return;
            }

            try {
                JSONObject bigTextJson = new JSONObject(bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES));
                bigTextPushProperties = AdBrixRm.BigTextPushProperties.fromJSONObject(bigTextJson);
            } catch (JSONException e) {
                e.printStackTrace();
                bigTextPushProperties = new AdBrixRm.BigTextPushProperties();
            }
        /*
        FROM PROPERTIES INPUTTED
         */
            bigContentTitle = bigTextPushProperties.getBigContentTitle();
            bigText = bigTextPushProperties.getBigText();
            summaryText = bigTextPushProperties.getSummaryText();
            contentText = bigTextPushProperties.getContentText();
            title = bigTextPushProperties.getTitle();
            eventId = bigTextPushProperties.getEventId();

            if (CommonUtils.isNullOrEmpty(title)) {
                title = (String) settingMap.get(CompatConstants.PUSH_PROP_APP_NAME);
            }


//        if ((boolean) settingMap.get("useStacking") && AbxPushCommonDAO.getStackedPushList(1).length() > 1) {
//            generateInboxStyleNotification(context);
//            return;
//        }

            Notification.Builder notificationBuilder = getDefaultNotificationBuilder(context, title, contentText);

            largeIcon = (Bitmap) settingMap.get(CompatConstants.PUSH_PROP_LARGE_ICON);
            if (largeIcon != null) notificationBuilder.setLargeIcon(largeIcon);

            Notification.BigTextStyle bigTextStyle = new Notification.BigTextStyle();
            if (!CommonUtils.isNullOrEmpty(bigText))
                bigTextStyle.bigText(PushUtils.fromHtml(bigText));
            if (!CommonUtils.isNullOrEmpty(bigContentTitle))
                bigTextStyle.setBigContentTitle(PushUtils.fromHtml(bigContentTitle));
            else bigTextStyle.setBigContentTitle(PushUtils.fromHtml(title));

            if (!CommonUtils.isNullOrEmpty(summaryText))
                bigTextStyle.setSummaryText(PushUtils.fromHtml(summaryText));
            notificationBuilder.setStyle(bigTextStyle);

            Bundle propBundle = new Bundle();
            propBundle.putString(CompatConstants.PUSH_TEXT_PROPERTIES, bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES));

            notificationIntent = new Intent(context, AbxPushReceiver.class);
            notificationIntent.setAction(CompatConstants.LOCAL_PUSH_OPEN_CLCKED);
            notificationIntent.putExtras(propBundle);

            notifyPush(context, eventId, notificationIntent, notificationBuilder, true, true);
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }

    protected static void generateBigPicturePushEvent(final Context context, final Bundle bundle) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            CoreWrapper.runInBackGroundWithoutOrder(new Runnable() {
                @Override
                public void run() {
                    Bitmap image;
                    Bitmap largeIcon;
                    int resId;
                    int eventId;
                    boolean alwaysIsShown;
                    String contentText;
                    String bigContentTitle;
                    String summaryText;
                    String bigPictureUrl;
                    String title;
                    String deepLinkUri;
                    AdBrixRm.BigPicturePushProperties bigPicturePushProperties;
                    Intent notificationIntent;

                    alwaysIsShown = bundle.getBoolean(CompatConstants.PUSH_USER_INPUT_ALWAYS_IS_SHOWN, true);
                    if (!alwaysIsShown && CoreWrapper.inForeground()) return;

                    if (bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES) == null) {
                        AbxLog.d("ERROR :: Properties of notification = null", false);
                        return;
                    }

                    try {
                        JSONObject bigPictureJson = new JSONObject(bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES));
                        bigPicturePushProperties = AdBrixRm.BigPicturePushProperties.fromJSONObject(bigPictureJson);
                    } catch (JSONException e) {
                        e.printStackTrace();
                        bigPicturePushProperties = new AdBrixRm.BigPicturePushProperties();
                    }

                    contentText = bigPicturePushProperties.getContentText();
                    bigContentTitle = bigPicturePushProperties.getBigContentTitle();
                    summaryText = bigPicturePushProperties.getSummaryText();
                    bigPictureUrl = bigPicturePushProperties.getBigPictureUrl();
                    eventId = bigPicturePushProperties.getEventId();
                    resId = bigPicturePushProperties.getResourceId();
                    title = bigPicturePushProperties.getTitle();
                    if (CommonUtils.isNullOrEmpty(title)) {
                        title = (String) settingMap.get(CompatConstants.PUSH_PROP_APP_NAME);
                    }

                    image = null;
                    if (resId != 0) {
                        image = PushUtils.getImageResource(context, resId);
                    } else {
                        if (!bigPictureUrl.isEmpty())
                            image = PushUtils.getBitmapFromURL(bigPictureUrl);
                    }


                /*
                if ((boolean) settingMap.get("useStacking") && AbxPushCommonDAO.getStackedPushList(1).length() > 1) {
                    generateInboxStyleNotification(context);
                    return;
                }
                */

                    Notification.Builder notificationBuilder = getDefaultNotificationBuilder(context, title, contentText);

                    largeIcon = (Bitmap) settingMap.get(CompatConstants.PUSH_PROP_LARGE_ICON);
                    if (largeIcon != null) notificationBuilder.setLargeIcon(largeIcon);

                    Notification.BigPictureStyle bigPicStyle = new Notification.BigPictureStyle();
                    if (image != null) bigPicStyle.bigPicture(image);
                    if (!CommonUtils.isNullOrEmpty(bigContentTitle))
                        bigPicStyle.setBigContentTitle(PushUtils.fromHtml(bigContentTitle));
                    else bigPicStyle.setBigContentTitle(PushUtils.fromHtml(title));
                    if (!CommonUtils.isNullOrEmpty(summaryText))
                        bigPicStyle.setSummaryText(PushUtils.fromHtml(summaryText));

                    notificationBuilder.setStyle(bigPicStyle);

                    Bundle propBundle = new Bundle();
                    propBundle.putString(CompatConstants.PUSH_PICTURE_PROPERTIES, bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES));

                    notificationIntent = new Intent(context, AbxPushReceiver.class);
                    notificationIntent.setAction(CompatConstants.LOCAL_PUSH_OPEN_CLCKED);
                    notificationIntent.putExtras(propBundle);

                    notifyPush(context, eventId, notificationIntent, notificationBuilder, true, true);
                }
            });
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }

    private static Notification.Builder addActionButton(Context context, Notification.Builder notificationBuilder, JSONArray buttons) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            for (int i = 0; i < buttons.length(); i++) {
                try {
                    String buttonTitle = "";
                    String buttonDeepLinkUrl = "";
                    JSONObject temp = (JSONObject) buttons.get(i);
                    if (temp.has("title") && temp.getString("title") != null) {
                        buttonTitle = temp.getString("title");
                    }
                    if (temp.has("buttonDeepLinkUrl") && temp.getString("buttonDeepLinkUrl") != null) {
                        buttonDeepLinkUrl = temp.getString("buttonDeepLinkUrl");
                    }

                    Intent newIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                    if (!CommonUtils.isNullOrEmpty(buttonDeepLinkUrl)) {
                        newIntent = new Intent(context, AbxPushReceiver.class);
                        Bundle bundle = new Bundle();
                        bundle.putString("buttonDeepLinkUrl", buttonDeepLinkUrl);
                        newIntent.putExtras(bundle);
                        AbxLog.d("Forwarding to specific URL using browser : " +
                                Uri.parse(buttonDeepLinkUrl), false);
                    }

                    if (newIntent != null) {
                        newIntent.setAction(CompatConstants.PUSH_BUTTON_CLICKED);
                    }
                    PendingIntent takenPendingIntent = PendingIntent.getBroadcast(context, i, newIntent, 0);

                    Bitmap bitmap = PushUtils.getBitmapFromURL(temp.getString("buttonImg"));
                    ImageView icon = new ImageView(context);
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                        icon.setId(View.generateViewId()); //set your own id;
                    } else {
                        int tempId = (int) (Math.random() * 10000);
                        icon.setId(tempId);
                    }
                    icon.setImageBitmap(bitmap);

                    if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT_WATCH) {
                        Notification.Action action = new Notification.Action.Builder(icon.getId(), buttonTitle, takenPendingIntent).build();
                        notificationBuilder.addAction(action);
                    } else
                        notificationBuilder.addAction(icon.getId(), buttonTitle, takenPendingIntent);


                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            return notificationBuilder;
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
            return null;
        }
    }

    protected static void generateInboxStyleNotification(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            try {
                NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                notificationManager.cancelAll();
            } catch (Exception e1) {
                e1.printStackTrace();
            }

            JSONArray stackedPushList = AbxPushCommonDAO.getStackedPushList(1);
            String stackingTitle = AbxPushCommonDAO.getStackingContentTitle();
            String stackingContent = AbxPushCommonDAO.getStackingContentText();
            String stackingBigContentTitle = AbxPushCommonDAO.getStackingBigContentTitle();
            String stackingBigContentSummaryText = AbxPushCommonDAO.getStackingBigContentSummaryText();
            boolean useTitleforStacking = AbxPushCommonDAO.getUseTitleforStacking();

            Bitmap largeIcon = (Bitmap) settingMap.get(CompatConstants.PUSH_PROP_LARGE_ICON);

            if (CommonUtils.isNullOrEmpty(stackingTitle))
                stackingTitle = PushUtils.fromHtml((String) settingMap.get("title")).toString();

            if (CommonUtils.isNullOrEmpty(stackingContent))
                stackingContent = "";

            Notification.Builder notificationBuilder = getDefaultNotificationBuilder(context, stackingTitle, stackingContent);

            if (largeIcon != null) notificationBuilder.setLargeIcon(largeIcon);

            Notification.InboxStyle inboxStyle = new Notification.InboxStyle();
            if (!CommonUtils.isNullOrEmpty(stackingBigContentTitle))
                inboxStyle.setBigContentTitle(PushUtils.fromHtml(stackingBigContentTitle));
            else {
                if (!CommonUtils.isNullOrEmpty(stackingTitle))
                    inboxStyle.setBigContentTitle(PushUtils.fromHtml(stackingTitle));
                else
                    inboxStyle.setBigContentTitle(PushUtils.fromHtml((String) settingMap.get("title")));
            }
            try {
                for (int i = 0; i < (stackedPushList != null ? stackedPushList.length() : 0); i++) {
                    if (useTitleforStacking) {
                        inboxStyle.addLine(PushUtils.fromHtml(stackedPushList.getJSONObject(i).getString("title")));
                    } else {
                        inboxStyle.addLine(PushUtils.fromHtml(stackedPushList.getJSONObject(i).getString("content")));
                    }
                    if (i > 4) break;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }

            if (!CommonUtils.isNullOrEmpty(stackingBigContentSummaryText)) {
                inboxStyle.setSummaryText(stackingBigContentSummaryText);
            }

            notificationBuilder.setStyle(inboxStyle);

            stackingRandomNumber++;

            Intent notificationIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());

            if (notificationIntent != null) {
                notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            }

            notifyPush(context, stackingRandomNumber, notificationIntent, notificationBuilder, true, true);
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }

    public static void createNotificationChannel(Context context, String channelName, String channelDescription, int importance, boolean vibrateEnable) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            AbxLog.d("createNotificationChannel: not supported ", false);
            return;
        }
        /*
        사용자로부터 channel, description 설정값 받아옴
         */
        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

        NotificationChannel channel = new NotificationChannel(
                ABXConstants.PUSH_NOTIFICATION_CHANNEL_ID,
                channelName,
                importance
        );

        channel.setDescription(channelDescription);

        Uri soundUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
        AudioAttributes audioAttributes = new AudioAttributes.Builder()
                .setUsage(AudioAttributes.USAGE_NOTIFICATION)
                .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH)
                .build();
        channel.setSound(soundUri, audioAttributes);

        channel.enableVibration(vibrateEnable);

        channel.setImportance(importance);

        notificationManager.createNotificationChannel(channel);

        AbxLog.d("Creating channel is finished!", true);
    }

    private static Notification.Builder getDefaultNotificationBuilder(Context context, String title, String contentText) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            int smallIcon = (int) settingMap.get(CompatConstants.PUSH_PROP_SMALL_ICON);
            int argb = (int) settingMap.get(CompatConstants.PUSH_PROP_ARGB);
            int priority = (int) settingMap.get(CompatConstants.PUSH_PROP_PRIORITY);

            Notification.Builder notificationBuilder = PushUtils.createNotificationBuilder(context);
            notificationBuilder
                    .setContentTitle(title) //need to get form sharedPreference
                    .setContentText(contentText)
                    .setPriority(priority)
                    .setSmallIcon(smallIcon);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                notificationBuilder.setVisibility((int) settingMap.get(CompatConstants.PUSH_PROP_VISIBILITY));
            }

            if (argb != -1) {
                if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    try {
                        notificationBuilder.setColor(argb);
                        AbxLog.d("Use custom brand color. Color code: " + Integer.toHexString(argb), false);
                    } catch (Exception err) {
                        AbxLog.e("Notification.Builder issue: " + err.getMessage(), false);
                        err.printStackTrace();
                    }
                }
            }

            return notificationBuilder;
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
            return null;
        }
    }

    private static void notifyPush(Context context, int eventId, Intent notificationIntent, Notification.Builder notificationBuilder,
                                   boolean genSound, boolean genVibe) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            PendingIntent contentIntent = PendingIntent.getBroadcast(context, eventId,
                    notificationIntent, PendingIntent.FLAG_CANCEL_CURRENT);
            notificationBuilder.setContentIntent(contentIntent);

            Notification notification = notificationBuilder.build();
            notification.flags |= Notification.FLAG_AUTO_CANCEL; // Set Auto Cancel Flag
            if (genSound)
                notification.defaults |= Notification.DEFAULT_SOUND; // Play default notification sound
            if (genVibe)
                notification.defaults |= Notification.DEFAULT_VIBRATE; // Vibrate if vibrate is enabled

            NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            notificationManager.notify(eventId, notification);
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }
}
