package com.igaworks.v2.core;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.CommonUtils;

public class AbxCommon {

    private AbxCommon() {
    }

    // 상품 결제
    public static void purchase(String orderID, List<AdBrixRm.CommerceProductModel> purchaseList, double discount, double deliveryCharge, AdBrixRm.CommercePaymentMethod paymentMethod) {
        AdBrixRm.CommonProperties.Purchase attr = null;
        purchase(orderID, purchaseList, discount, deliveryCharge, paymentMethod, attr);
    }

    public static void purchase(String orderID, List<AdBrixRm.CommerceProductModel> purchaseList, double discount, double deliveryCharge, AdBrixRm.CommercePaymentMethod paymentMethod, AdBrixRm.CommonProperties.Purchase commerceExtraAttributes) {
        purchase(orderID, purchaseList, 0, discount, deliveryCharge, paymentMethod, commerceExtraAttributes);
    }

    public static void purchase(String orderID, List<AdBrixRm.CommerceProductModel> purchaseList, double orderSales, double discount, double deliveryCharge, AdBrixRm.CommercePaymentMethod paymentMethod) {
        AdBrixRm.CommonProperties.Purchase attr = null;
        purchase(orderID, purchaseList, orderSales, discount, deliveryCharge, paymentMethod, attr);
    }

    public static void purchase(String orderID, List<AdBrixRm.CommerceProductModel> purchaseList, double orderSales, double discount, double deliveryCharge, AdBrixRm.CommercePaymentMethod paymentMethod, AdBrixRm.CommonProperties.Purchase commerceExtraAttributes) {
        if (AdBrixRm.isAdbrixDisabled()) return;

        if (purchaseList == null) {
            AbxLog.i("purchase: purchaseList is null >> Auto change null to empty list", true);
            purchaseList = new ArrayList<>();
        }

        if (commerceExtraAttributes == null)
            commerceExtraAttributes = new AdBrixRm.CommonProperties.Purchase();
        JSONObject attrs = commerceExtraAttributes.toJSONObject();
        JSONObject cloneCommerceExtraAttributes = ExtraUtils.cloneJSONObject(attrs);

        JSONObject attributes = (cloneCommerceExtraAttributes == null) ? new JSONObject() : cloneCommerceExtraAttributes;
        try {
            attributes.put(CompatConstants.ABX_ORDER_ID, CommonUtils.replaceWithJSONNull(orderID));
            attributes.put(CompatConstants.ABX_DISCOUNT, discount);
            attributes.put(CompatConstants.ABX_DELIVERY_CHARGE, deliveryCharge);
            if (paymentMethod == null) {
                paymentMethod = new AdBrixRm.CommercePaymentMethod(null);
                AbxLog.i("purchase: paymentMethod is null >> Auto change null to empty CommercePaymentMethod", true);
            }
            attributes.put(CompatConstants.ABX_PAYMENT_METHOD, CommonUtils.replaceWithJSONNull(paymentMethod.toString()));
            attributes.put(CompatConstants.ABX_ORDER_SALES, orderSales);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        AdBrixRm.postSameAbxEvent(purchaseList, CompatConstants.EVENT_PURCHASE, attributes);
    }

    //회원가입
    public static void signUp(AdBrixRm.CommonSignUpChannel signUpChannel) {
        signUp(signUpChannel, null);
    }

    public static void signUp(AdBrixRm.CommonSignUpChannel signUpChannel, AdBrixRm.CommonProperties.SignUp commonProperty) {

        if (AdBrixRm.isAdbrixDisabled()) return;
        if (signUpChannel == null) {
            AbxLog.i("signup: signUpChannel is null >> Auto change null to empty CommonSignUpChannel", true);
            signUpChannel = new AdBrixRm.CommonSignUpChannel(null);
        }

        if (commonProperty == null) commonProperty = new AdBrixRm.CommonProperties.SignUp();

        JSONObject property = commonProperty.toJSONObject();
        JSONObject cloneCommonExtraAttributes = ExtraUtils.cloneJSONObject(property);
        JSONObject attributes = (cloneCommonExtraAttributes == null) ? new JSONObject() : cloneCommonExtraAttributes;
        try {
            attributes.put(CompatConstants.ABX_SIGN_CHANNEL, CommonUtils.replaceWithJSONNull(signUpChannel.toString()));
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_SIGN_UP, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void useCredit() {
        useCredit(null);
    }

    public static void useCredit(AdBrixRm.CommonProperties.UseCredit commonProperty) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commonProperty == null) {
            AbxLog.i("useCredit: useCredit property is null >> Auto change null to empty UseCredit", true);
            commonProperty = new AdBrixRm.CommonProperties.UseCredit();
        }

        JSONObject property = commonProperty.toJSONObject();
        JSONObject cloneCommonExtraAttributes = ExtraUtils.cloneJSONObject(property);
        JSONObject attributes = (cloneCommonExtraAttributes == null) ? new JSONObject() : cloneCommonExtraAttributes;
        try {
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_USE_CREDIT, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //앱 업데이트
    public static void appUpdate(AdBrixRm.CommonProperties.AppUpdate commonProperty) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (commonProperty == null) {
            AbxLog.i("appUpdate: version parameter is null >> Auto change null to empty AppUpdate", true);
            commonProperty = new AdBrixRm.CommonProperties.AppUpdate();
        }
        if (commonProperty.getCurrVer() == null) {
            AbxLog.i("appUpdate: current version parameter is null >> Auto change null to empty string", true);
            commonProperty.currVer = "";
        }

        if (commonProperty.getPrevVer() == null) {
            AbxLog.i("appUpdate: previous version parameter is null >> Auto change null to empty string", true);
            commonProperty.prevVer = "";
        }

        JSONObject property = commonProperty.toJSONObject();
        JSONObject cloneCommonExtraAttributes = ExtraUtils.cloneJSONObject(property);
        JSONObject attributes = (cloneCommonExtraAttributes == null) ? new JSONObject() : cloneCommonExtraAttributes;
        try {
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_APP_UPDATE, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //초대하기
    public static void invite(AdBrixRm.CommonInviteChannel inviteChannel) {
        invite(inviteChannel, null);
    }

    public static void invite(AdBrixRm.CommonInviteChannel inviteChannel, AdBrixRm.CommonProperties.Invite commonProperty) {
        if (AdBrixRm.isAdbrixDisabled()) return;
        if (inviteChannel == null) {
            AbxLog.i("invite: inviteChannel is null >> Auto change null to empty CommonInviteChannel", true);
            inviteChannel = new AdBrixRm.CommonInviteChannel(null);
        }

        if (commonProperty == null) commonProperty = new AdBrixRm.CommonProperties.Invite();

        JSONObject property = commonProperty.toJSONObject();
        JSONObject cloneCommonExtraAttributes = ExtraUtils.cloneJSONObject(property);
        JSONObject attributes = (cloneCommonExtraAttributes == null) ? new JSONObject() : cloneCommonExtraAttributes;

        try {
            attributes.put(CompatConstants.ABX_INVITE_CHANNEL, CommonUtils.replaceWithJSONNull(inviteChannel.toString()));
            AdBrixRm.postAbxEvent(CompatConstants.EVENT_INVITE, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}
