package com.igaworks.v2.core.push.notification;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;

import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.CompatConstants;
import com.igaworks.v2.core.push.PushController;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.CoreWrapper;
import io.adbrix.sdk.utils.CommonUtils;

public class AbxPushReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(final Context context, final Intent intent) {
        // onActivityCreated()에 애드브릭스 연동을 한 경우를 대비한 방어 로직
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            if (!PushController.getInstance().isPushControllerInitialized) {
                AbxLog.d("PUSH :: PushController isn't initialized yet!", true);
                if (PushUtils.waitingForInitCount >= 20) return;

                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        AbxLog.d("Waiting for PushController init : (" + PushUtils.waitingForInitCount + "/20)", true);
                        PushUtils.waitingForInitCount++;
                        onReceive(context, intent);
                    }
                }, 1000);
            } else {
                classifyPushType(context, intent);
            }
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }

    private void classifyPushType(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            if (!PushController.getInstance().getPushEnable()) {
                AbxLog.w("Push service is not available : push enable = " + false, true);
                return;
            } else if (!PushController.getInstance().getOsPushEnable()) {
                AbxLog.w("Push service is not available : os push enable = " + false, true);
                return;
            }

            if (CoreWrapper.isAdbrixPause() || CoreWrapper.isAdbrixAllStop() || CoreWrapper.isGdprForgetMe()) {
                AbxLog.w("Push service is not available : due to SDK status (pause / stop / gdpr)", true);
                return;
            }

            if (intent == null) return;
            Bundle bundle = intent.getExtras();
            if (bundle == null) return;

        /*
        스택된 푸시들 플러시하는 로직 ( 현재는 필요없음 , 6월 이후 출시 )
        if (AbxController.getInstance().inForeground) {
            AbxController.getInstance().getAbx_LogThread().postDelayed(new Runnable() {
                @Override
                public void run() {
                    AbxPushCommonDAO.flushStackedPushList();
                }
            }, 5000);
        }
        */
            if (intent.getAction().equals(CompatConstants.REMOTE_PUSH_OPEN_CLICKED)) {
                remotePushOpenTracking(context, bundle);
                return;
            } else if (intent.getAction().equals(CompatConstants.LOCAL_PUSH_OPEN_CLCKED)) {
                localPushOpenTracking(context, bundle);
                return;
            }
        /*
        else if (intent.getAction().equals(IgawConstant.PUSH_BUTTON_CLICKED)) {
            startPushButtonClickTracking(context,bundle);
            return;
        }
        */

            PushCreator.initPushSetting(context);

            if (intent.getAction().equals(CompatConstants.PUSH_REMOTE_MESSAGE_RECEIVE)) {
                PushCreator.generateRemoteNotification(context, bundle);
            } else if (intent.getAction().equals(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE)) {
                sendLocalNotification(context, bundle);
            } else {
                AbxLog.d("Doesn't match with adbrix ACTION", true);
            }
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }

    private void localPushOpenTracking(Context context, Bundle bundle) {
        Intent newIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());

        if (bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES) != null) {

            AdBrixRm.BigTextPushProperties bigTextPushProperties;
            try {
                JSONObject bigTextJson = new JSONObject(bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES));
                bigTextPushProperties = AdBrixRm.BigTextPushProperties.fromJSONObject(bigTextJson);
            } catch (JSONException e) {
                e.printStackTrace();
                bigTextPushProperties = new AdBrixRm.BigTextPushProperties();
            }

            PushController.getInstance().callBackLocalPushMsg(bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES));
            if (!CommonUtils.isNullOrEmpty(bigTextPushProperties.getDeepLinkUri())) {
                newIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(bigTextPushProperties.getDeepLinkUri()));
            }
        } else if (bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES) != null) {

            AdBrixRm.BigPicturePushProperties bigPicturePushProperties;
            try {
                JSONObject bigPictureJson = new JSONObject(bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES));
                bigPicturePushProperties = AdBrixRm.BigPicturePushProperties.fromJSONObject(bigPictureJson);
            } catch (JSONException e) {
                e.printStackTrace();
                bigPicturePushProperties = new AdBrixRm.BigPicturePushProperties();
            }

            PushController.getInstance().callBackLocalPushMsg(bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES));
            if (!CommonUtils.isNullOrEmpty(bigPicturePushProperties.getDeepLinkUri())) {
                newIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(bigPicturePushProperties.getDeepLinkUri()));
            }
        } else {
            AbxLog.d("ERROR :: can't call back local push msg ", true);
        }
        if (newIntent != null) {
            newIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(newIntent);
        }
    }

    private void startPushButtonClickTracking(Context context, Bundle bundle) {
//        AbxPushCommonDAO.flushStackedPushList();
        AbxLog.d("Push Button Clicked", true);
        String deeplinkUrl = bundle.getString("buttonDeepLinkUrl");
        if (deeplinkUrl != null) {
            NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            notificationManager.cancel(0);
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(deeplinkUrl));
            try {
                context.startActivity(intent);
            } catch (Exception e) {
                AbxLog.d("DeepLinking failed.. please check your host and shceme", true);
            }
        }
    }

    private void remotePushOpenTracking(Context context, Bundle bundle) {
//        AbxPushCommonDAO.flushStackedPushList();

        String deepLinkUrl = "";
        String campaignId = "";
        String stepId = "";
        String cycleTime = "";

        int revisionNo = -1;
        Object deepLinkJson;
        JSONObject pushOpenParam;
        Intent newIntent;
        AbxLog.d("Start open-push tracking", true);

        String temp = bundle.getString(CompatConstants.PUSH_REMOTE_DATA);
        JSONObject pushJsonObject;
        try {

            pushJsonObject = new JSONObject(temp);
            JSONObject callBackJson = new JSONObject();

            newIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (pushJsonObject.has(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKURL)) {
                deepLinkUrl = pushJsonObject.getString(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKURL);
                callBackJson.put(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKURL, deepLinkUrl);
            }
            if (pushJsonObject.has(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKJSON)) {
                deepLinkJson = pushJsonObject.get(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKJSON);
                if (deepLinkJson instanceof JSONObject) {
                    deepLinkJson = pushJsonObject.get(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKJSON);
                    callBackJson.put(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKJSON, deepLinkJson);
                }
            }
            if (pushJsonObject.has(CompatConstants.PUSH_REMOTE_KEY_CAMPAIGN_ID)) {
                campaignId = pushJsonObject.getString(CompatConstants.PUSH_REMOTE_KEY_CAMPAIGN_ID);
            }
            if (pushJsonObject.has(CompatConstants.PUSH_REMOTE_KEY_CYCLE_TIME)) {
                cycleTime = pushJsonObject.getString(CompatConstants.PUSH_REMOTE_KEY_CYCLE_TIME);
            }
            if (pushJsonObject.has(CompatConstants.PUSH_REMOTE_KEY_STEP_ID)) {
                stepId = pushJsonObject.getString(CompatConstants.PUSH_REMOTE_KEY_STEP_ID);
            }
            if (pushJsonObject.has(CompatConstants.PUSH_REMOTE_KEY_CAMPAIGN_REVISION_NO)) {
                revisionNo = pushJsonObject.getInt(CompatConstants.PUSH_REMOTE_KEY_CAMPAIGN_REVISION_NO);
            }
//            if (!CommonUtils.isEmptyString(deepLinkUrl)) {
//                newIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(deepLinkUrl));
//                IgawLogger.Logging(context, IgawConstant.QA_TAG, "Forwarding to specific URL using browser : " +
//                        Uri.parse(deepLinkUrl), IgawLogger.LOG_D, false);
//            }else {
//                newIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
//            }

            if (PushController.getInstance().remotePushMessageListener != null)
                PushController.getInstance().callBackRemotePushMsg(callBackJson.toString());

            newIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(newIntent);
            pushOpenParam = new JSONObject();
            pushOpenParam
                    .put(CompatConstants.PUSH_REMOTE_KEY_CAMPAIGN_ID, campaignId)
                    .put(CompatConstants.PUSH_REMOTE_KEY_STEP_ID, stepId)
                    .put(CompatConstants.PUSH_REMOTE_KEY_CAMPAIGN_REVISION_NO, revisionNo)
                    .put(CompatConstants.PUSH_REMOTE_KEY_CYCLE_TIME, cycleTime);

            CoreWrapper.pushEventTracking(pushOpenParam);

        } catch (Exception e) {
            AbxLog.e("No Activity found to handle Intent : " + e.getMessage(), true);
        }
    }

    private void sendLocalNotification(Context context, final Bundle bundle) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            String style = bundle.getString(CompatConstants.PUSH_PROP_STYLE);
            if (CommonUtils.isNullOrEmpty(style)) return;
            switch (style) {
                case CompatConstants.PUSH_STYLE_BIG_TEXT:
                    PushCreator.generateBigTextPushEvent(context, bundle);
                    break;
                case CompatConstants.PUSH_STYLE_BIG_PICTURE:
                    PushCreator.generateBigPicturePushEvent(context, bundle);
                    break;
                default:
            }
        } else {
            AbxLog.e("App Version is " + Build.VERSION.SDK_INT + ". Should Be higher than " + Build.VERSION_CODES.JELLY_BEAN, true);
        }
    }
}
