package com.igaworks.v2.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.CoreWrapper;
import io.adbrix.sdk.utils.CommonUtils;

public class ExtraUtils {
    private static final int MAX_PRODUCT_NUMBER = 10;

    private ExtraUtils() {
    }

    static JSONArray getProductJsonArray(List<AdBrixRm.CommerceProductModel> products) {
        JSONArray productArray = new JSONArray();

        if (products != null) {
            AbxLog.d("products size ::" + products.size() + "", true);

            for (int i = 0, j = products.size(); i < j; i++) {
                if (i == MAX_PRODUCT_NUMBER) {
                    AbxLog.d("The number of products can not exceed the limited number. number : " + products.size(), true);
                    return productArray;
                }
                AdBrixRm.CommerceProductModel product = products.get(i);

                if (product != null) {
                    JSONObject item = product.getAttrs() == null ? new JSONObject() : product.getAttrs();
                    //item
                    try {
                        item.put(CompatConstants.ABX_ITEM_ID, UUID.randomUUID().toString());
                        item.put(CompatConstants.ABX_PRODUCT_ID, product.getProductID());
                        item.put(CompatConstants.ABX_PRODUCT_NAME, product.getProductName());
                        item.put(CompatConstants.ABX_PRICE, product.getPrice());
                        item.put(CompatConstants.ABX_QUANTITY, product.getQuantity());
                        item.put(CompatConstants.ABX_DISCOUNT, product.getDiscount());
                        item.put(CompatConstants.ABX_SALES, ((product.getPrice() - product.getDiscount()) * ((double) product.getQuantity())));

                        if (product.getCurrency() != null)
                            item.put(CompatConstants.ABX_CURRENCY, product.getCurrency().toString());

                        if (product.getCategory() != null) {
                            Iterator<String> itr = product.getCategory().categoriesLinkedList.iterator();
                            int index = 0;
                            while (itr.hasNext()) {
                                try {
                                    index++;
                                    item.put(CompatConstants.ABX_CATEGORY + index, CommonUtils.replaceWithJSONNull(itr.next()));
                                } catch (Exception e) {
                                }
                            }
                        }
                    } catch (JSONException e) {
                        AbxLog.e("ExtraUtils.getProductJsonArray Error : " + e.getMessage(), true);
                    }
                    productArray.put(item);
                }
            }
        }
        return productArray;
    }

    static JSONArray getProductJsonArrayForPurchase(List<AdBrixRm.CommerceProductModel> products) throws JSONException {
        AbxLog.d("get Products List for Purchase,  products size ::" + products.size() + "", true);
        JSONArray productArray = new JSONArray();
        if (products != null) {
            for (int i = 0, j = products.size(); i < j; i++) {


                /*
                * Remove if statement for purchase event
                * Purchase Event can get all products list (Before, limit 10 count)
                * MikeHan @2020-04-01
                *
                if( i == IgawConstant.MAX_PRODUCT_NUMBER) {
                    Log.d(IgawConstant.QA_TAG, "The number of products can not exceed the limited number. number : "+products.size());
                    return productArray;
                }
                */
                AdBrixRm.CommerceProductModel product = products.get(i);
                if (product != null) {

                    JSONObject item = product.getAttrs() == null ? new JSONObject() : product.getAttrs();
                    //item


                    item.put(CompatConstants.ABX_ITEM_ID, UUID.randomUUID().toString());
                    item.put(CompatConstants.ABX_PRODUCT_ID, product.getProductID());
                    item.put(CompatConstants.ABX_PRODUCT_NAME, product.getProductName());
                    item.put(CompatConstants.ABX_PRICE, product.getPrice());
                    item.put(CompatConstants.ABX_QUANTITY, product.getQuantity());
                    item.put(CompatConstants.ABX_DISCOUNT, product.getDiscount());
                    item.put(CompatConstants.ABX_SALES, ((product.getPrice() - product.getDiscount()) * ((double) product.getQuantity())));
                    if (product.getCurrency() != null)
                        item.put(CompatConstants.ABX_CURRENCY, product.getCurrency().toString());


                    if (product.getCategory() != null) {
                        Iterator<String> itr = product.getCategory().categoriesLinkedList.iterator();
                        int index = 0;
                        while (itr.hasNext()) {
                            try {
                                index++;
                                item.put(CompatConstants.ABX_CATEGORY + index, CommonUtils.replaceWithJSONNull(itr.next()));
                            } catch (Exception e) {
                            }
                        }
                    }
                    productArray.put(item);
                }
            }
        }
        return productArray;

    }

    static JSONObject getCommerceEventParams(JSONArray productArray, JSONObject attributes) {
        JSONObject object = attributes == null ? new JSONObject() : attributes;
        try {
            JSONArray parsedArr = new JSONArray();
            if (productArray != null && productArray.length() > 0) {
                for (int i = 0, j = productArray.length(); i < j; i++) {
                    JSONObject obj = productArray.getJSONObject(i);
                    if (obj != null) {
                        parsedArr.put(CommonUtils.parseValueWithDataType(productArray.getJSONObject(i), CommonUtils.FixType.PREFIX));
                    }
                }
            }
            if (parsedArr.length() != 0) object.put(CompatConstants.ABX_ITEMS, parsedArr);
            else return attributes;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static JSONObject cloneJSONObject(final JSONObject obj) {
        if (obj == null) {
            return null;
        }

        // obj.names returns null if the json obj is empty.
        JSONArray nameArray = null;
        try {
            nameArray = obj.names();
        } catch (ArrayIndexOutOfBoundsException e) {
            AbxLog.d("cloneJSONObject ArrayIndexOutOfBoundsException: " + e.getMessage(), true);
        }
        int len = (nameArray != null ? nameArray.length() : 0);

        String[] names = new String[len];
        for (int i = 0; i < len; i++) {
            names[i] = nameArray.optString(i);
        }

        try {
            return new JSONObject(obj, names);
        } catch (JSONException e) {
            AbxLog.d("cloneJSONObject JSONException: " + e.getMessage(), true);
            return null;
        }
    }

    public static String getStringFromMetaData(Context context, String key) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            if (applicationInfo == null) {
                AbxLog.d("AdBrixRm >> AndroidManifest.xml cannot find (cannot find package)" + "/" + context.getPackageName(), true);
                return "";
            }
            if (applicationInfo.metaData == null) {
                AbxLog.d("AdBrixRm SDK can not find meta-data tags required. Please check that meta-data tag is in the application tag.", true);
                return "";
            } else {
                if (applicationInfo.metaData.containsKey(key)) {
                    String value = String.valueOf(applicationInfo.metaData.get(key));
                    return value;
                } else {
                    AbxLog.d("AdBrixRm >> AndroidManifest.xml setting Error : Check AndroidManifest.xml file -> Missing AdBrixRmAppKey or SecretKey meta tag", true);
                    return "";
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject limitCustomKeyNumber(JSONObject eventCustomProperties, String tag) {

        JSONObject retObj = new JSONObject();
        try {
            if (eventCustomProperties != null) {
                Iterator<?> keys = eventCustomProperties.keys();
                while (keys.hasNext()) {
                    String originKey = (String) keys.next();
                    try {
                        if (retObj.length() >= CoreWrapper.getPropertyMaxSize()) {
                            AbxLog.d(tag + " >> Reached maximum MAX_CUSTOM_PROPERTY_KEYS: " + CoreWrapper.getPropertyMaxSize(), true);
                            break;
                        }
                        if (!CommonUtils.isNullOrEmpty(originKey)) {
                            if (originKey.equals("SPECIAL_KEY") || originKey.equals("abx:deeplink_payload") || originKey.equals("COMMERCE_KEY") || originKey.startsWith("abx:")) {
                                retObj.put(originKey, eventCustomProperties.get(originKey));
                            } else {
                                //자동 변환 규칙 적용
                                String convertKey = convertPermittedStr(originKey);

                                //제약 규칙 적용
                                if (isMatchedPermittedStr(convertKey)) {
                                    retObj.put(convertKey, eventCustomProperties.get(originKey));
                                }
                            }

                        }

                    } catch (JSONException e) {
                        AbxLog.e("eventCustomProperties Error: " + e.toString(), true);
                    }
                }
            }
        } catch (Exception e) {
        }

        return retObj;
    }

    public static String convertPermittedStr(String originStr) {

        String retStr = "";
        if (!CommonUtils.isNullOrEmpty(originStr)) {
            Set<String> keys = createSet().keySet();
            if (keys != null) {
                for (String key : keys) {
                    retStr = originStr.replace(key, String.valueOf(createSet().get(key)));
                }
            }
        }
        return retStr;
    }

    private static Map<String, String> createSet() {
        Map<String, String> permittedMap = new HashMap<>();
        permittedMap.put("-", "_");
        return permittedMap;
    }

    public static boolean isMatchedPermittedStr(String originStr) {

        boolean retBool = false;

        if (!CommonUtils.isNullOrEmpty(originStr)) {
            retBool = Pattern.matches("^[a-z0-9_]*$", originStr);
        }

        if (retBool) {
            AbxLog.i(String.format("Validation REGEX CHECK :: '%s' SUCCESS", originStr), true);
        } else {
            AbxLog.w(String.format("Validation REGEX CHECK :: '%s' Invalid key >> Key can use %s, so remove this key", originStr, "[a-z0-9_]"), true);
        }
        return retBool;
    }
}
