//package com.igaworks.v2.core.push.popup;
//
//import android.app.Activity;
//import android.util.Log;
//
//import com.igaworks.v2.core.push.popup.Model.InAppBar;
//import com.igaworks.v2.core.push.popup.Model.InAppCarousel;
//import com.igaworks.v2.core.push.popup.Model.InAppFullImage;
//import com.igaworks.v2.core.push.popup.Model.InAppFullWebView;
//import com.igaworks.v2.core.push.popup.Model.InAppMessageResource;
//import com.igaworks.v2.core.push.popup.Model.InAppModal;
//
//import io.adbrix.sdk.configuration.CoreWrapper;
//import io.adbrix.sdk.domain.ABXConstants;
//
//public class PopUpHandler {
//
//    protected static PopUpDialog popupDialog;
//
//    private PopUpHandler(){}
//
//    public static void showPopup(final Activity activity, final PopUpUtils.POPUP_STYLE popupStyle, final InAppMessageResource resource) {
//        CoreWrapper.runInBackGroundWithoutOrder(new Runnable() {
//            @Override
//            public void run() {
//                if (!CoreWrapper.inForeground()) {
//                    avoidWindowLeak();
//                    return;
//                }
//                try {
//                    boolean stopPopUp = AbxPopUpCommonDAO.getStopPopUpFlag();
//                    if (stopPopUp) return;
//
//                    if (popupDialog != null && popupDialog.isShowing()) {
//                        popupDialog.dismiss();
//                    }
//                    switch (popupStyle) {
//                        case BAR:
//                            popupDialog = new PopUpDialog.BarPopUpDialog(activity, (InAppBar) resource);
//                            break;
//                        case FULL_IMAGE:
//                            popupDialog = new PopUpDialog.FullScreenImagePopUp(activity, (InAppFullImage) resource);
//                            break;
//                        case FULL_WEB_VIEW:
//                            popupDialog = new PopUpDialog.FullScreenWebViewPopUp(activity, (InAppFullWebView) resource);
//                            break;
//                        case MODAL:
//                            popupDialog = new PopUpDialog.ModalPopUp(activity, (InAppModal) resource);
//                            break;
//                        case CAROUSEL:
//                            popupDialog = new PopUpDialog.FullScreenCarousel(activity, (InAppCarousel) resource);
//                            break;
//                        default:
//                            popupDialog = new PopUpDialog(activity);
//                            break;
//                    }
//                    if (popupDialog != null && CoreWrapper.inForeground()) {
//                        popupDialog.show();
//                    } else {
//                        Log.d(ABXConstants.LOGTAG, "ERROR : Invaild State");
//                    }
//                } catch (Exception e) {
//                    Log.w(ABXConstants.LOGTAG, "Error: " + e.getMessage());
//                    e.printStackTrace();
//                }
//            }
//        });
//    }
//
//    protected static void avoidWindowLeak() {
//        if (PopUpHandler.popupDialog != null) {
//            PopUpHandler.popupDialog.dismiss();
//        }
//        PopUpHandler.popupDialog = null;
//    }
//
//    public static void closePopup() {
//        if (popupDialog != null) {
//            popupDialog.dismiss();
//            popupDialog = null;
//        }
//    }
//}
