//package com.igaworks.v2.core.push.popup;
//
//import android.app.Activity;
//import android.app.Dialog;
//import android.content.Context;
//import android.graphics.Bitmap;
//import android.graphics.Color;
//import android.graphics.PixelFormat;
//import android.graphics.Point;
//import android.graphics.drawable.ColorDrawable;
//import android.os.Build;
//import android.support.v4.view.ViewPager;
//import android.util.Log;
//import android.view.Display;
//import android.view.Gravity;
//import android.view.LayoutInflater;
//import android.view.View;
//import android.view.Window;
//import android.view.WindowManager;
//import android.webkit.WebChromeClient;
//import android.webkit.WebView;
//import android.widget.Button;
//import android.widget.ImageView;
//import android.widget.LinearLayout;
//import android.widget.ProgressBar;
//import android.widget.TextView;
//
//import com.igaworks.v2.R;
//import com.igaworks.v2.core.push.notification.PushUtils;
//import com.igaworks.v2.core.push.popup.Model.InAppBar;
//import com.igaworks.v2.core.push.popup.Model.InAppCarousel;
//import com.igaworks.v2.core.push.popup.Model.InAppFullImage;
//import com.igaworks.v2.core.push.popup.Model.InAppFullWebView;
//import com.igaworks.v2.core.push.popup.Model.InAppModal;
//
//public class PopUpDialog extends Dialog {
//    private static LinearLayout.LayoutParams containerParam;
//    protected static PopUpCreator contentsProvider;
//    protected static int windowWidth;
//    protected static int windowHeight;
//
//
//    public PopUpDialog(Context context) {
//        super(context);
//        Display display = ((Activity) context).getWindowManager().getDefaultDisplay();
//        Point size = new Point();
//        display.getSize(size);
//        windowHeight = size.y;
//        windowWidth = size.x;
//
//    }
//
//    protected static class FullScreenCarousel extends PopUpDialog {
//        public FullScreenCarousel(Context context, InAppCarousel resource) {
//            super(context);
//            requestWindowFeature(Window.FEATURE_NO_TITLE);
//
//            LayoutInflater layoutInflater = LayoutInflater.from(context);
//            View promptView = layoutInflater.inflate(R.layout.pop_up_carousel, null);
//
//            Button leftBtn = (Button) promptView.findViewById(R.id.dont_show_anymore);
//            Button rightBtn = (Button) promptView.findViewById(R.id.close);
//            ImageView image = (ImageView) promptView.findViewById(R.id.in_app_image);
//            ViewPager viewPager = promptView.findViewById(R.id.view_pager);
//
//            rightBtn.setOnClickListener(PopUpCreator.cancelTextViewClickListner);
//
//            if(resource.getUrls() != null){
//                viewPager.setAdapter(new PopUpPageAdapter(context,resource.getUrls()));
//            }
//            else if (resource.getResources() != null) {
//                viewPager.setAdapter(new PopUpPageAdapter(context,resource.getResources()));
//            }
//            else {
//                Log.d("Adbrix_QA", "ERROR :: No resources to show up");
//            }
//
//            setContentView(promptView);
//
//            PopUpUtils.POPUP_ANIMATION animation = resource.getAnimation();
//            getWindow().setAttributes(PopUpDialog.getDefaultLayoutParam(this,animation));
//            setDefaultWindowSetting(getWindow());
//
//        }
//    }
//
//    protected static class FullScreenImagePopUp extends PopUpDialog {
//        public FullScreenImagePopUp(Context context, InAppFullImage resource) {
//            super(context);
//            requestWindowFeature(Window.FEATURE_NO_TITLE);
//
//            LayoutInflater layoutInflater = LayoutInflater.from(context);
//            View promptView = layoutInflater.inflate(R.layout.pop_up_full_image, null);
//            Button leftBtn = (Button) promptView.findViewById(R.id.dont_show_anymore);
//            Button rightBtn = (Button) promptView.findViewById(R.id.close);
//            ImageView imageView = (ImageView) promptView.findViewById(R.id.in_app_image);
//
//            rightBtn.setOnClickListener(PopUpCreator.cancelTextViewClickListner);
//
//            if(resource.getUrl() != null) {
//                imageView.setImageBitmap(PushUtils.getBitmapFromURL(resource.getUrl()));
//            }
//            else if (resource.getResourceId() != 0) {
//                imageView.setImageResource(resource.getResourceId());
//            }
//
//            setContentView(promptView);
//
//            PopUpUtils.POPUP_ANIMATION animation = resource.getAnimation();
//            getWindow().setAttributes(PopUpDialog.getDefaultLayoutParam(this, animation));
//            setDefaultWindowSetting(getWindow());
//
//        }
//    }
//    protected static class FullScreenWebViewPopUp extends PopUpDialog {
//        public FullScreenWebViewPopUp(final Context context, InAppFullWebView resource) {
//            super(context);
//            requestWindowFeature(Window.FEATURE_NO_TITLE);
//
//            LayoutInflater layoutInflater = LayoutInflater.from(context);
//            View promptView = layoutInflater.inflate(R.layout.pop_up_full_webview, null);
//
//            Button leftBtn = (Button) promptView.findViewById(R.id.dont_show_anymore);
//            Button rightBtn = (Button) promptView.findViewById(R.id.close);
//            Button backBtn = (Button) promptView.findViewById(R.id.web_view_back_btn);
//            Button fowardBtn = (Button) promptView.findViewById(R.id.web_view_foward_btn);
//            WebView webView = (WebView) promptView.findViewById(R.id.web_view);
//            final ProgressBar progressBar = (ProgressBar) promptView.findViewById(R.id.progressBar);
//
//            leftBtn.setOnClickListener(PopUpCreator.doNotAppearAnymoreClickListener);
//            rightBtn.setOnClickListener(PopUpCreator.cancelTextViewClickListner);
//            backBtn.setOnClickListener(PopUpCreator.getBackBtnOnClickListener(webView));
//            fowardBtn.setOnClickListener(PopUpCreator.getFowardBtnOnClickListener(webView));
//
//
//            WindowManager.LayoutParams layoutParams = getWindow().getAttributes();
//
//            PopUpUtils.POPUP_ANIMATION animation = resource.getAnimation();
//            if (animation != null) {
//                layoutParams.windowAnimations = setAnimation(animation);
//                getWindow().setAttributes(layoutParams);
//            }
//
//            webView.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
//            webView.setVerticalScrollBarEnabled(false); //
//            webView.setHorizontalScrollBarEnabled(false);
//            //popup_webview.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
//            webView.setBackgroundColor(Color.WHITE);
//            webView.getSettings().setJavaScriptEnabled(true);
//            webView.setWebChromeClient(new WebChromeClient() {
//                public void onProgressChanged(WebView view, int progress) {
//                    // Activities and WebViews measure progress with different scales.
//                    // The progress meter will automatically disappear when we reach 100%
//                    //((Activity)context).setProgress(progress * 1000); <-deprecated
//                    progressBar.setProgress(progress);
//                    if (progress == 100) progressBar.setVisibility(View.INVISIBLE);
//                }
//            });
//            webView.setWebViewClient(new PopUpWebViewClient());
//            webView.loadUrl(resource.getUrl());
//            setContentView(promptView);
//
//            setDefaultWindowSetting(getWindow());
//        }
//    }
//
//    protected static class BarPopUpDialog extends PopUpDialog {
//
//        public BarPopUpDialog(Context context, InAppBar resource) {
//            super(context);
//
//            LayoutInflater layoutInflater = LayoutInflater.from(context);
//            View promptView = layoutInflater.inflate(R.layout.pop_up_bar, null);
//
//            ImageView imageView = (ImageView) promptView.findViewById(R.id.bar_image_view);
//            TextView textView = (TextView) promptView.findViewById(R.id.bar_text_view);
//            Button rightBtn = (Button) promptView.findViewById(R.id.pop_up_bar_right_arrow);
//            rightBtn.setOnClickListener(PopUpCreator.cancelTextViewClickListner);
//
//            Window window = getWindow();
//            WindowManager.LayoutParams layoutParams = window.getAttributes();
//
//            if(resource.getAnimation() != null) {
//                layoutParams.windowAnimations = setAnimation(resource.getAnimation());
//            }
//            if(resource.getText() != null) {
//                textView.setText(resource.getText());
//            }
//            if(resource.getUrl() != null) {
//                imageView.setImageBitmap(PushUtils.getBitmapFromURL(resource.getUrl()));
//            }
//            else if (resource.getResourceId() != 0) {
//                imageView.setImageResource(resource.getResourceId());
//            }
//
//            layoutParams.gravity = Gravity.BOTTOM | Gravity.CENTER;
//            layoutParams.verticalMargin = 0.07f;
//
//            window.setAttributes(layoutParams);
//            window.setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
//            window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
//            window.clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
//            setContentView(promptView);
//
//            int height;
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR2) {
//                height = (int) (windowHeight * 0.15);
//            } else {
//                height = 100;
//            }
//
//            WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
//            lp.copyFrom(getWindow().getAttributes());
//            lp.width = WindowManager.LayoutParams.MATCH_PARENT;
//            lp.height = height;
//            window.setAttributes(lp);
//        }
//    }
//
//    protected static class ModalPopUp extends PopUpDialog {
//
//        public ModalPopUp(Context context, InAppModal resource) {
//            super(context);
//
//            LayoutInflater layoutInflater = LayoutInflater.from(context);
//            View promptView = layoutInflater.inflate(R.layout.pop_up_in_app, null);
//
//            ImageView inAppImageView = (ImageView) promptView.findViewById(R.id.in_app_image);
//            Button rightBtn  = (Button) promptView.findViewById(R.id.right_btn);
//
//            Bitmap downloadedImage = PushUtils.getBitmapFromURL(resource.getUrl());
//            if(downloadedImage != null){
//                inAppImageView.setImageBitmap(downloadedImage);
//            }
//            else{
//                inAppImageView.setImageResource(resource.getResourceId());
//            }
//
//            rightBtn.setOnClickListener(PopUpCreator.cancelTextViewClickListner);
//
//            Window window = getWindow();
//            WindowManager.LayoutParams layoutParams = window.getAttributes();
//
//            PopUpUtils.POPUP_ANIMATION animation = resource.getAnimation();
//            if (animation != null) {
//                layoutParams.windowAnimations = setAnimation(animation);
//            }
//
//            layoutParams.gravity = Gravity.CENTER;
//
//            window.setAttributes(layoutParams);
//            window.setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
//            window.setBackgroundDrawable(new ColorDrawable(Color.WHITE));
//            window.clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
//            setContentView(promptView);
//
//            int height,width;
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR2) {
//                height = (int) (windowHeight * 0.75);
//                width = (int) (windowWidth * 0.90);
//            } else {
//                height = 500;
//                width = 300;
//            }
//
//            WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
//            lp.copyFrom(getWindow().getAttributes());
//            lp.width = width;
//            lp.height = height;
//            getWindow().setAttributes(lp);
//        }
//    }
//
//    private static WindowManager.LayoutParams getDefaultLayoutParam(PopUpDialog activity, PopUpUtils.POPUP_ANIMATION animation) {
//        WindowManager.LayoutParams layoutParamsOfWindow = activity.getWindow().getAttributes();
//        layoutParamsOfWindow.flags = WindowManager.LayoutParams.FLAG_DIM_BEHIND;
//        layoutParamsOfWindow.dimAmount = 0.7f;
//        layoutParamsOfWindow.width = WindowManager.LayoutParams.MATCH_PARENT;
//        layoutParamsOfWindow.height = WindowManager.LayoutParams.MATCH_PARENT;
//        layoutParamsOfWindow.gravity = Gravity.CENTER;
//        layoutParamsOfWindow.verticalMargin = 0;
//        layoutParamsOfWindow.horizontalMargin = 0;
//
//        if (animation != null) {
//            layoutParamsOfWindow.windowAnimations = setAnimation(animation);
//        }
//        return layoutParamsOfWindow;
//    }
//
//    private static void setDefaultWindowSetting(Window window){
//        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
//        window.getDecorView().setBackgroundColor(Color.TRANSPARENT);
//        window.setFormat(PixelFormat.RGBA_8888);
//        //TODO FLAG_DITHER is deprecated!
//        window.addFlags(WindowManager.LayoutParams.FLAG_DITHER);
//        window.setFlags(WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS, WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
//        window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
//        window.setGravity(Gravity.CENTER);
//        window.getDecorView().setPadding(0, 0, 0, 0);
//        window.setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
//    }
//
//    private static int setAnimation(PopUpUtils.POPUP_ANIMATION animation){
//        switch (animation) {
//            case HORIZONTAL_SLIDE:
//                return R.style.horizontalSlideAnimation;
//            case VERTICAL_SLIDE:
//                return R.style.verticalSlideAnimation;
//            case FADE_IN_OUT:
//                return R.style.fadeAnimation;
//            default:
//                return 0;
//        }
//    }
//
//    @Override
//    public void onBackPressed() {
//        PopUpHandler.avoidWindowLeak();
//    }
//}
