package com.igaworks.v2.core.push;

import android.content.Context;

import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.push.notification.PushCreator;
import com.igaworks.v2.core.push.notification.PushLocalBridge;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.CoreWrapper;

public class PushController {
    public boolean isPushControllerInitialized = false;
    public AdBrixRm.onTouchRemotePushListener remotePushMessageListener;
    private AdBrixRm.onTouchLocalPushListener localPushMessageListener;

    private static class Singleton{
        private static final PushController instance = new PushController();
    }

    private PushController() {}

    public static PushController getInstance(){
        return Singleton.instance;
    }

    public void setPushEnable(final boolean userPushEnable) {
        boolean pushEnable = CoreWrapper.getPushEnable();

        if (pushEnable == userPushEnable) {
            return;
        }

        CoreWrapper.updatePushEnable(userPushEnable);
    }

    public void setRegistrationID(String userRegistrationId) {
        String registrationId = CoreWrapper.getRegistrationID();

        if (registrationId == userRegistrationId) {
            return;
        }

        CoreWrapper.setRegistrationID(userRegistrationId);
    }

    public void setBigTextClientPushEvent(Context ctx, AdBrixRm.BigTextPushProperties bigTextPushProperties, boolean alwaysIsShown) {
        PushLocalBridge.setBigTextClientPushEvent(ctx, bigTextPushProperties, alwaysIsShown);
    }

    public void setBigPictureClientPushEvent(Context ctx, AdBrixRm.BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        PushLocalBridge.setBigPictureClientPushEvent(ctx, bigPicturePushProperties, alwaysIsShown);
    }

    public void cancelClientPushEvent(Context ctx, int eventId) {
        PushLocalBridge.cancelClientPushEvent(ctx, eventId);
    }

    public void setRemotePushMessageListener(AdBrixRm.onTouchRemotePushListener remotePushMessageListener) {
        this.remotePushMessageListener = remotePushMessageListener;
    }

    public void setLocalPushMessageListener(AdBrixRm.onTouchLocalPushListener localPushMessageListener) {
        this.localPushMessageListener = localPushMessageListener;
    }

    public void callBackLocalPushMsg(String msg) {
        if (this.localPushMessageListener != null)
            this.localPushMessageListener.onTouchLocalPush(msg);
    }

    public void callBackRemotePushMsg(String msg) {
        if (this.remotePushMessageListener != null)
            this.remotePushMessageListener.onTouchRemotePush(msg);
    }

    public boolean checkDuplicatedNotification(int notificationId){
        return CoreWrapper.checkDuplicatedNotification(notificationId);
    }

    public void init(Context context){
        initPushEnableValue();
        PushCreator.createNotificationChannel(context, false, false);
    }

    private void initPushEnableValue(){
        isPushControllerInitialized = true;
        AbxLog.d("PushController : pushEnable & osPushEnable are initialized!", true);
    }

    public void updateOSNotificationEnabled(boolean userOsPushEnable) {
        boolean osPushEnable = CoreWrapper.getOsPushEnable();

        if (osPushEnable == userOsPushEnable) {
            return;
        }

        CoreWrapper.updateOsPushEnable(userOsPushEnable);
    }

    public boolean getPushEnable() {
        return CoreWrapper.getPushEnable();
    }

    public boolean getOsPushEnable() {
        return CoreWrapper.getOsPushEnable();
    }
}