package com.igaworks.v2.core.application;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.CoreWrapper;

public class AbxDefaultDeeplinkActivity extends Activity {

    String AbxRedirectActivity = "";
    static boolean IntentForward = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AdBrixRm.deeplinkEvent(AbxDefaultDeeplinkActivity.this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        // singleTask launchMode case
        setIntent(intent); //now getIntent() should always return the last received intent
        AdBrixRm.deeplinkEvent(AbxDefaultDeeplinkActivity.this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        ParseIntent(AbxDefaultDeeplinkActivity.this);
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    private void ParseIntent(Activity activity) {

        try {

            ActivityInfo activityInfo = getPackageManager()
                    .getActivityInfo(this.getComponentName(), PackageManager.GET_META_DATA);
            if (activityInfo != null) {
                Bundle bundle = activityInfo.metaData;
                if (bundle != null && bundle.containsKey("AbxRedirectActivity")) {
                    AbxRedirectActivity = String.valueOf(activityInfo.metaData.get("AbxRedirectActivity"));
                }
                if (bundle != null && bundle.containsKey("IntentForward")) {
                    IntentForward = activityInfo.metaData.getBoolean("IntentForward", true);
                }
            }

            AbxLog.d("RedirectActivity: " + AbxRedirectActivity + " . IntentForward: " + IntentForward, true);

            try {
                if (IntentForward) {
                    Uri convertedUri = CoreWrapper.getDeeplinkUriExceptAdbrixParameter(activity.getIntent().getData());

                    Intent intent = new Intent();
                    intent.setData(convertedUri);
                    intent.setClassName(this, AbxRedirectActivity);

                    activity.startActivity(intent); // forward intent without ck
                    String deeplinkUrl = "null";
                    if (intent != null && intent.getData() != null) {
                        deeplinkUrl = intent.getData().toString();
                    }
                    AbxLog.d("AbxDefaultDeeplinkActivity Deeplink: " + deeplinkUrl, true);
                } else {
                    Intent intent = new Intent();
                    intent.setClassName(this, AbxRedirectActivity);
                    activity.startActivity(intent);
                }

            } catch (Exception e1) {
                AbxLog.d("Can not redirect to " + AbxRedirectActivity + ". Launch default activity", true);
                AbxLog.d("AbxDefaultDeeplinkActivity: " + e1.getMessage(),true);

                Intent intent = activity.getPackageManager().getLaunchIntentForPackage(activity.getPackageName());
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP |
                        Intent.FLAG_ACTIVITY_SINGLE_TOP);
                activity.startActivity(intent);
            }

        } catch (Exception e) {
            AbxLog.d("AbxDefaultDeeplinkActivity Error: " + e.getMessage(),true);
        }
        finish();

    }
}
