package com.igaworks.v2.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;

import com.igaworks.v2.core.push.PushController;
import com.igaworks.v2.core.push.PushEventSqliteStore;
import com.igaworks.v2.core.push.notification.AbxPushCommonDAO;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.configuration.CoreWrapper;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.utils.CommonUtils;

//import com.igaworks.v2.core.push.popup.Model.InAppBar;
//import com.igaworks.v2.core.push.popup.Model.InAppCarousel;
//import com.igaworks.v2.core.push.popup.Model.InAppFullImage;
//import com.igaworks.v2.core.push.popup.Model.InAppFullWebView;
//import com.igaworks.v2.core.push.popup.Model.InAppModal;
//import com.igaworks.v2.core.push.popup.PopUpHandler;
//import com.igaworks.v2.core.push.popup.PopUpUtils;

public class AdBrixRm {

    private AdBrixRm(){}

    public static AbxGame Game;
    public static AbxCommon Common;
    public static AbxCommerce Commerce;

    private static DeferredDeeplinkListener deferredDeeplinkListener;
    private static DeeplinkListener deeplinkListener;

    public static void init(Context appContext, String appKey, String secretKey) {

        CoreWrapper.setDevState(appContext);

        AbxLog.checkDebugAppInstalled(appContext);

        CoreWrapper.startController(appContext);

        CoreWrapper.addObserverToDeferredDeeplinkPostingObservable(new DeferredDeeplinkObserver());

        CoreWrapper.addObserverToDeeplinkPostingObservable(new DeeplinkObserver());

        CoreWrapper.initialize(appContext, appKey, secretKey);

        CoreWrapper.runInBackGroundWithoutOrder(new Runnable() {
            @Override
            public void run() {
                PushController.getInstance().init(appContext);
            }
        });

        CoreWrapper.addObserverToOsPushEnableObservable(new OsPushEnableObserver());

        PushEventSqliteStore.initPushEventSqliteStore(appContext, null);

        CoreWrapper.registerNetworkCallback();
    }

    public static void stopController(){
        CoreWrapper.stopController();
    }

    private static class DeferredDeeplinkObserver implements IObserver<String> {

        @Override
        public void update(String deferredDeeplink) {
            if (deferredDeeplinkListener == null) {
                AbxLog.w("deferredDeeplinkListener is null", true);
                return;
            }

            if(deferredDeeplink == null){
                AbxLog.d("deferredDeeplink is null", true);
            }
            else {
                deferredDeeplinkListener.onReceiveDeferredDeeplink(deferredDeeplink);
            }
        }
    }

    private static class DeeplinkObserver implements IObserver<String> {

        @Override
        public void update(String deeplink) {
            if (deeplinkListener == null) {
                AbxLog.w("deeplinkListener is null", true);
                return;
            }

            if(deeplink == null){
                AbxLog.d("deeplink is null", true);
            }
            else {
                deeplinkListener.onReceiveDeeplink(deeplink);
            }
        }
    }

    private static class OsPushEnableObserver implements IObserver<Boolean>{

        @Override
        public void update(Boolean object) {
            PushController.getInstance().updateOSNotificationEnabled(object);
        }
    }

    public static void login(String userId) {

        try {
            if (checkAdbrixPause()) return;

            if (CommonUtils.isNullOrEmpty(userId)) {
                userId = "";
                AbxLog.i("login: userId is null or empty >> Auto change to empty String", true);
            }

            AdBrixRm.UserProperties userProperties = new AdBrixRm.UserProperties();
            userProperties.setAttrs("user_id", userId);

            // Updating userProperties before login to update user_id in user profile
            if(userProperties.propertiesJson.length() > 0){
                saveUserPropertiesWithoutEvent(userProperties);
            }

            postAbxEvent(CompatConstants.EVENT_LOGIN);

            // Updating userProperties after login to update user property and ci
            if(userProperties.propertiesJson.length() > 0){
                saveUserProperties(userProperties);
            }

        } catch (Exception md5_e) {
            AbxLog.e("login >> Error: " + md5_e.toString(), true);
        }
    }

    public static void logout() {
        if (checkAdbrixPause()) return;

        clearUserProperties();
        postAbxEvent(CompatConstants.EVENT_LOGOUT);
    }

    public static void gdprForgetMe(Context appContext){
        if (CoreWrapper.isGdprForgetMe()) {
            AbxLog.i("Set GDPR Sync set:: " + CoreWrapper.isGdprForgetMeSync(), true);
            if (CoreWrapper.isGdprForgetMeSync()) {
                AbxLog.i("Set GDPR is already set the 'true'", true);
                return;
            }
        }

        CoreWrapper.gdprForgetMe();
    }

    public static void setAge(int age){
        if (checkAdbrixPause()) return;

        UserProperties userProperties = new UserProperties();
        userProperties.setAttrs("age", age);

        saveUserProperties(userProperties);
    }

    public enum AbxGender {
        MALE(2),
        FEMALE(1),
        UNKNOWN(0);

        private final int value;

        private AbxGender(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public static void setGender(AbxGender gender){
        if (checkAdbrixPause()) return;

        if (gender == null) {
            AbxLog.i("setGender: null value for gender >> Auto change null to AbxGender.UNKNOWN", true);
            gender = AbxGender.UNKNOWN;
        }

        UserProperties userProperties = new UserProperties();
        userProperties.setAttrs("gender", gender.getIntValue());

        saveUserProperties(userProperties);
    }

    public static class UserProperties {
        protected JSONObject propertiesJson = new JSONObject();

        public UserProperties setAttrs(String property, Object value){
            addToUserProperties(property, value);
            return this;
        }

        private void addToUserProperties(String property, Object value) {
            if (checkAdbrixPause()) return;

            if (CommonUtils.isNullOrEmpty(property)) {
                AbxLog.w( "Ignore addToUserProperties function :: property is null or empty string", true);
                return;
            }

            if (value == null) {
                AbxLog.w(String.format("Ignore addToUserProperties function :: null value for property %s", property), true);
                return;
            }
            try {
                String convertKey = ExtraUtils.convertPermittedStr(property);
                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return;
                }
                if (convertKey.length() > ABXConstants.MAX_KEY_LENGTH) {
                    return;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    propertiesJson.put(convertKey, value);
                }

            } catch (JSONException e) {
                AbxLog.e("addToUserProperties JSONObject Error: " + e.getMessage(), true);
            }
        }
    }

    public static class CiProperties extends UserProperties {
        @Override
        public CiProperties setAttrs(String property, Object value) {
            super.setAttrs(property, value);
            return this;
        }
    }

    //With Event
    public static void saveUserProperties(UserProperties userProperties){
        if (checkAdbrixPause()) return;

        if (userProperties == null){
            AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
            return;
        }

        CoreWrapper.saveUserProperty(userProperties.propertiesJson);
    }

    //Without Event
    private static void saveUserPropertiesWithoutEvent(UserProperties userProperties){
        if (checkAdbrixPause()) return;

        if (userProperties == null){
            AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
            return;
        }

        CoreWrapper.saveUserPropertyWithoutEvent(userProperties.propertiesJson);
    }

    private static void clearUserProperties(){
        if (checkAdbrixPause()) return;

        CoreWrapper.clearUserProperties();
    }

    public static void setEnableLocationListening(Boolean isEnable) {
        if (checkAdbrixPause()) return;

        CoreWrapper.setEnableLocationListening(isEnable);
    }

    public static void setLocation(double latitude, double longitude) {
        if (checkAdbrixPause()) return;

        CoreWrapper.setLocation(latitude, longitude);
    }

    public static class AttrModel {
        protected JSONObject properties = new JSONObject();

        public AttrModel setAttrs(String property, Object value){
            try {

                String convertKey = ExtraUtils.convertPermittedStr(property);

                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return this;
                }
                if (convertKey.length() > ABXConstants.MAX_KEY_LENGTH) {
                    return this;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    properties.put(convertKey, value);
                }

            } catch (JSONException e) {
                e.printStackTrace();
            }
            return this;
        }

        public JSONObject toJSONObject(String tag) {
            JSONObject obj = properties == null ? new JSONObject() : properties;

            return CommonUtils.truncate(ExtraUtils.limitCustomKeyNumber(ExtraUtils.cloneJSONObject(obj), tag));
        }
    }

    public static void event(String eventName){
        if (checkAdbrixPause()) return;

        if (eventName == null){
            AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
            return;
        }

        CoreWrapper.event(eventName);
    }

    public static void event(String eventName, AttrModel attrModel) {
        if (checkAdbrixPause()) return;

        if (eventName == null){
            AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
            return;
        }

        if (attrModel == null){
            AbxLog.e("event:: null value for attrModel. Auto change null to Empty AttrModel.", false);
            attrModel = new AttrModel();
        }

        CoreWrapper.event(eventName, CommonUtils.parseValueWithDataType(attrModel.toJSONObject("custom event"), CommonUtils.FIX_TYPE.PREFIX));
    }

    private static void postAbxEvent(String eventName){
        CoreWrapper.postAbxEvent(eventName);
    }

    static void postAbxEvent(String eventName, JSONObject eventParam){
        CoreWrapper.postAbxEvent(eventName, eventParam);
    }

    static void postSameAbxEvent(List<CommerceProductModel> products, String eventName, JSONObject attributes) {

        List<List<CommerceProductModel>> listOfList = CommonUtils.split(products, CompatConstants.MAX_PRODUCT_LIST_LENGTH);
        List<JSONArray> jsonArrayList = new ArrayList<>();
        List<JSONObject> jsonObjectList = new ArrayList<>();

        try {
            for (List<CommerceProductModel> commerceProductModelList: listOfList) {
                jsonArrayList.add(ExtraUtils.getProductJsonArrayForPurchase(commerceProductModelList));
            }

            for (JSONArray productJsonArray: jsonArrayList) {
                jsonObjectList.add(
                        ExtraUtils.getCommerceEventParams(productJsonArray, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FIX_TYPE.PREFIX)));
            }

            CoreWrapper.postSameAbxEvent(eventName, jsonObjectList);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void onPause(){
        CoreWrapper.onPause();
    }

    public static void onResume(Activity activity){
        CoreWrapper.onResume(activity);
    }

    static Boolean checkAdbrixPause(){
        if (CoreWrapper.isGdprForgetMe() || CoreWrapper.isAdbrixPause()){
            AbxLog.d( "Adbrix Pause : " + true, true);
            return true;
        }
        return false;
    }

    public static class GameProperties {

        public static class TutorialComplete {

            protected Boolean isSkip = null;
            protected JSONObject gameProperties;

            public TutorialComplete() {
                gameProperties = new JSONObject();
            }

            public TutorialComplete setIsSkip(boolean isSkip) {
                this.isSkip = isSkip;
                return this;
            }

            public TutorialComplete setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                gameProperties = attrModel.toJSONObject("TutorialComplete");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = gameProperties == null ? new JSONObject() : gameProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                try {
                    if (this.isSkip != null) obj.put(CompatConstants.ABX_GAME_IS_SKIP, isSkip);
                } catch (JSONException e) {
                    AbxLog.e( "Fail to convert TutorialComplete Model to JSONObject :" + e.getMessage(), true);
                }
                return obj;
            }
        }

        public static class LevelAchieved {

            protected Integer level = null;
            protected JSONObject gameProperties;

            public LevelAchieved() {
                this.gameProperties = new JSONObject();
            }

            public LevelAchieved setLevel(int level) {
                this.level = level;
                return this;
            }

            public LevelAchieved setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties =  attrModel.toJSONObject("LevelAchieved");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = gameProperties == null ? new JSONObject() : gameProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                try {
                    if (this.level != null) obj.put(CompatConstants.ABX_GAME_LEVEL, level);
                } catch (JSONException e) {
                    AbxLog.e("Fail to convert LevelAchieved Model to JSONObject :" + e.getMessage(), true);
                }
                return obj;
            }
        }

        public static class CharacterCreated {

            protected JSONObject gameProperties;

            public CharacterCreated() {
                this.gameProperties = new JSONObject();
            }

            public CharacterCreated setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("CharacterCreated");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = gameProperties == null ? new JSONObject() : gameProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                return obj;
            }
        }

        public static class StageCleared {

            protected String stageName = null;
            protected JSONObject gameProperties;

            public StageCleared() {
                this.gameProperties = new JSONObject();
            }

            public StageCleared setStageName(String stageName) {
                this.stageName = stageName;
                return this;
            }

            public StageCleared setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("StageCleared");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = gameProperties == null ? new JSONObject() : gameProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                try {
                    if (this.stageName != null) obj.put(CompatConstants.ABX_GAME_STAGE_NAME, stageName);
                } catch (JSONException e) {
                    AbxLog.e("Fail to convert StageCleared Model to JSONObject :" + e.getMessage(), true);
                }
                return obj;
            }
        }
    }

    public static class CommonProperties {

        public static class Purchase {

            protected JSONObject commonProperties;

            public Purchase(){
                this.commonProperties = new JSONObject();
            }

            public Purchase setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Purchase");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = commonProperties == null ? new JSONObject() : commonProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                return ExtraUtils.limitCustomKeyNumber(obj, "Purchase");
            }
        }

        public static class SignUp {

            protected JSONObject commonProperties;

            public SignUp(){
                this.commonProperties = new JSONObject();
            }

            public SignUp setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("SignUp");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = commonProperties == null ? new JSONObject() : commonProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                return ExtraUtils.limitCustomKeyNumber(obj, "SignUp");
            }
        }

        public static class UseCredit {
            protected JSONObject commonProperties;

            public UseCredit(){
                this.commonProperties = new JSONObject();
            }

            public UseCredit setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties =  attrModel.toJSONObject("UseCredit");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = commonProperties == null ? new JSONObject() : commonProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                return ExtraUtils.limitCustomKeyNumber(obj, "UseCredit");
            }
        }

        public static class AppUpdate {

            protected JSONObject commonProperties;

            protected String prev_ver;
            protected String curr_ver;

            public AppUpdate() {
                this.commonProperties = new JSONObject();
                this.prev_ver = null;
                this.curr_ver = null;
            }

            public AppUpdate setPrevVersion(String prev_ver) {
                this.prev_ver = prev_ver;
                return this;
            }

            public AppUpdate setCurrVersion(String curr_ver) {
                this.curr_ver = curr_ver;
                return this;
            }

            public String getPrev_ver() {
                return this.prev_ver;
            }

            public String getCurr_ver() {
                return this.curr_ver;
            }

            public AppUpdate setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("AppUpdate");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = commonProperties == null ? new JSONObject() : commonProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                try {
                    if (this.prev_ver != null) obj.put(CompatConstants.ABX_APP_PREV_VER, prev_ver);
                    if (this.curr_ver != null) obj.put(CompatConstants.ABX_APP_CURR_VER, curr_ver);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                return ExtraUtils.limitCustomKeyNumber(obj, "AppUpdate");
            }
        }

        public static class Invite {

            protected JSONObject commonProperties;

            public Invite(){
                this.commonProperties = new JSONObject();
            }

            public Invite setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Invite");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = commonProperties == null ? new JSONObject() : commonProperties;
                obj = ExtraUtils.cloneJSONObject(obj);
                return ExtraUtils.limitCustomKeyNumber(obj, "Invite");
            }
        }
    }

    public static class CommonSignUpChannel {
        public static final CommonSignUpChannel Kakao = new CommonSignUpChannel("Kakao");
        public static final CommonSignUpChannel Naver = new CommonSignUpChannel("Naver");
        public static final CommonSignUpChannel Line = new CommonSignUpChannel("Line");
        public static final CommonSignUpChannel Google = new CommonSignUpChannel("Google");
        public static final CommonSignUpChannel Facebook = new CommonSignUpChannel("Facebook");
        public static final CommonSignUpChannel Twitter = new CommonSignUpChannel("Twitter");
        public static final CommonSignUpChannel whatsApp = new CommonSignUpChannel("whatsApp");
        public static final CommonSignUpChannel QQ = new CommonSignUpChannel("QQ");
        public static final CommonSignUpChannel WeChat = new CommonSignUpChannel("WeChat");
        public static final CommonSignUpChannel UserId = new CommonSignUpChannel("UserId");
        public static final CommonSignUpChannel ETC = new CommonSignUpChannel("ETC");
        public static final CommonSignUpChannel SkTid = new CommonSignUpChannel("SkTid");
        public static final CommonSignUpChannel AppleId = new CommonSignUpChannel("AppleId");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int UserIdIdx = 10;
        public static final int ETCIdx = 11;
        public static final int SkTidIdx = 12;
        public static final int AppleIdIdx = 13;

        public String channel;

        public CommonSignUpChannel(String channel) {
            this.channel = channel;
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public static CommonSignUpChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(UserId.getChannel())) {
                return UserId;
            } else if (channel.equalsIgnoreCase(SkTid.getChannel())) {
                return SkTid;
            } else if (channel.equalsIgnoreCase(AppleId.getChannel())) {
                return AppleId;
            } else {
                return ETC;
            }

        }

        public static CommonSignUpChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else if (channel == UserIdIdx) {
                return UserId;
            } else if (channel == SkTidIdx) {
                return SkTid;
            } else if (channel == AppleIdIdx) {
                return AppleId;
            } else {
                return ETC;
            }
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommonInviteChannel {
        public static final CommonInviteChannel Kakao = new CommonInviteChannel("Kakao");
        public static final CommonInviteChannel Naver = new CommonInviteChannel("Naver");
        public static final CommonInviteChannel Line = new CommonInviteChannel("Line");
        public static final CommonInviteChannel Google = new CommonInviteChannel("Google");
        public static final CommonInviteChannel Facebook = new CommonInviteChannel("Facebook");
        public static final CommonInviteChannel Twitter = new CommonInviteChannel("Twitter");
        public static final CommonInviteChannel whatsApp = new CommonInviteChannel("whatsApp");
        public static final CommonInviteChannel QQ = new CommonInviteChannel("QQ");
        public static final CommonInviteChannel WeChat = new CommonInviteChannel("WeChat");
        public static final CommonInviteChannel ETC = new CommonInviteChannel("ETC");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int ETCIdx = 10;

        public String channel;

        public CommonInviteChannel(String channel) {
            this.channel = channel;
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public static CommonInviteChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public static CommonInviteChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommerceProductModel {
        protected String productID = "";
        protected String productName = "";
        protected double price = 0.0;
        protected int quantity = 1;
        protected double discount = 0.0;
        protected double sales = 0.0;
        protected AdBrixRm.Currency currency;
        protected CommerceCategoriesModel category;
        protected JSONObject extraAttrs;

        public CommerceProductModel() {
            this.extraAttrs = new JSONObject();
        }

        public String getProductID() {
            return productID;
        }

        public CommerceProductModel setProductID(String productID) {
            this.productID = productID;
            return this;
        }

        public String getProductName() {
            return productName;
        }

        public CommerceProductModel setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public double getPrice() {
            return price;
        }

        public CommerceProductModel setPrice(double price) {
            this.price = price;
            return this;
        }

        public int getQuantity() {
            return quantity;
        }

        public CommerceProductModel setQuantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public double getDiscount() {
            return discount;
        }

        public CommerceProductModel setDiscount(double discount) {
            this.discount = discount;
            return this;
        }

        public AdBrixRm.Currency getCurrency() {
            return currency;
        }

        public CommerceProductModel setCurrency(AdBrixRm.Currency currency) {
            this.currency = currency;
            return this;
        }

        public CommerceCategoriesModel getCategory() {
            return category;
        }

        public CommerceProductModel setCategory(CommerceCategoriesModel category) {
            this.category = category;
            return this;
        }

        public CommerceProductModel setAttrModel(AttrModel attrModel) {
            if (attrModel == null) return this;

            this.extraAttrs = attrModel.toJSONObject("CommerceProductModel");
            return this;
        }

        public JSONObject getAttrs() {
            return extraAttrs;
        }
    }

    public static class CommerceCategoriesModel {
        public LinkedList<String> categoriesLinkedList = new LinkedList<String>();
        final int MAX_COMMERCE_CATEGORY_NUMBER = 5;

        public CommerceCategoriesModel() {
        }

        public CommerceCategoriesModel setCategory(String category) {
            if (categoriesLinkedList.size() < MAX_COMMERCE_CATEGORY_NUMBER) {
                if (!CommonUtils.isNullOrEmpty(category)) this.categoriesLinkedList.add(category);
            } else
                AbxLog.d("Skip adding more categories, MAX_COMMERCE_CATEGORY_NUMBER is " + MAX_COMMERCE_CATEGORY_NUMBER, true);
            return this;
        }
    }

    public static class Currency {
        public static final Currency KR_KRW = new Currency("KR", "KRW");
        public static final Currency US_USD = new Currency("US", "USD");
        public static final Currency JP_JPY = new Currency("JP", "JPY");
        public static final Currency EU_EUR = new Currency("EU", "EUR");
        public static final Currency UK_GBP = new Currency("UK", "GBP");
        public static final Currency CN_CNY = new Currency("CH", "CNY");
        public static final Currency TW_TWD = new Currency("TW", "TWD");
        public static final Currency HK_HKD = new Currency("HK", "HKD");
        //added new currency 2017-09-08 by john
        public static final Currency ID_IDR = new Currency("ID", "IDR");//Indonesia
        public static final Currency IN_INR = new Currency("IN", "INR");//India
        public static final Currency RU_RUB = new Currency("RU", "RUB");//Russia
        public static final Currency TH_THB = new Currency("TH", "THB");//Thailand
        public static final Currency VN_VND = new Currency("VN", "VND");//Vietnam
        public static final Currency MY_MYR = new Currency("MY", "MYR");//Malaysia

        public String country;
        public String code;

        public Currency(String country, String code) {
            this.country = country;
            this.code = code;
        }

        public String getCountry() {
            return country;
        }

        public static Currency getCurrencyByCurrencyCode(String currencyCode) {

            if (currencyCode.equalsIgnoreCase(KR_KRW.toString())) {
                return KR_KRW;
            } else if (currencyCode.equalsIgnoreCase(US_USD.toString())) {
                return US_USD;
            } else if (currencyCode.equalsIgnoreCase(JP_JPY.toString())) {
                return JP_JPY;
            } else if (currencyCode.equalsIgnoreCase(EU_EUR.toString())) {
                return EU_EUR;
            } else if (currencyCode.equalsIgnoreCase(UK_GBP.toString())) {
                return UK_GBP;
            } else if (currencyCode.equalsIgnoreCase(CN_CNY.toString())) {
                return CN_CNY;
            } else if (currencyCode.equalsIgnoreCase(TW_TWD.toString())) {
                return TW_TWD;
            } else if (currencyCode.equalsIgnoreCase(HK_HKD.toString())) {
                return HK_HKD;
            } else if (currencyCode.equalsIgnoreCase(ID_IDR.toString())) {
                return ID_IDR;
            } else if (currencyCode.equalsIgnoreCase(IN_INR.toString())) {
                return IN_INR;
            } else if (currencyCode.equalsIgnoreCase(RU_RUB.toString())) {
                return RU_RUB;
            } else if (currencyCode.equalsIgnoreCase(TH_THB.toString())) {
                return TH_THB;
            } else if (currencyCode.equalsIgnoreCase(VN_VND.toString())) {
                return VN_VND;
            } else if (currencyCode.equalsIgnoreCase(MY_MYR.toString())) {
                return MY_MYR;
            } else {
                return new Currency(currencyCode, currencyCode);
            }
        }

        public static Currency getCurrencyByCountryCode(String countryCode) {
            if (countryCode.equalsIgnoreCase(KR_KRW.getCountry())) {
                return KR_KRW;
            } else if (countryCode.equalsIgnoreCase(US_USD.getCountry())) {
                return US_USD;
            } else if (countryCode.equalsIgnoreCase(JP_JPY.getCountry())) {
                return JP_JPY;
            } else if (countryCode.equalsIgnoreCase(EU_EUR.getCountry())) {
                return EU_EUR;
            } else if (countryCode.equalsIgnoreCase(UK_GBP.getCountry())) {
                return UK_GBP;
            } else if (countryCode.equalsIgnoreCase(CN_CNY.getCountry())) {
                return CN_CNY;
            } else if (countryCode.equalsIgnoreCase(TW_TWD.getCountry())) {
                return TW_TWD;
            } else if (countryCode.equalsIgnoreCase(HK_HKD.getCountry())) {
                return HK_HKD;
            } else if (countryCode.equalsIgnoreCase(ID_IDR.getCountry())) {
                return ID_IDR;
            } else if (countryCode.equalsIgnoreCase(IN_INR.getCountry())) {
                return IN_INR;
            } else if (countryCode.equalsIgnoreCase(RU_RUB.getCountry())) {
                return RU_RUB;
            } else if (countryCode.equalsIgnoreCase(TH_THB.getCountry())) {
                return TH_THB;
            } else if (countryCode.equalsIgnoreCase(VN_VND.getCountry())) {
                return VN_VND;
            } else if (countryCode.equalsIgnoreCase(MY_MYR.getCountry())) {
                return MY_MYR;
            } else {
                return new Currency(countryCode, countryCode);
            }
        }

        @Override
        public String toString() {
            return code;
        }
    }

    public static class CommercePaymentMethod {
        public static final CommercePaymentMethod CreditCard = new CommercePaymentMethod("CreditCard");
        public static final CommercePaymentMethod BankTransfer = new CommercePaymentMethod("BankTransfer");
        public static final CommercePaymentMethod MobilePayment = new CommercePaymentMethod("MobilePayment");
        public static final CommercePaymentMethod ETC = new CommercePaymentMethod("ETC");

        public static final int CreditCardIdx = 1;
        public static final int BankTransferIdx = 2;
        public static final int MobilePaymentIdx = 3;
        public static final int ETCIdx = 4;


        public String method;

        public CommercePaymentMethod(String method) {
            this.method = method;
        }

        public String getMethod() {
            return method;
        }

        public static CommercePaymentMethod getMethodByMethodCode(String mehod) {
            if (mehod.equalsIgnoreCase(CreditCard.getMethod())) {
                return CreditCard;
            } else if (mehod.equalsIgnoreCase(BankTransfer.getMethod())) {
                return BankTransfer;
            } else if (mehod.equalsIgnoreCase(MobilePayment.getMethod())) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public static CommercePaymentMethod getMethodByMethodCode(int mehod) {
            if (mehod == CreditCardIdx) {
                return CreditCard;
            } else if (mehod == BankTransferIdx) {
                return BankTransfer;
            } else if (mehod == MobilePaymentIdx) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        @Override
        public String toString() {
            return method;
        }
    }

    public static class CommerceSharingChannel {
        public static final CommerceSharingChannel Facebook = new CommerceSharingChannel("Facebook");
        public static final CommerceSharingChannel KakaoTalk = new CommerceSharingChannel("KakaoTalk");
        public static final CommerceSharingChannel KakaoStory = new CommerceSharingChannel("KakaoStory");
        public static final CommerceSharingChannel Line = new CommerceSharingChannel("Line");
        public static final CommerceSharingChannel whatsApp = new CommerceSharingChannel("whatsApp");
        public static final CommerceSharingChannel QQ = new CommerceSharingChannel("QQ");
        public static final CommerceSharingChannel WeChat = new CommerceSharingChannel("WeChat");
        public static final CommerceSharingChannel SMS = new CommerceSharingChannel("SMS");
        public static final CommerceSharingChannel Email = new CommerceSharingChannel("Email");
        public static final CommerceSharingChannel copyUrl = new CommerceSharingChannel("copyUrl");
        public static final CommerceSharingChannel ETC = new CommerceSharingChannel("ETC");

        public String channel;

        public CommerceSharingChannel(String channel) {
            this.channel = channel;
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public static CommerceSharingChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(KakaoTalk.getChannel())) {
                return KakaoTalk;
            } else if (channel.equalsIgnoreCase(KakaoStory.getChannel())) {
                return KakaoStory;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(SMS.getChannel())) {
                return SMS;
            } else if (channel.equalsIgnoreCase(Email.getChannel())) {
                return Email;
            } else if (channel.equalsIgnoreCase(copyUrl.getChannel())) {
                return copyUrl;
            } else if (channel.equalsIgnoreCase(ETC.getChannel())) {
                return ETC;
            } else {
                return new CommerceSharingChannel(channel);
            }
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public interface DeferredDeeplinkListener {
        void onReceiveDeferredDeeplink(String uriStr);
    }

    public interface DeeplinkListener {
        void onReceiveDeeplink(String uriStr);
    }

    public static void setDeferredDeeplinkListener(DeferredDeeplinkListener deferredDeeplinkListener){
        AdBrixRm.deferredDeeplinkListener = deferredDeeplinkListener;
    }

    public static void setDeeplinkListener(DeeplinkListener deeplinkListener){
        AdBrixRm.deeplinkListener = deeplinkListener;
    }


    public static void deeplinkEvent(Activity deeplinkActivity) {
        checkAdbrixPause();
        CoreWrapper.deeplink(deeplinkActivity);
    }

    public enum AdBrixEventUploadCountInterval {
        MIN(10),
        NORMAL(30),
        MAX(60);

        private final int value;

        AdBrixEventUploadCountInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public enum AdBrixEventUploadTimeInterval {
        MIN(30_000),
        NORMAL(60_000),
        MAX(120_000);

        private final int value;

        AdBrixEventUploadTimeInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public static void setEventUploadCountInterval(AdBrixEventUploadCountInterval eventUploadCountInterval){
        if (checkAdbrixPause()) return;

        int minValue = AdBrixEventUploadCountInterval.MIN.getIntValue();
        int defValue = AdBrixEventUploadCountInterval.NORMAL.getIntValue();
        int maxValue = AdBrixEventUploadCountInterval.MAX.getIntValue();

        int countIntervalValue = eventUploadCountInterval.getIntValue();

        if (countIntervalValue != minValue && countIntervalValue != defValue && countIntervalValue != maxValue) {
            countIntervalValue = defValue;
        }

        CoreWrapper.setCountInterval(countIntervalValue);
    }

    public static void setEventUploadTimeInterval(AdBrixEventUploadTimeInterval eventUploadTimeInterval){
        if (checkAdbrixPause()) return;

        int minValue = AdBrixEventUploadTimeInterval.MIN.getIntValue();
        int defValue = AdBrixEventUploadTimeInterval.NORMAL.getIntValue();
        int maxValue = AdBrixEventUploadTimeInterval.MAX.getIntValue();

        int timeIntervalValue = eventUploadTimeInterval.getIntValue();

        if (timeIntervalValue != minValue && timeIntervalValue != defValue && timeIntervalValue != maxValue) {
            timeIntervalValue = defValue;
        }

        CoreWrapper.setTimeInterval(timeIntervalValue);
    }

    public static void setAppScanEnable(boolean enable) {
        if (checkAdbrixPause()) return;

        CoreWrapper.setAppScanEnable(enable);
    }

    /*
    Push notification, Pop-Up
     */
    public enum PushColor {
        WHITE, BLACK, BLUE, YELLOW, RED, GREEN
    }

    public interface onTouchLocalPushListener {
        void onTouchLocalPush(String callbackJsonString);
    }

    public interface onTouchRemotePushListener {
        void onTouchRemotePush(String callbackJsonString);
    }

    public static void setRemotePushMessageListener(onTouchRemotePushListener remotePushMessageListener) {
        PushController.getInstance().setRemotePushMessageListener(remotePushMessageListener);
    }

    public static void setLocalPushMessageListener(onTouchLocalPushListener localPushMessageListener) {
        PushController.getInstance().setLocalPushMessageListener(localPushMessageListener);
    }

    public static void setPushEnable(boolean enable) {
        if (checkAdbrixPause()) return;

        PushController.getInstance().setPushEnable(enable);
    }

    public static void setRegistrationId(String token) {
        if (checkAdbrixPause()) return;
        PushController.getInstance().setRegistrationID(token);
    }

    public static void setBigTextClientPushEvent(Context ctx, BigTextPushProperties bigTextPushProp, boolean alwaysIsShown) {
        if (checkAdbrixPause()) return;
        PushController.getInstance().setBigTextClientPushEvent(ctx, bigTextPushProp, alwaysIsShown);
    }

    public static void setBigPictureClientPushEvent(Context ctx, AdBrixRm.BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        if (checkAdbrixPause()) return;
        PushController.getInstance().setBigPictureClientPushEvent(ctx, bigPicturePushProperties, alwaysIsShown);
    }

    public static void cancelClientPushEvent(Context ctx, int eventId) {
        if (checkAdbrixPause()) return;
        PushController.getInstance().cancelClientPushEvent(ctx, eventId);
    }

    public static JSONArray getPushEventList() {
        if (checkAdbrixPause()) return null;
        return AbxPushCommonDAO.getPushEventList();
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, int argb) {
        if (checkAdbrixPause()) return;
        AbxPushCommonDAO.setPushIconStyle(smallIconName, largeIconName, argb);
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, PushColor color) {
        int rgb = -1;
        switch (color) {
            case RED:
                rgb = Color.rgb(255, 0, 0);
                break;
            case BLACK:
                rgb = Color.rgb(0, 0, 0);
                break;
            case BLUE:
                rgb = Color.rgb(0, 0, 255);
                break;
            case WHITE:
                rgb = Color.rgb(255, 255, 255);
                break;
            case GREEN:
                rgb = Color.rgb(0, 255, 0);
                break;
            case YELLOW:
                rgb = Color.rgb(255, 255, 0);
                break;
        }
        AbxPushCommonDAO.setPushIconStyle(smallIconName, largeIconName, rgb);
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconname) {
        setPushIconStyle(context, smallIconName, largeIconname, -1);
    }


    public static void setNotificationOption(Context context, int priority, int visibility) {
        if (checkAdbrixPause()) return;
        AbxPushCommonDAO.setNotificationOption(priority, visibility);
    }

    public static void setNotificationChannel(String channelName, String channelDescription, boolean lightEnable, boolean vibrateEnable) {
        if (checkAdbrixPause()) return;
        AbxPushCommonDAO.setNotificationChannel(channelName, channelDescription, lightEnable, vibrateEnable);
    }

    /**
     * if you use {@link AdBrixRm#setNotificationChannel(String, String, boolean, boolean)},
     * you should set channel importance and visibility by using this method.
     *
     * @param importance, See e.g. {@link android.app.NotificationManager#IMPORTANCE_DEFAULT}
     * @param visibility, See e.g. {@link android.app.Notification#VISIBILITY_PUBLIC}
     */
    public static void setNotificationChannelOption(int importance, int visibility){
        if (checkAdbrixPause()) return;
        AbxPushCommonDAO.setNotificationChannelOption(importance, visibility);
    }

    public static class PushProperties{
        protected long second;
        protected int eventId;
        protected String contentText;
        protected String summaryText;
        protected String bigContentTitle;
        protected String title;
        protected String deepLinkUri;

        public PushProperties() {
            second = 0;
            eventId = 0;
            contentText = "";
            summaryText = "";
            bigContentTitle = "";
            title = "";
            deepLinkUri = "";
        }

        public String getDeepLinkUri() {
            return deepLinkUri;
        }

        public String getTitle() {
            return title;
        }

        public long getSecond() {
            return second;
        }

        public String getContentText() {
            return contentText;
        }

        public String getSummaryText() {
            return summaryText;
        }

        public String getBigContentTitle() {
            return bigContentTitle;
        }

        public int getEventId() {
            return eventId;
        }

    }


    public static class BigTextPushProperties extends PushProperties{
        private String bigText;

        public BigTextPushProperties() {
            bigText = "";
        }

        public String getBigText() {
            return bigText;
        }

        public BigTextPushProperties setTitle(String title) {
            this.title = title;
            return this;
        }

        public BigTextPushProperties setSecond(long second) {
            this.second = second;
            return this;
        }

        public BigTextPushProperties setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public BigTextPushProperties setSummaryText(String summaryText) {
            this.summaryText = summaryText;
            return this;
        }

        public BigTextPushProperties setBigContentTitle(String bigContentTitle) {
            this.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigTextPushProperties setEventId(int eventId) {
            this.eventId = eventId;
            return this;
        }

        public BigTextPushProperties setBigText(String bigText) {
            this.bigText = bigText;
            return this;
        }

        public BigTextPushProperties setDeepLinkUri(String deepLinkUri) {
            this.deepLinkUri = deepLinkUri;
            return this;
        }

        public JSONObject toJSONObject() {
            JSONObject obj = new JSONObject();
            try {
                obj
                        .put("second", second)
                        .put("eventId", eventId)
                        .put("title", title)
                        .put("contentText", contentText)
                        .put("summaryText", summaryText)
                        .put("bigContentTitle", bigContentTitle)
                        .put("bigText", bigText)
                        .put("deepLinkUri", deepLinkUri);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return obj;
        }

        public static BigTextPushProperties fromJSONObject(JSONObject jsonObject) {

            BigTextPushProperties bigTextPushProperties = new BigTextPushProperties();

            try {
                bigTextPushProperties
                        .setSecond(jsonObject.getLong("second"))
                        .setEventId(jsonObject.getInt("eventId"))
                        .setTitle(      CommonUtils.convertNullStringToNull(jsonObject.getString("title")))
                        .setContentText(CommonUtils.convertNullStringToNull(jsonObject.getString("contentText")))
                        .setSummaryText(CommonUtils.convertNullStringToNull(jsonObject.getString("summaryText")))
                        .setBigText(    CommonUtils.convertNullStringToNull(jsonObject.getString("bigContentTitle")))
                        .setBigText(    CommonUtils.convertNullStringToNull(jsonObject.getString("bigText")))
                        .setDeepLinkUri(CommonUtils.convertNullStringToNull(jsonObject.getString("deepLinkUri")));
            } catch (JSONException e) {
                e.printStackTrace();
            }

            return bigTextPushProperties;
        }
    }

    public static class BigPicturePushProperties extends PushProperties{

        private String bigPictureUrl;
        private int resourceId;

        public BigPicturePushProperties() {
            this.bigPictureUrl = "";
            this.resourceId = 0;
        }

        public int getResourceId() {
            return resourceId;
        }

        public BigPicturePushProperties setResourceId(int resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public String getBigPictureUrl() {
            return bigPictureUrl;
        }

        public BigPicturePushProperties setTitle(String title) {
            this.title = title;
            return this;
        }

        public BigPicturePushProperties setBigPictureUrl(String bigPictureUrl) {
            this.bigPictureUrl = bigPictureUrl;
            return this;
        }

        public BigPicturePushProperties setSecond(long second) {
            this.second = second;
            return this;
        }

        public BigPicturePushProperties setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public BigPicturePushProperties setSummaryText(String summaryText) {
            this.summaryText = summaryText;
            return this;
        }

        public BigPicturePushProperties setBigContentTitle(String bigContentTitle) {
            this.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigPicturePushProperties setEventId(int eventId) {
            this.eventId = eventId;
            return this;
        }

        public BigPicturePushProperties setDeepLinkUri(String deepLinkUri) {
            this.deepLinkUri = deepLinkUri;
            return this;
        }

        public JSONObject toJSONObject() {
            JSONObject obj = new JSONObject();
            try {
                obj
                        .put("second", second)
                        .put("eventId", eventId)
                        .put("resourceId", resourceId)
                        .put("title", title)
                        .put("contentText", contentText)
                        .put("summaryText", summaryText)
                        .put("bigContentTitle", bigContentTitle)
                        .put("bigPictureUrl", bigPictureUrl)
                        .put("deepLinkUri", deepLinkUri);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return obj;
        }

        public static BigPicturePushProperties fromJSONObject(JSONObject jsonObject) {

            BigPicturePushProperties bigPicturePushProperties = new BigPicturePushProperties();

            try {
                bigPicturePushProperties
                        .setSecond(jsonObject.getLong("second"))
                        .setEventId(jsonObject.getInt("eventId"))
                        .setResourceId(jsonObject.getInt("resourceId"))
                        .setTitle(          CommonUtils.convertNullStringToNull(jsonObject.getString("title")))
                        .setContentText(    CommonUtils.convertNullStringToNull(jsonObject.getString("contentText")))
                        .setSummaryText(    CommonUtils.convertNullStringToNull(jsonObject.getString("summaryText")))
                        .setBigContentTitle(CommonUtils.convertNullStringToNull(jsonObject.getString("bigContentTitle")))
                        .setBigPictureUrl(  CommonUtils.convertNullStringToNull(jsonObject.getString("bigPictureUrl")))
                        .setDeepLinkUri(    CommonUtils.convertNullStringToNull(jsonObject.getString("deepLinkUri")));
            } catch (JSONException e) {
                e.printStackTrace();
            }

            return bigPicturePushProperties;
        }
    }

//    public static void showBarPopUp(Activity activity, InAppBar resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.BAR, resource);
//    }
//
//    public static void showModalPopUp(Activity activity, InAppModal resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.MODAL, resource);
//    }
//
//    public static void showWebViewPopUp(Activity activity, InAppFullWebView resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_WEB_VIEW, resource);
//    }
//
//    public static void showCarouselPopUp(Activity activity, InAppCarousel resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.CAROUSEL, resource);
//    }
//
//    public static void showFullImagePopUp(Activity activity, InAppFullImage resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_IMAGE, resource);
//    }

    public static void setKakaoId(String kakaoId){
        if (checkAdbrixPause()) return;

        if (kakaoId == null) {
            AbxLog.w("Ignore setKakaoId function :: null value for kakaoId", true);
            return;
        }

        CiProperties ciProperties = new CiProperties();
        ciProperties.setAttrs("kakao_id", kakaoId);

        CoreWrapper.saveCi(ciProperties.propertiesJson);
    }

    /*
     Excluded for privacy reasons
     */
//    public static void setPhoneNumber(String phoneNumber){
//        if (checkAdbrixPause()) return;
//
//        if (phoneNumber == null) {
//            Log.w(ABXConstants.LOGTAG, "Ignore setPhoneNumber function :: null value for phoneNumber");
//            return;
//        }
//
//        CiProperties ciProperties = new CiProperties();
//        ciProperties.setAttrs("phone_number", phoneNumber);
//
//        CoreWrapper.saveCi(ciProperties.propertiesJson);
//    }

    public static void saveCiProperties(String key, Object value){
        if (checkAdbrixPause()) return;

        if (key == null || value == null) {
            AbxLog.w("Ignore setCustomci function :: null value for key or value", true);
            return;
        }

        CiProperties ciProperties = new CiProperties();
        ciProperties.setAttrs(key, value);

        CoreWrapper.saveCi(ciProperties.propertiesJson);
    }

    public static void saveCiProperties(CiProperties ciProperties){
        if (checkAdbrixPause()) return;

        CoreWrapper.saveCi(ciProperties.propertiesJson);
    }
}
