package com.igaworks.v2.core.push.notification;

import android.app.Notification;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.Spanned;
import android.util.TypedValue;

import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.CompatConstants;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.ABXConstants;

public class PushUtils {
    private static final float BASE_WIDTH = 720f;
    private static final float BASE_HEIGHT = 1280f;
    public static int waitingForInitCount = 1;

    private PushUtils(){}

    public static Bitmap getImageResource(Context context, String file) {

        if(context == null) {
            return null;
        }

        Bitmap bm = null;
        if (file == null || file.equals("")) return null;
        // 1. Find in android res/drawable
        try {
            // In this case: File name only, no file extension
            String resName = file;
            if (file.contains(".")) {
                resName = file.substring(0, file.lastIndexOf("."));
                AbxLog.d("getImageResource file name: " + file + " --> " + resName, true);
            }
            int iconId = context.getResources().getIdentifier(resName, "drawable", context.getPackageName());
            if (iconId > 0) {
                InputStream inputStream = context.getResources().openRawResource(iconId);
                bm = BitmapFactory.decodeStream(inputStream);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return bm;
            }
        } catch (Exception e) {
            //LiveOpsLogger.logging(context, "LiveOps", "res/drawable/ >> getImageForLiveOps Error: " + e.getMessage().toString(), LiveOpsLogger.LOG_W, true);
            bm = null;
        } finally {
            bm = null;
        }
        return null;


        /*
        // 2. Find in assets/igaworks/liveops/res
        try{

            AssetManager assetmanager = context.getResources().getAssets();
            InputStream inputStream = assetmanager.open("igaworks/liveops/res/" + file);
            bm = BitmapFactory.decodeStream(inputStream);

            if(inputStream != null) inputStream.close();
            return bm;
        }catch(Exception e){
            //LiveOpsLogger.logging(context, "LiveOps", "assets/ >> getImageForLiveOps Error: " + e.getMessage().toString(), LiveOpsLogger.LOG_E, true);
            bm = null;
        }

        // 3. Find in com/igaworks/liveops/res ( bundled in jar file created by Eclipse fat jar)
        try {

            String path = "com/igaworks/liveops/res/" + file;
            InputStream inputStream = context.getClassLoader().getResourceAsStream(path);

            bm = BitmapFactory.decodeStream(inputStream);

            if (inputStream != null) {

                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return bm;
        } catch (Exception e) { bm = null;}
        return bm;

        */
    }


    public static JSONObject getJsonStringFromBundle(Bundle bundle) {
        JSONObject obj = new JSONObject();
        try {
            for (String key : bundle.keySet()) {
                Object temp = bundle.get(key);
                if (temp != null && key.equals(CompatConstants.PUSH_REMOTE_KEY_DEEPLINKJSON)) {
                    try {
                        JSONObject deepLinkJSON = new JSONObject((String) temp);
                        obj.put(key, deepLinkJSON);
                        continue;
                    } catch (Exception e) {
                        AbxLog.d("ERROR:: Invaild deeplink Json", true);
                        continue;
                    }
                }
                if (temp != null) {
                    obj.put(key, bundle.get(key));
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Bitmap getImageResource(Context context, int resId) {
        Bitmap bm = null;
        try {
            if (resId > 0) {
                InputStream inputStream = context.getResources().openRawResource(resId);
                bm = BitmapFactory.decodeStream(inputStream);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e) {
                        AbxLog.e("Exception : get image resource : "+e.getMessage(), true);
                    }
                }
                return bm;
            }
        } catch (Exception e) {
            AbxLog.e("Exception : Can't get a image.. id = "+resId+" msg : "+e.getMessage(), true);
            return null;
        }
        AbxLog.w("ERROR : Can't get a image.. id = "+resId, true);
        return null;
    }
    @SuppressWarnings("deprecation")
    public static Spanned fromHtml(String html) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            return Html.fromHtml(html, Html.FROM_HTML_MODE_LEGACY);
        } else {
            return Html.fromHtml(html);
        }
    }

    public static Bitmap getBitmapFromURL(String imageUrl) {
        HttpURLConnection connection = null;
        InputStream input = null;
        try {
            URL url = new URL(imageUrl);
            connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream(input);
            return myBitmap;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            if (input != null) try {
                input.close();
            } catch (IOException e) {
            }
            if (connection != null) {
                try {
                    OutputStream outputStream = connection.getOutputStream();
                    if (outputStream != null) {
                        outputStream.close();
                    }
                } catch (Exception e) {
                }

                try {
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        errorStream.close();
                    }
                } catch (Exception e) {
                }
                connection.disconnect();
            }
        }
    }

    public static int convertPixelToDP(Context context, int px, boolean isX) {

        int width = context.getResources().getDisplayMetrics().widthPixels;
        int height = context.getResources().getDisplayMetrics().heightPixels;

        if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            width = context.getResources().getDisplayMetrics().heightPixels;
            height = context.getResources().getDisplayMetrics().widthPixels;
        }

        float difX = width / BASE_WIDTH;
        float difY = height / BASE_HEIGHT;

        if (difX != difY) {
            difY = difX;
        }

        float norPx = px;

        if (isX) {
            norPx = (px * difX);
        } else {
            norPx = (px * difY);
        }

        if (norPx < 1.5f) {
            norPx = 1.5f;
        }

        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_PX, norPx, context.getResources().getDisplayMetrics());

    }

    public static int calNormPixel(Context context, int px, boolean isX) {

        int width = context.getResources().getDisplayMetrics().widthPixels;
        int height = context.getResources().getDisplayMetrics().heightPixels;

        if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            width = context.getResources().getDisplayMetrics().heightPixels;
            height = context.getResources().getDisplayMetrics().widthPixels;
        }
        float difX = width / BASE_WIDTH;
        float difY = height / BASE_HEIGHT;
        if (difX != difY) {
            difY = difX;
        }
        int norPx = px;
        if (isX) {
            norPx = (int) (px * width / BASE_WIDTH);
        } else {
            norPx = (int) (px * height / BASE_HEIGHT);
        }
        return norPx;
    }

    public static Object getObjectFromByteArray(byte[] byteArray) {

        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        ObjectInput in = null;
        AdBrixRm.BigTextPushProperties prop = null;
        try {
            in = new ObjectInputStream(bis);
            return in.readObject();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] getByteArrayFromObject(Object bigTextPushProperties) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(bigTextPushProperties);
            out.flush();
            byte[] data = bos.toByteArray();
            return data;
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                bos.close();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
    protected static boolean checkHasVaildKey(JSONObject objFromServer, String key) {
        try {
            if (objFromServer.has(key)) {
                return JSONObject.NULL != objFromServer.get(key);
            }
        } catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    @SuppressWarnings("deprecation")
    public static Notification.Builder createNotificationBuilder(Context context){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            return new Notification.Builder(context, ABXConstants.PUSH_NOTIFICATION_CHANNEL_ID);
        }
        else return new Notification.Builder(context);
    }
}
