package com.igaworks.v2.core.push.notification;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;

import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.CompatConstants;
import com.igaworks.v2.core.push.PushController;

import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;

public class PushLocalBridge {

    public static final int PUSH_SECOND_OFFSET = 1000;

    private PushLocalBridge(){}

    public static void setBigTextClientPushEvent(Context ctx, AdBrixRm.BigTextPushProperties bigTextPushProperties, boolean alwaysIsShown) {
        if(PushController.getInstance().getPushEnable() == false){
            AbxLog.w("Push service is not available : push enable = "+ false, false);
            return;
        }
        if (bigTextPushProperties.getSecond() < 0) {
            AbxLog.e("Wrong input parameters! Second parmeter must be a positive integer.", false);
        } else {
            long notificationTime;
            String propObjToString;
            Bundle bundle;
            AlarmManager alarmManager;
            Intent alarmIntent;
            PendingIntent pendingIntent;

            AbxLog.d("PushBridge :: Big Text Client Push ! ", true);
            notificationTime = System.currentTimeMillis() + (bigTextPushProperties.getSecond() * PUSH_SECOND_OFFSET);
            alarmIntent = new Intent(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE);
            alarmIntent.setClass(ctx, AbxPushReceiver.class);

            bundle = new Bundle();
            bundle.putBoolean(CompatConstants.PUSH_USER_INPUT_ALWAYS_IS_SHOWN, alwaysIsShown);
            bundle.putString(CompatConstants.PUSH_PROP_STYLE, CompatConstants.PUSH_STYLE_BIG_TEXT);

            JSONObject bigTextJson = bigTextPushProperties.toJSONObject();
            propObjToString = bigTextJson.toString();
            if (propObjToString != null) {
                bundle.putString(CompatConstants.PUSH_TEXT_PROPERTIES, propObjToString);
            }

            alarmIntent.putExtras(bundle);
            pendingIntent = PendingIntent.getBroadcast(ctx, bigTextPushProperties.getEventId(), alarmIntent, PendingIntent.FLAG_CANCEL_CURRENT);
            alarmManager = (AlarmManager) ctx.getSystemService(Context.ALARM_SERVICE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                alarmManager.setExact(AlarmManager.RTC_WAKEUP, notificationTime, pendingIntent);
                // http://developer.android.com/reference/android/app/AlarmManager.html
            } else {
                alarmManager.set(AlarmManager.RTC_WAKEUP, notificationTime, pendingIntent);
            }
            AbxPushCommonDAO.insertOrReplacePushEvent(bigTextPushProperties.getBigContentTitle(), bigTextPushProperties.getContentText(), bigTextPushProperties.getEventId(), notificationTime, 1);
        }
    }

    public static void setBigPictureClientPushEvent(Context ctx, AdBrixRm.BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        if(PushController.getInstance().getPushEnable() == false){
            AbxLog.w("Push service is not available : push enable = " + false, false);
            return;
        }
        if (bigPicturePushProperties.getSecond() < 0) {
            AbxLog.e("Wrong input parameters! Second parmeter must be a positive integer.", false);
        } else {
            AbxLog.d("PushBridge :: Big Picture Client Push ! ", true);
            long notificationTime;
            String propObjToString;
            Bundle bundle;
            AlarmManager alarmManager;
            Intent alarmIntent;
            PendingIntent pendingIntent;

            notificationTime = System.currentTimeMillis() + (bigPicturePushProperties.getSecond() * PUSH_SECOND_OFFSET);

            bundle = new Bundle();
            bundle.putBoolean(CompatConstants.PUSH_USER_INPUT_ALWAYS_IS_SHOWN, alwaysIsShown);
            bundle.putString(CompatConstants.PUSH_PROP_STYLE, CompatConstants.PUSH_STYLE_BIG_PICTURE);

            JSONObject bigPictureJson = bigPicturePushProperties.toJSONObject();
            propObjToString = bigPictureJson.toString();
            if (propObjToString != null) {
                bundle.putString(CompatConstants.PUSH_PICTURE_PROPERTIES, propObjToString);
            }

            alarmIntent = new Intent(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE);
            alarmIntent.setClass(ctx, AbxPushReceiver.class);
            alarmIntent.putExtras(bundle);

            pendingIntent = PendingIntent.getBroadcast(ctx, bigPicturePushProperties.getEventId(), alarmIntent, PendingIntent.FLAG_CANCEL_CURRENT);
            alarmManager = (AlarmManager) ctx.getSystemService(Context.ALARM_SERVICE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                alarmManager.setExact(AlarmManager.RTC_WAKEUP, notificationTime, pendingIntent);
                // http://developer.android.com/reference/android/app/AlarmManager.html
            } else {
                alarmManager.set(AlarmManager.RTC_WAKEUP, notificationTime, pendingIntent);
            }
            AbxPushCommonDAO.insertOrReplacePushEvent(bigPicturePushProperties.getBigContentTitle(), bigPicturePushProperties.getContentText(), bigPicturePushProperties.getEventId(), notificationTime, 1);
        }
    }

    public static void cancelClientPushEvent(Context ctx, int eventId) {
        try {
            AbxLog.d("Cancel reserved push :: event Id = " + eventId, false);
            Intent alarmIntent = new Intent(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE);
            alarmIntent.setClass(ctx, AbxPushReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(ctx, eventId, alarmIntent, PendingIntent.FLAG_CANCEL_CURRENT);
            AlarmManager alarmManager = (AlarmManager) ctx.getSystemService(Context.ALARM_SERVICE);
            alarmManager.cancel(pendingIntent);
            long result = AbxPushCommonDAO.deletePushEvent(eventId);
            if (result == -1)
                AbxLog.e("Failed to delete record form push evt table", true);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}

