/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.measure;

import io.devcon5.pageobjects.measure.ResponseTime;
import io.devcon5.pageobjects.measure.TimeMeasure;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class ResponseTimes {
    private static final Map<UUID, ResponseTime> TIMES = new ConcurrentHashMap<UUID, ResponseTime>();
    private static final Consumer<ResponseTime> DEFAULT_CONSUMER = rt -> TIMES.put(rt.getUuid(), (ResponseTime)rt);
    private static AtomicReference<Consumer<ResponseTime>> START_TX_CONSUMER = new AtomicReference<Consumer<ResponseTime>>(DEFAULT_CONSUMER);
    private static AtomicReference<Consumer<ResponseTime>> STOP_TX_CONSUMER = new AtomicReference<Consumer<ResponseTime>>(DEFAULT_CONSUMER);

    private ResponseTimes() {
    }

    public static void clear() {
        TIMES.clear();
    }

    public static void resetResponseTimeHandlers() {
        ResponseTimes.onMeasureStart(DEFAULT_CONSUMER);
        ResponseTimes.onMeasureEnd(DEFAULT_CONSUMER);
    }

    public static void onMeasureStart(Consumer<ResponseTime> responseTimeConsumer) {
        START_TX_CONSUMER.set(responseTimeConsumer);
    }

    public static void onMeasureEnd(Consumer<ResponseTime> responseTimeConsumer) {
        STOP_TX_CONSUMER.set(responseTimeConsumer);
    }

    public static ResponseTime startTx(String transaction) {
        return ResponseTimes.startTx(transaction, Instant.now());
    }

    public static ResponseTime startTx(String transaction, Instant start) {
        ResponseTime trt = new ResponseTime(transaction, start);
        START_TX_CONSUMER.get().accept(trt);
        return trt;
    }

    public static ResponseTime stopTx(ResponseTime finish) {
        return ResponseTimes.collect(finish.isFinished() ? finish : finish.finish());
    }

    public static ResponseTime collect(ResponseTime responseTime) {
        if (!responseTime.isFinished()) {
            throw new AssertionError((Object)"Collecting of unfinished responseTimes is not allowed");
        }
        STOP_TX_CONSUMER.get().accept(responseTime);
        return responseTime;
    }

    public static ResponseTime collect(String transaction, TimeMeasure result) {
        return ResponseTimes.collect(new ResponseTime(transaction, result.getStart(), result.getDuration()));
    }

    public static Map<String, List<ResponseTime>> getResponseTimes() {
        HashMap<String, List<ResponseTime>> result = new HashMap<String, List<ResponseTime>>();
        TIMES.values().stream().forEach(trt -> {
            if (!result.containsKey(trt.getTransaction())) {
                result.put(trt.getTransaction(), new ArrayList());
            }
            ((List)result.get(trt.getTransaction())).add(trt);
        });
        return result;
    }
}

