/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.measure;

import io.devcon5.pageobjects.measure.ResponseTime;
import io.devcon5.pageobjects.measure.ResponseTimeCollector;
import io.devcon5.pageobjects.measure.ResponseTimes;
import io.inkstand.scribble.rules.ExternalResource;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseTimeRecording
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseTimeRecording.class);
    private final ResponseTimeCollector collector = new ResponseTimeCollector();
    private boolean clearGlobalTable = true;
    private boolean printTransactions = true;

    public ResponseTimeRecording clearGlobalTable(boolean clearGlobalTable) {
        this.clearGlobalTable = clearGlobalTable;
        return this;
    }

    public ResponseTimeRecording printTransactions(boolean printTransactions) {
        this.printTransactions = printTransactions;
        return this;
    }

    protected void beforeClass() throws Throwable {
        this.before();
    }

    protected void before() throws Throwable {
        this.collector.startCollecting();
    }

    protected void afterClass() {
        this.after();
    }

    protected void after() {
        this.collector.stopCollecting();
        if (this.printTransactions) {
            LOG.info("Listing transactions");
            Map<String, List<ResponseTime>> responseTimes = ResponseTimes.getResponseTimes();
            for (Map.Entry<String, List<ResponseTime>> e : responseTimes.entrySet()) {
                LOG.info("Transaction {}", (Object)e.getKey());
                for (ResponseTime rt : e.getValue()) {
                    LOG.info("\tstart={} duration={}", (Object)rt.getStart(), (Object)rt.getDuration());
                }
            }
        }
        if (this.clearGlobalTable) {
            ResponseTimes.clear();
        }
    }
}

