/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.measure;

import io.devcon5.pageobjects.measure.TimeMeasure;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;

public class ResponseTime
extends TimeMeasure {
    private final UUID uuid;
    private final String transaction;

    public ResponseTime(String transaction, Instant start) {
        this(UUID.randomUUID(), transaction, start, NEGATIVE);
    }

    public ResponseTime(String txName, Instant start, Duration duration) {
        this(UUID.randomUUID(), txName, start, duration);
    }

    ResponseTime(UUID uuid, String transaction, Instant start, Duration duration) {
        super(start, duration);
        this.uuid = uuid;
        this.transaction = transaction;
    }

    public ResponseTime finish() {
        return this.finish(Instant.now());
    }

    public ResponseTime finish(Instant end) {
        if (this.isFinished()) {
            throw new IllegalStateException("Transaction already finished");
        }
        return new ResponseTime(this.uuid, this.transaction, this.getStart(), Duration.between(this.getStart(), end));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64).append("ResponseTime{").append("transaction='").append(this.transaction).append('\'').append(", start=").append(this.getStart()).append(", duration=").append(this.getDuration()).append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseTime that = (ResponseTime)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

