/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.SeleniumContext;
import io.devcon5.pageobjects.User;
import io.inkstand.scribble.rules.ExternalResource;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumControl
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(SeleniumControl.class);
    private String baseUrl;
    private BiConsumer<User, WebDriver> loginAction;
    private Consumer<WebDriver> logoutAction;
    private final AtomicBoolean loggedIn = new AtomicBoolean(false);
    private Optional<Consumer<WebDriver.Options>> driverInit;
    private Instant startTime;
    private Duration testDuration;
    private Supplier<WebDriver> driverProvider;
    private Optional<SeleniumContext> managedContext;

    protected void before() throws Throwable {
        this.managedContext = this.getSeleniumContext();
        this.managedContext.ifPresent(SeleniumContext::init);
        SeleniumContext.currentContext().get().setBaseUrl(this.baseUrl);
        SeleniumContext.currentDriver().ifPresent(d -> {
            d.get(this.baseUrl);
            this.driverInit.ifPresent(di -> di.accept(d.manage()));
        });
        this.startTime = Instant.now();
    }

    protected void after() {
        Instant finishTime = Instant.now();
        this.managedContext.ifPresent(SeleniumContext::destroy);
        this.testDuration = Duration.between(this.startTime, finishTime);
        LOG.info("Test executed in {} s", (Object)this.testDuration.getSeconds());
    }

    protected void beforeClass() throws Throwable {
        this.before();
    }

    protected void afterClass() {
        this.after();
    }

    private Optional<SeleniumContext> getSeleniumContext() {
        return Optional.ofNullable((SeleniumContext)SeleniumContext.currentContext().map(c -> null).orElse(new SeleniumContext(this.driverProvider)));
    }

    public final void login(User user) {
        this.currentDriver().ifPresent(d -> {
            this.loginAction.accept(user, (WebDriver)d);
            this.loggedIn.set(true);
        });
    }

    public final void logout() {
        this.currentDriver().ifPresent(d -> {
            this.logoutAction.accept((WebDriver)d);
            this.loggedIn.set(false);
        });
    }

    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Optional<WebDriver> getDriver() {
        return SeleniumContext.currentDriver();
    }

    public Optional<SeleniumContext> currentContext() {
        return SeleniumContext.currentContext();
    }

    public Duration getTestDuration() {
        return Optional.ofNullable(this.testDuration).orElseThrow(() -> new IllegalStateException("Test not finished"));
    }

    public Optional<WebDriver> currentDriver() {
        return this.currentContext().flatMap(ctx -> ctx.getDriver());
    }

    public static SeleniumContextBuilder builder() {
        return new SeleniumContextBuilder();
    }

    public static class SeleniumContextBuilder {
        private Supplier<WebDriver> driver;
        private String baseUrl;
        private BiConsumer<User, WebDriver> loginAction;
        private Consumer<WebDriver> logoutAction;
        private Consumer<WebDriver.Options> optionsInitializer;

        SeleniumContextBuilder() {
        }

        public SeleniumContextBuilder driver(Supplier<WebDriver> driver) {
            this.driver = driver;
            return this;
        }

        public SeleniumContextBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public SeleniumContextBuilder loginAction(BiConsumer<User, WebDriver> loginAction) {
            this.loginAction = loginAction;
            return this;
        }

        public SeleniumContextBuilder logoutAction(Consumer<WebDriver> logoutAction) {
            this.logoutAction = logoutAction;
            return this;
        }

        public SeleniumContextBuilder driverOptions(Consumer<WebDriver.Options> optionsInitializer) {
            this.optionsInitializer = optionsInitializer;
            return this;
        }

        public SeleniumControl build() {
            SeleniumControl ctx = new SeleniumControl();
            ctx.baseUrl = this.baseUrl;
            ctx.driverProvider = this.driver;
            ctx.driverInit = Optional.ofNullable(this.optionsInitializer);
            ctx.loginAction = this.loginAction;
            ctx.logoutAction = this.logoutAction;
            return ctx;
        }
    }
}

