/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.ElementGroup;
import io.devcon5.pageobjects.Locator;
import io.devcon5.pageobjects.PageLoader;
import io.devcon5.pageobjects.SeleniumContext;
import io.devcon5.pageobjects.tx.TransactionHelper;
import io.devcon5.pageobjects.tx.Transactional;
import java.util.Optional;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

public interface Page
extends ElementGroup {
    default public void loadPage() {
        SeleniumContext.currentDriver().map(driver -> {
            Optional.ofNullable(this.getClass().getAnnotation(Locator.class)).flatMap(l -> l.by().locate(l.value())).ifPresent(WebElement::click);
            new WebDriverWait(driver, 150L, 50L).until(d -> "complete".equals(((JavascriptExecutor)d).executeScript("return document.readyState", new Object[0])));
            return Void.TYPE;
        }).orElseThrow(() -> new IllegalStateException("Context not initialized"));
    }

    public static <T extends Page> T navigateTo(Class<T> pageType) {
        T page = PageLoader.loadPage(pageType);
        Optional<Transactional> tx = Optional.ofNullable(Transactional.class.isAssignableFrom(pageType) ? (Transactional)page : null);
        tx.ifPresent(ts -> TransactionHelper.getClassTxName(pageType).ifPresent(ts::txBegin));
        try {
            page.loadPage();
        }
        finally {
            tx.ifPresent(ts -> TransactionHelper.getClassTxName(pageType).ifPresent(ts::txEnd));
        }
        page.locateElements();
        return page;
    }
}

