/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.tx;

import io.devcon5.pageobjects.tx.Transaction;
import io.devcon5.pageobjects.tx.TransactionSupport;
import java.lang.reflect.Method;
import java.util.Optional;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.lang3.StringUtils;

public final class TransactionHelper {
    private TransactionHelper() {
    }

    public static <T extends TransactionSupport> T addTransactionSupport(TransactionSupport transactionSupport) {
        return (T)((TransactionSupport)Enhancer.create(transactionSupport.getClass(), (Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
            Optional<String> txName = TransactionHelper.getTxName(transactionSupport, method);
            try {
                txName.ifPresent(transactionSupport::txBegin);
                Object result = method.invoke((Object)transactionSupport, args);
                if (!TransactionHelper.isCGLibProxy(result) && result instanceof TransactionSupport) {
                    result = TransactionHelper.addTransactionSupport(transactionSupport);
                }
                Object object = result;
                return object;
            }
            finally {
                txName.ifPresent(transactionSupport::txEnd);
            }
        })));
    }

    private static boolean isCGLibProxy(Object object) {
        return object != null && object.getClass().getName().contains("$$EnhancerByCGLIB$$");
    }

    public static Optional<String> getTxName(Object object, Method method) {
        return Optional.ofNullable(method.getAnnotation(Transaction.class)).map(t -> TransactionHelper.getClassTxName(object.getClass()).map(ctx -> ctx + '_').orElse("") + (StringUtils.isEmpty((CharSequence)t.value()) ? method.getName() : t.value()));
    }

    public static Optional<String> getClassTxName(Class<?> type) {
        return Optional.ofNullable(type.getAnnotation(Transaction.class)).map(t -> StringUtils.isEmpty((CharSequence)t.value()) ? type.getSimpleName() : t.value());
    }
}

