/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.measure;

import io.devcon5.pageobjects.measure.ResponseTime;
import io.devcon5.pageobjects.measure.ResponseTimes;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseTimeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseTimeCollector.class);
    private static final ThreadLocal<Optional<ResponseTimeCollector>> CURRENT = ThreadLocal.withInitial(Optional::empty);
    private final Map<String, ResponseTime> responseTimes = new ConcurrentHashMap<String, ResponseTime>();

    public static Optional<ResponseTimeCollector> current() {
        return CURRENT.get();
    }

    public void startCollecting() {
        CURRENT.set(Optional.of(this));
    }

    public void stopCollecting() {
        CURRENT.set(Optional.empty());
        if (!this.responseTimes.isEmpty()) {
            LOG.warn("Some Transactions have not been completed:\n{}", (Object)this.responseTimes.values().stream().map(ResponseTime::toString).collect(Collectors.joining("\n")));
            this.responseTimes.clear();
        }
    }

    public void captureTx(String txName, Instant start, Instant end) {
        this.captureTx(txName, start, Duration.between(start, end));
    }

    public void captureTx(String txName, Instant start, Duration duration) {
        LOG.trace("TX {} started {} took {}", new Object[]{txName, start, duration});
        ResponseTimes.collect(new ResponseTime(txName, start, duration));
    }

    public void startTx(String tx) {
        Instant now = Instant.now();
        LOG.trace("TX Start {} at {}", (Object)tx, (Object)now);
        this.responseTimes.put(tx, ResponseTimes.startTx(tx, now));
    }

    public void stopTx(String tx) {
        Instant now = Instant.now();
        this.stopTx(tx, now);
    }

    public void stopTx(String tx, Instant now) {
        if (!this.responseTimes.containsKey(tx)) {
            throw new IllegalStateException("Transaction " + tx + " not started");
        }
        LOG.trace("TX End {} at {}", (Object)tx, (Object)now);
        ResponseTimes.stopTx(this.responseTimes.remove(tx).finish(now));
    }
}

