/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.measure;

import io.devcon5.pageobjects.measure.TimeMeasure;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public class MeasuredExecutionResult<RESULTTYPE>
extends TimeMeasure {
    private final Optional<RESULTTYPE> result;
    private final Optional<Throwable> throwable;

    public MeasuredExecutionResult(Instant start, Duration duration, RESULTTYPE result) {
        super(start, duration);
        this.result = Optional.ofNullable(result);
        this.throwable = Optional.empty();
    }

    public MeasuredExecutionResult(Instant start, Duration duration, Throwable throwable) {
        super(start, duration);
        this.result = Optional.empty();
        this.throwable = Optional.of(throwable);
    }

    public Optional<RESULTTYPE> getReturnValue() {
        return this.result;
    }

    public Optional<Throwable> getException() {
        return this.throwable;
    }

    public boolean wasSuccessful() {
        return !this.throwable.isPresent();
    }
}

