/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects.measure;

import io.devcon5.pageobjects.measure.MeasuredExecutionResult;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;

public final class ExecutionStopWatch {
    private ExecutionStopWatch() {
    }

    public static MeasuredExecutionResult runMeasured(Runnable r) {
        return ExecutionStopWatch.runMeasured(() -> {
            r.run();
            return Void.TYPE;
        });
    }

    public static <T> MeasuredExecutionResult<T> runMeasured(Callable<T> callable) {
        MeasuredExecutionResult<Object> result;
        Instant start = Instant.now();
        try {
            T returnValue = callable.call();
            Duration duration = Duration.between(start, Instant.now());
            result = new MeasuredExecutionResult<T>(start, duration, returnValue);
        }
        catch (Exception e) {
            result = new MeasuredExecutionResult(start, Duration.between(start, Instant.now()), e);
        }
        return result;
    }
}

