/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;

public class SeleniumContext {
    private static ThreadLocal<Optional<SeleniumContext>> CONTEXT = ThreadLocal.withInitial(() -> Optional.empty());
    private Optional<WebDriver> driver = Optional.empty();
    private final Supplier<WebDriver> provider;
    private final AtomicReference<String> baseUrl = new AtomicReference();

    public SeleniumContext(Supplier<WebDriver> provider) {
        Objects.requireNonNull(provider, "WebDriver must not be null");
        this.provider = provider;
    }

    public void init() {
        this.driver = Optional.of(this.provider.get());
        CONTEXT.set(Optional.of(this));
    }

    public void destroy() {
        this.driver.ifPresent(WebDriver::quit);
        this.driver = Optional.empty();
        CONTEXT.set(Optional.empty());
    }

    public static Optional<SeleniumContext> currentContext() {
        return CONTEXT.get();
    }

    public static Optional<WebDriver> currentDriver() {
        return SeleniumContext.currentContext().flatMap(ctx -> ctx.getDriver());
    }

    public Optional<WebDriver> getDriver() {
        return this.driver;
    }

    public String getBaseUrl() {
        return this.baseUrl.get();
    }

    public void setBaseUrl(String baseUrl) {
        Objects.requireNonNull(baseUrl, "BaseUrl must not be empty");
        this.baseUrl.set(baseUrl);
    }

    public static String resolve(String relativePath) {
        return SeleniumContext.currentContext().map(SeleniumContext::getBaseUrl).map(base -> {
            StringBuilder buf = new StringBuilder(16);
            buf.append((String)base);
            if (base.charAt(base.length() - 1) != '/') {
                buf.append('/');
            }
            if (relativePath.startsWith("/")) {
                buf.append(relativePath.substring(1));
            } else {
                buf.append(relativePath);
            }
            return buf.toString();
        }).orElse(relativePath);
    }
}

