/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.Page;
import io.devcon5.pageobjects.tx.TransactionHelper;
import io.devcon5.pageobjects.tx.TransactionSupport;

public final class PageLoader {
    private PageLoader() {
    }

    public static <T extends Page> T loadPage(Class<T> pageType) {
        try {
            Page page = (Page)pageType.newInstance();
            if (TransactionSupport.class.isAssignableFrom(pageType)) {
                page = (Page)TransactionHelper.addTransactionSupport((TransactionSupport)((Object)page));
            }
            return (T)page;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError("Page " + pageType.getName() + " can not be loaded", e);
        }
    }
}

