/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.Locator;
import io.devcon5.pageobjects.SeleniumContext;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebElementLocator {
    private static final Logger LOG = LoggerFactory.getLogger(WebElementLocator.class);

    private WebElementLocator() {
    }

    public static WebElement locate(Locator loc) {
        LOG.debug("Locating element with {}={} (timeout={})", new Object[]{loc.by().name(), loc.value(), loc.timeout()});
        return WebElementLocator.waitForElement(loc.by().withSelector(loc.value()), loc.timeout()).get();
    }

    public static WebElement locate(SearchContext context, Locator loc) {
        LOG.debug("Locating element with {}={} (timeout={}) in {}", new Object[]{loc.by().name(), loc.value(), loc.timeout(), context});
        return WebElementLocator.waitForElement(context, loc.by().withSelector(loc.value()), loc.timeout());
    }

    public static WebElement waitForElement(SearchContext context, By by, int waitSec) {
        new FluentWait((Object)context).ignoring(NoSuchElementException.class).withTimeout((long)waitSec, TimeUnit.SECONDS).until(d -> context.findElement(by).isDisplayed());
        return context.findElement(by);
    }

    public static Optional<WebElement> waitForElement(By by, int waitSec) {
        return SeleniumContext.currentDriver().map(d -> WebElementLocator.waitForElement((SearchContext)d, by, waitSec));
    }
}

