/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.classutils.ClassStreams;
import io.devcon5.pageobjects.ElementGroup;
import io.devcon5.pageobjects.Locator;
import io.devcon5.pageobjects.WebElementLocator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.openqa.selenium.SearchContext;

public final class PageObjectsInjector {
    private PageObjectsInjector() {
    }

    public static void injectMethods(ElementGroup group) {
        ClassStreams.selfAndSupertypes(group.getClass()).flatMap(c -> Stream.of(c.getDeclaredMethods())).filter(m -> Void.TYPE.isAssignableFrom(m.getReturnType()) && m.getParameterCount() == 1 && Supplier.class.isAssignableFrom(m.getParameterTypes()[0])).forEach(m -> Optional.ofNullable(m.getDeclaredAnnotation(Locator.class)).ifPresent(loc -> PageObjectsInjector.invokeSetter(m, group, loc)));
    }

    private static void invokeSetter(Method m, ElementGroup target, Locator loc) {
        m.setAccessible(true);
        try {
            m.invoke((Object)target, () -> WebElementLocator.locate(target.getSearchContext(), loc));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not init " + m, e);
        }
    }

    public static void injectFields(ElementGroup group) {
        PageObjectsInjector.injectWebElements(group);
        PageObjectsInjector.injectElementGroups(group);
    }

    private static void injectWebElements(ElementGroup group) {
        ClassStreams.selfAndSupertypes(group.getClass()).flatMap(c -> Stream.of(c.getDeclaredFields())).filter(f -> Supplier.class.isAssignableFrom(f.getType())).forEach(f -> Optional.ofNullable(f.getDeclaredAnnotation(Locator.class)).ifPresent(loc -> PageObjectsInjector.injectWebElement(group, f, loc)));
    }

    private static void injectElementGroups(ElementGroup group) {
        ClassStreams.selfAndSupertypes(group.getClass()).flatMap(c -> Stream.of(c.getDeclaredFields())).filter(f -> ElementGroup.class.isAssignableFrom(f.getType())).forEach(f -> PageObjectsInjector.injectElementGroup(f, group));
    }

    public static void injectWebElement(ElementGroup target, Field field, Locator locator) {
        field.setAccessible(true);
        try {
            field.set(target, () -> WebElementLocator.locate(target.getSearchContext(), locator));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not init " + field, e);
        }
    }

    private static void injectElementGroup(Field target, ElementGroup parent) {
        try {
            Class<?> elementGroupType = target.getType();
            ElementGroup nestedGroup = Optional.ofNullable(target.getAnnotation(Locator.class)).map(loc -> PageObjectsInjector.createContextualInstance(elementGroupType, loc, parent)).orElseGet(() -> PageObjectsInjector.createDefaultInstance(elementGroupType));
            target.setAccessible(true);
            target.set(parent, nestedGroup);
            PageObjectsInjector.injectFields(nestedGroup);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not init element group", e);
        }
    }

    private static ElementGroup createContextualInstance(Class<? extends ElementGroup> elementGroupType, Locator loc, ElementGroup parent) {
        return (ElementGroup)loc.by().locate(parent.getSearchContext(), loc.value()).map(context -> PageObjectsInjector.createContextualInstance(elementGroupType, (SearchContext)context)).orElseGet(() -> Optional.of(PageObjectsInjector.createDefaultInstance(elementGroupType))).get();
    }

    private static Optional<ElementGroup> createContextualInstance(Class<? extends ElementGroup> elementGroupType, SearchContext context) {
        return Stream.of(elementGroupType.getConstructors()).filter(c -> c.getParameterCount() == 1 && SearchContext.class.isAssignableFrom(c.getParameterTypes()[0])).map(c -> {
            try {
                c.setAccessible(true);
                return (ElementGroup)c.newInstance(context);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Could not create element group " + elementGroupType, e);
            }
        }).findFirst();
    }

    public static ElementGroup createDefaultInstance(Class<?> elementGroupType) {
        try {
            return (ElementGroup)elementGroupType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not create element group using default constructor", e);
        }
    }
}

