/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.ElementGroup;
import io.devcon5.pageobjects.Locator;
import io.devcon5.pageobjects.SeleniumContext;
import java.util.Optional;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

public interface Page
extends ElementGroup {
    default public Optional<WebElement> navigateTo() {
        return SeleniumContext.currentDriver().map(WebDriver::navigate).flatMap(nav -> Optional.ofNullable(this.getClass().getDeclaredAnnotation(Locator.class)).flatMap(l -> l.by().locate(l.value())));
    }

    public static <T extends Page> T navigateTo(Class<T> pageType) {
        try {
            Page page = (Page)pageType.newInstance();
            page.navigateTo().ifPresent(WebElement::click);
            SeleniumContext.currentDriver().map(d -> new WebDriverWait(d, 150L, 50L)).orElseThrow(() -> new IllegalStateException("Context not initialized")).until(d -> "complete".equals(((JavascriptExecutor)d).executeScript("return document.readyState", new Object[0])));
            page.locateElements();
            return (T)page;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

