/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class ExecutionStopWatch {
    private final Runnable runnable;
    private final AtomicReference<Object> result = new AtomicReference<Class<Void>>(Void.TYPE);
    private Duration duration;

    private ExecutionStopWatch(Runnable r) {
        this.runnable = () -> r.run();
    }

    private ExecutionStopWatch(Callable c) {
        this.runnable = () -> {
            try {
                this.result.set(c.call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ExecutionStopWatch measure(Runnable r) {
        return new ExecutionStopWatch(r).run();
    }

    public static ExecutionStopWatch measure(Callable c) {
        return new ExecutionStopWatch(c).run();
    }

    private ExecutionStopWatch run() {
        long start = System.nanoTime();
        try {
            this.runnable.run();
        }
        finally {
            this.duration = Duration.ofNanos(System.nanoTime() - start);
        }
        return this;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Optional<Object> getResult() {
        return Optional.ofNullable(this.result.get());
    }
}

