/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.classutils.ClassStreams;
import io.devcon5.pageobjects.PageObjectsInjector;
import io.devcon5.pageobjects.SeleniumContext;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.openqa.selenium.SearchContext;

public interface ElementGroup {
    default public SearchContext getSearchContext() {
        return (SearchContext)SeleniumContext.currentDriver().orElseThrow(() -> new IllegalStateException("Could not obtain current driver outside of test execution"));
    }

    default public <T extends ElementGroup> T get(Class<T> groupType, Class<? extends Annotation> ... qualifiers) {
        return (T)((ElementGroup)ClassStreams.selfAndSupertypes(this.getClass()).flatMap(c -> Stream.of(c.getDeclaredFields())).filter(f -> groupType.isAssignableFrom(f.getType()) && (qualifiers.length == 0 || Stream.of(qualifiers).anyMatch(q -> f.getAnnotation(q) != null))).map(f -> {
            f.setAccessible(true);
            try {
                return f.get(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not retrieve field " + f, e);
            }
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("No element group of type " + groupType + " found")));
    }

    default public void locateElements() {
        PageObjectsInjector.injectFields(this);
        PageObjectsInjector.injectMethods(this);
    }
}

