/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.Locator;
import io.devcon5.pageobjects.SeleniumContext;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public final class WebElementLocator {
    private WebElementLocator() {
    }

    public static WebElement locate(Locator loc) {
        return WebElementLocator.waitForElement(loc.by().withSelector(loc.value()), loc.timeout()).get();
    }

    public static WebElement locate(SearchContext context, Locator loc) {
        return WebElementLocator.waitForElement(context, loc.by().withSelector(loc.value()), loc.timeout()).get();
    }

    public static Optional<WebElement> waitForElement(SearchContext context, By by, int waitSec) {
        return SeleniumContext.currentDriver().map(driver -> {
            new FluentWait(driver).ignoring(NoSuchElementException.class).withTimeout((long)waitSec, TimeUnit.SECONDS).until(d -> context.findElement(by).isDisplayed());
            return driver.findElement(by);
        });
    }

    public static Optional<WebElement> waitForElement(By by, int waitSec) {
        return SeleniumContext.currentDriver().flatMap(d -> WebElementLocator.waitForElement((SearchContext)d, by, waitSec));
    }
}

