/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.ExecutionStopWatch;
import io.devcon5.pageobjects.User;
import io.inkstand.scribble.rules.ExternalResource;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumContext
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(SeleniumContext.class);
    private static ThreadLocal<SeleniumContext> CONTEXT = new ThreadLocal();
    private WebDriver driver;
    private String baseUrl;
    private BiConsumer<User, WebDriver> loginAction;
    private Consumer<WebDriver> logoutAction;
    private AtomicBoolean loggedIn = new AtomicBoolean(false);
    private Duration loginTime;
    private Consumer<WebDriver.Options> driverInit;

    protected void before() throws Throwable {
        this.driver.get(this.baseUrl);
        this.driverInit.accept(this.driver.manage());
        CONTEXT.set(this);
    }

    protected void after() {
        this.getDriver().ifPresent(d -> d.quit());
        CONTEXT.set(null);
    }

    public final void login(User user) {
        this.loginTime = ExecutionStopWatch.measure(() -> SeleniumContext.currentDriver().ifPresent(d -> {
            this.loginAction.accept(user, (WebDriver)d);
            this.loggedIn.set(true);
        })).getDuration();
    }

    public final void logout() {
        SeleniumContext.currentDriver().ifPresent(d -> {
            this.logoutAction.accept((WebDriver)d);
            this.loggedIn.set(false);
        });
    }

    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    public Duration getLoginTime() {
        return this.loginTime;
    }

    public Optional<WebDriver> getDriver() {
        return Optional.ofNullable(this.driver);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static Optional<SeleniumContext> currentContext() {
        return Optional.ofNullable(CONTEXT.get());
    }

    public static String resolve(String relativePath) {
        return SeleniumContext.currentContext().map(SeleniumContext::getBaseUrl).map(base -> {
            StringBuilder buf = new StringBuilder(16);
            buf.append((String)base);
            if (base.charAt(base.length() - 1) != '/') {
                buf.append('/');
            }
            if (relativePath.startsWith("(/")) {
                buf.append(relativePath.substring(1));
            } else {
                buf.append(relativePath);
            }
            return buf.toString();
        }).orElse(relativePath);
    }

    public static Optional<WebDriver> currentDriver() {
        return SeleniumContext.currentContext().flatMap(ctx -> ctx.getDriver());
    }

    public static SeleniumContextBuilder builder() {
        return new SeleniumContextBuilder();
    }

    public static class SeleniumContextBuilder {
        private Supplier<WebDriver> driver;
        private String baseUrl;
        private BiConsumer<User, WebDriver> loginAction;
        private Consumer<WebDriver> logoutAction;
        private Consumer<WebDriver.Options> optionsInitializer;

        private SeleniumContextBuilder() {
        }

        public SeleniumContextBuilder driver(Supplier<WebDriver> driver) {
            this.driver = driver;
            return this;
        }

        public SeleniumContextBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public SeleniumContextBuilder loginAction(BiConsumer<User, WebDriver> loginAction) {
            this.loginAction = loginAction;
            return this;
        }

        public SeleniumContextBuilder logoutAction(Consumer<WebDriver> logoutAction) {
            this.logoutAction = logoutAction;
            return this;
        }

        public SeleniumContextBuilder driverOptions(Consumer<WebDriver.Options> optionsInitializer) {
            this.optionsInitializer = optionsInitializer;
            return this;
        }

        public SeleniumContext build() {
            SeleniumContext ctx = new SeleniumContext();
            ctx.baseUrl = this.baseUrl;
            ctx.driver = this.driver.get();
            ctx.driverInit = this.optionsInitializer;
            ctx.loginAction = this.loginAction;
            ctx.logoutAction = this.logoutAction;
            return ctx;
        }
    }
}

