/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.pageobjects;

import io.devcon5.pageobjects.SeleniumContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
public @interface Locator {
    public String value();

    public ByLocator by() default ByLocator.URL;

    public int timeout() default 60;

    public static enum ByLocator {
        URL(null){

            @Override
            public Optional<WebElement> locate(String selector) {
                return SeleniumContext.currentDriver().flatMap(d -> {
                    d.navigate().to(SeleniumContext.resolve(selector));
                    return Optional.empty();
                });
            }
        }
        ,
        ID(By::id),
        LINK_TEXT(By::linkText),
        PARTIAL_LINK_TEXT(By::partialLinkText),
        NAME(By::name),
        TAG(By::tagName),
        XPATH(By::xpath),
        CLASS(By::className),
        CSS(By::cssSelector);

        private final Optional<Function<String, By>> mapper;

        private ByLocator(Function<String, By> mapper) {
            this.mapper = Optional.ofNullable(mapper);
        }

        public Optional<WebElement> locate(String selector) {
            return SeleniumContext.currentDriver().flatMap(d -> this.locate((SearchContext)d, selector));
        }

        public Optional<WebElement> locate(SearchContext parent, String selector) {
            return this.mapper.map(by -> parent.findElement((By)by.apply(selector)));
        }

        public By withSelector(String selector) {
            return this.mapper.map(by -> (By)by.apply(selector)).orElseThrow(() -> new IllegalArgumentException("Not supported for " + this.name()));
        }
    }
}

