/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.mixin;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Mixin {
    public static OngoingMixinCreation addMixin(Class ... mixins) {
        return new OngoingMixinCreation(mixins);
    }

    private static Object invoke(Object target, Method method, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object invokeDefault(Object proxy, Method method, Object[] args) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            return Mixin.lookupIn(declaringClass).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static MethodHandles.Lookup lookupIn(Class<?> declaringClass) {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (MethodHandles.Lookup)constructor.newInstance(declaringClass, 2);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<Invocable> newInvocable(Object target, Collection<Supplier<Reader>> scripts) {
        Optional<Invocable> invocable;
        if (!scripts.isEmpty()) {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
            engine.put("target", target);
            scripts.stream().forEach(script -> Mixin.loadScript(engine, script));
            invocable = Optional.of((Invocable)((Object)engine));
        } else {
            invocable = Optional.empty();
        }
        return invocable;
    }

    private static void loadScript(ScriptEngine engine, Supplier<Reader> scriptReader) {
        try (Reader reader = scriptReader.get();){
            engine.eval(reader);
        }
        catch (IOException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public static class OngoingMixinCreation {
        private final List<Class> mixins;
        private final Set<Supplier<Reader>> scripts = new HashSet<Supplier<Reader>>();

        private OngoingMixinCreation(Class ... mixinInterfaces) {
            this.mixins = Arrays.asList(mixinInterfaces);
        }

        public OngoingMixinCreation withScript(Supplier<Reader> ... scriptSource) {
            this.scripts.addAll(Arrays.asList(scriptSource));
            return this;
        }

        public Object to(Object target) {
            Optional inv = Mixin.newInvocable(target, this.scripts);
            return Proxy.newProxyInstance(Mixin.class.getClassLoader(), this.mixins.toArray(new Class[0]), (proxy, method, args) -> OngoingMixinCreation.handleInvocation(target, proxy, this.mixins, inv, method, args));
        }

        private static Object handleInvocation(Object target, Object proxy, List<Class> mixins, Optional<Invocable> inv, Method method, Object[] args) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (mixins.contains(declaringClass)) {
                Optional<Object> result = inv.map(invocable -> invocable.getInterface(declaringClass)).map(scriptProxy -> Mixin.invoke(scriptProxy, method, args));
                if (result.isPresent()) {
                    return result.get();
                }
                if (method.isDefault()) {
                    return Mixin.invokeDefault(proxy, method, args);
                }
            }
            return Mixin.invoke(target, method, args);
        }
    }
}

