/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.commons.rest;

import io.devcon5.commons.rest.EntityReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class SimpleRestClient {
    public static RequestBuilder requestTo(String url) {
        try {
            return new RequestBuilder(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static RequestBuilder requestTo(URL url) {
        return new RequestBuilder(url);
    }

    static interface CheckedConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T t) {
            try {
                this.acceptChecked(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void acceptChecked(T var1) throws Exception;
    }

    public static class Response {
        final HttpURLConnection connection;

        Response(HttpURLConnection connection) {
            this.connection = connection;
        }

        public int getStatusCode() {
            try {
                return this.connection.getResponseCode();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getMessage() {
            try {
                return this.connection.getResponseMessage();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasValidResponseCode(int ... validResponseCodes) throws IOException {
            int actualCode = this.connection.getResponseCode();
            for (int validCode : validResponseCodes) {
                if (validCode != actualCode) continue;
                return true;
            }
            return false;
        }

        public InputStream asInputStream(int ... validResponseCodes) {
            this.validateResponseCode(validResponseCodes);
            try {
                return this.connection.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Exception decompiling
         */
        public String asString(int ... validResponseCodes) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public byte[] asBytes(int ... validResponseCodes) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public <T> Optional<T> as(Class<T> targetType, int ... validResponseCodes) {
            this.validateResponseCode(validResponseCodes);
            String contentType = this.getContentType();
            for (EntityReader er : ServiceLoader.load(EntityReader.class)) {
                if (!er.supports(targetType, contentType)) continue;
                return Optional.of(er.read(targetType, contentType, this.asInputStream(new int[0])));
            }
            return Optional.empty();
        }

        private void validateResponseCode(int ... validResponseCodes) {
            try {
                int[] nArray;
                if (validResponseCodes.length == 0) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = 200;
                    nArray2[1] = 201;
                    nArray = nArray2;
                    nArray2[2] = 204;
                } else {
                    nArray = validResponseCodes;
                }
                if (!this.hasValidResponseCode(nArray)) {
                    throw new IllegalStateException("Server returned " + this.connection.getResponseCode() + " " + this.connection.getResponseMessage());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String getContentType() {
            String contentType = this.connection.getHeaderField("Content-Type");
            if (contentType == null) {
                contentType = "*/*";
            }
            return contentType;
        }
    }

    public static class RequestBuilder {
        private URL url;
        private Map<String, String> headers = new HashMap<String, String>();

        RequestBuilder(URL url) {
            this.url = url;
        }

        public RequestBuilder basicAuth(String username, String password) {
            return this.auth(Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
        }

        public RequestBuilder auth(String authToken) {
            this.headers.put("Authorization", authToken);
            return this;
        }

        public RequestBuilder acceptJson() {
            return this.accept("application/json");
        }

        public RequestBuilder accept(String contentType) {
            this.headers.put("Accept", contentType);
            return this;
        }

        public RequestBuilder sendJson() {
            return this.contentType("application/json");
        }

        public RequestBuilder contentType(String contentType) {
            this.headers.put("Content-Type", contentType);
            return this;
        }

        public RequestBuilder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Response get() {
            return this.buildRequest("GET");
        }

        public Response head() {
            return this.buildRequest("HEAD");
        }

        public Response delete() {
            return this.buildRequest("DELETE");
        }

        public Response post(CheckedConsumer<OutputStream> dataProvider) {
            return this.buildRequest("POST", dataProvider);
        }

        public Response put(CheckedConsumer<OutputStream> dataProvider) {
            return this.buildRequest("PUT", dataProvider);
        }

        private Response buildRequest(String method) {
            return this.buildRequest(method, os -> {});
        }

        private Response buildRequest(String method, Consumer<OutputStream> dataProvider) {
            try {
                HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
                con.setRequestMethod(method);
                this.headers.forEach(con::setRequestProperty);
                if (dataProvider != null && ("POST".equals(method) || "PUT".equals(method))) {
                    con.setDoOutput(true);
                    try (OutputStream os = con.getOutputStream();){
                        dataProvider.accept(os);
                    }
                }
                return new Response(con);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

