/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.cli;

import io.devcon5.cli.OptionCollector;
import io.devcon5.cli.OptionInjector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLI {
    private final String[] args;

    private CLI(String ... args) {
        this.args = new String[args.length];
        System.arraycopy(args, 0, this.args, 0, args.length);
    }

    public static CLI parse(String ... args) {
        return new CLI(args);
    }

    public <T> boolean into(T target) {
        Options opts = new OptionCollector().collectFrom(target.getClass());
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(opts, this.args);
            new OptionInjector(commandLine).injectInto(target);
        }
        catch (ParseException e) {
            this.printUsage(opts);
            return false;
        }
        return true;
    }

    public void printUsage(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("[command]", opts);
    }
}

