/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.cli;

import io.devcon5.classutils.ClassStreams;
import io.devcon5.classutils.TypeConverter;
import io.devcon5.cli.CliOption;
import io.devcon5.cli.CliOptionGroup;
import io.devcon5.cli.PostInject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class OptionInjector {
    private final Map<String, Option> options;

    public OptionInjector(CommandLine commandLine) {
        this.options = this.toMap(commandLine);
    }

    public <T> void injectInto(T target) {
        this.injectParameters(target, this.options);
        this.preFlightCheck(target);
    }

    private <T> void preFlightCheck(T target) {
        if (target == null) {
            return;
        }
        this.preFlightCheckFields(target);
        List<Method> methods = this.getPostInjectMethods(target);
        this.preFlightCheckMethods(target, methods);
    }

    private <T> void preFlightCheckFields(T target) {
        ClassStreams.selfAndSupertypes(target.getClass()).map(Class::getDeclaredFields).flatMap(Arrays::stream).filter(field -> field.getAnnotation(CliOptionGroup.class) != null).forEach(field -> {
            field.setAccessible(true);
            try {
                this.preFlightCheck(field.get(target));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> List<Method> getPostInjectMethods(T target) {
        List<Method> methods = ClassStreams.selfAndSupertypes(target.getClass()).map(Class::getDeclaredMethods).flatMap(Arrays::stream).filter(method -> method.getAnnotation(PostInject.class) != null).collect(Collectors.toList());
        Collections.sort(methods, (m1, m2) -> m1.getAnnotation(PostInject.class).value() - m2.getAnnotation(PostInject.class).value());
        return methods;
    }

    private <T> void preFlightCheckMethods(T target, List<Method> methods) {
        methods.forEach(m -> {
            m.setAccessible(true);
            try {
                m.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void injectParameters(Object target, Map<String, Option> options) {
        ClassStreams.selfAndSupertypes(target.getClass()).forEach(type -> {
            for (Field f : type.getDeclaredFields()) {
                Optional.ofNullable(f.getAnnotation(CliOption.class)).ifPresent(opt -> this.populate(f, target, this.getEffectiveValue(options, (CliOption)opt)));
                Optional.ofNullable(f.getAnnotation(CliOptionGroup.class)).ifPresent(opt -> this.populate(f, target, options));
            }
        });
    }

    private String getEffectiveValue(Map<String, Option> options, CliOption opt) {
        String shortOpt = opt.value();
        if (opt.hasArg()) {
            if (options.containsKey(shortOpt)) {
                return options.get(shortOpt).getValue();
            }
            return opt.defaultValue();
        }
        return Boolean.toString(options.containsKey(opt.value()));
    }

    private void populate(Field field, Object target, String stringValue) {
        field.setAccessible(true);
        try {
            Class<?> fieldType = field.getType();
            Object value = TypeConverter.convert((String)stringValue).to(fieldType);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not populate field " + field, e);
        }
    }

    private void populate(Field field, Object target, Map<String, Option> options) {
        field.setAccessible(true);
        try {
            Object fieldValue = field.getType().newInstance();
            this.injectParameters(fieldValue, options);
            field.set(target, fieldValue);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not populate field " + field, e);
        }
    }

    private Map<String, Option> toMap(CommandLine cl) {
        HashMap<String, Option> opts = new HashMap<String, Option>();
        for (Option opt : cl.getOptions()) {
            opts.put(opt.getOpt(), opt);
        }
        return opts;
    }
}

