/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.cli;

import io.devcon5.classutils.ClassStreams;
import io.devcon5.classutils.TypeConverter;
import io.devcon5.cli.CliOption;
import io.devcon5.cli.CliOptionGroup;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class OptionInjector {
    private final Map<String, Option> options;

    public OptionInjector(CommandLine commandLine) {
        this.options = this.toMap(commandLine);
    }

    public <T> void injectInto(T target) {
        this.injectParameters(target, this.options);
    }

    private void injectParameters(Object target, Map<String, Option> options) {
        ClassStreams.selfAndSupertypes(target.getClass()).forEach(type -> {
            for (Field f : type.getDeclaredFields()) {
                Optional.ofNullable(f.getAnnotation(CliOption.class)).ifPresent(opt -> this.populate(f, target, this.getEffectiveValue(options, (CliOption)opt)));
                Optional.ofNullable(f.getAnnotation(CliOptionGroup.class)).ifPresent(opt -> this.populate(f, target, options));
            }
        });
    }

    private String getEffectiveValue(Map<String, Option> options, CliOption opt) {
        String shortOpt = opt.value();
        if (opt.hasArg()) {
            if (options.containsKey(shortOpt)) {
                return options.get(shortOpt).getValue();
            }
            return opt.defaultValue();
        }
        return Boolean.toString(options.containsKey(opt.value()));
    }

    private void populate(Field field, Object target, String stringValue) {
        field.setAccessible(true);
        try {
            Class<?> fieldType = field.getType();
            Object value = TypeConverter.convert((String)stringValue).to(fieldType);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not populate field " + field, e);
        }
    }

    private void populate(Field field, Object target, Map<String, Option> options) {
        field.setAccessible(true);
        try {
            Object fieldValue = field.getType().newInstance();
            this.injectParameters(fieldValue, options);
            field.set(target, fieldValue);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not populate field " + field, e);
        }
    }

    private Map<String, Option> toMap(CommandLine cl) {
        HashMap<String, Option> opts = new HashMap<String, Option>();
        for (Option opt : cl.getOptions()) {
            opts.put(opt.getOpt(), opt);
        }
        return opts;
    }
}

