/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.classutils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JarScanner {
    private final Set<String> ignoredFolders = new HashSet<String>();
    private final Set<URI> jars = new ConcurrentSkipListSet<URI>();
    private static final Map<String, String> READY_ONLY_ENV;

    public JarScanner ignore(Collection<String> folders) {
        this.ignoredFolders.addAll(folders);
        return this;
    }

    public JarScanner ignore(String ... folder) {
        return this.ignore(Arrays.asList(folder));
    }

    public JarScanner addJar(URL ... jar) {
        return this.addJar(Arrays.asList(jar));
    }

    public JarScanner addJar(Collection<URL> jars) {
        this.jars.addAll(jars.stream().map(JarScanner::toUri).collect(Collectors.toList()));
        return this;
    }

    private static URI toUri(URL u) {
        try {
            return u.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not convert URL " + u + " to uri", e);
        }
    }

    public Collection<String> scanPackages() {
        return this.scanJar(p -> Files.isDirectory(p, new LinkOption[0]) && !this.isIgnored(p.toAbsolutePath()));
    }

    public Collection<String> scanClasses() {
        return this.scanJar(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".class") && !this.isIgnored(p.toAbsolutePath()));
    }

    private Collection<String> scanJar(Predicate<Path> pathFilter) {
        return this.jars.parallelStream().map(JarScanner::createJarUri).flatMap(u -> this.scanJar((URI)u, pathFilter).stream()).distinct().collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<String> scanJar(URI u, Predicate<Path> pathPredicate) {
        try (FileSystem fs = FileSystems.newFileSystem(u, READY_ONLY_ENV);){
            Collection collection = Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0]).filter(pathPredicate).map(f -> this.toFQName(f.toAbsolutePath())).distinct().collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String toFQName(Path file) {
        return file.toString().replaceAll("(\\/|\\\\)", ".").replaceAll("(^\\.+|(\\.+|\\.class)$)", "");
    }

    private boolean isIgnored(Path p) {
        String path = this.toFQName(p);
        return this.ignoredFolders.stream().anyMatch(path::startsWith);
    }

    private static URI createJarUri(URI uri) {
        return URI.create("jar:" + uri);
    }

    static {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "false");
        READY_ONLY_ENV = Collections.unmodifiableMap(env);
    }
}

