/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.classutils;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TypeConverter {
    private static final Map<Class, Class> PRIMITIVE_TO_OBJECT_TYPE_MAP;
    private final String value;

    private TypeConverter(String value) {
        this.value = value;
    }

    public static TypeConverter convert(String value) {
        return new TypeConverter(value);
    }

    public <T> T to(Class<T> targetType) {
        if (targetType == String.class) {
            return (T)this.value;
        }
        try {
            Class type;
            String methodName;
            if (targetType.isPrimitive()) {
                String typeName = targetType.getSimpleName();
                methodName = "parse" + typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
                type = PRIMITIVE_TO_OBJECT_TYPE_MAP.get(targetType);
            } else {
                methodName = "valueOf";
                type = targetType;
            }
            return (T)type.getMethod(methodName, String.class).invoke(null, this.value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not convert value '" + this.value + "' to type " + targetType.getName(), e);
        }
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class<Double>> map = new HashMap<Class<Comparable<Boolean>>, Class<Double>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_OBJECT_TYPE_MAP = Collections.unmodifiableMap(map);
    }
}

