/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.classutils;

import java.net.URL;

public class ResourceResolver {
    private final boolean failOnMissingResource;

    public ResourceResolver() {
        this(false);
    }

    public ResourceResolver(boolean failOnMissingResource) {
        this.failOnMissingResource = failOnMissingResource;
    }

    public URL resolve(String resource) {
        return this.resolve(resource, this.getClass());
    }

    public URL resolve(String resource, Class consumer) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        String resourcePath = this.resolvePath(resource, consumer);
        URL contentUrl = null;
        if (ccl != null) {
            contentUrl = ccl.getResource(resourcePath);
        }
        if (contentUrl == null) {
            contentUrl = consumer.getResource(resourcePath);
        }
        if (this.failOnMissingResource && contentUrl == null) {
            throw new AssertionError((Object)("Resource " + resource + " not found"));
        }
        return contentUrl;
    }

    private String resolvePath(String resource, Class consumer) {
        if (resource.startsWith("/")) {
            return resource;
        }
        StringBuilder buf = new StringBuilder(32);
        buf.append('/').append(consumer.getPackage().getName().replaceAll("\\.", "/")).append('/').append(resource);
        return buf.toString();
    }
}

