/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.classutils;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public final class CallStack {
    private static final String THIS_NAME = CallStack.class.getName();
    private static ThreadLocal<Deque<Method>> METHODSTACK = ThreadLocal.withInitial(() -> new ArrayDeque());

    private CallStack() {
    }

    public static <T> T track(T target) {
        return (T)Enhancer.create(target.getClass(), (Callback)((MethodInterceptor)(o, method, objects, methodProxy) -> {
            METHODSTACK.get().push(method);
            try {
                Object object = methodProxy.invokeSuper(o, objects);
                return object;
            }
            finally {
                METHODSTACK.get().pop();
            }
        }));
    }

    public static Optional<Method> currentMethod() {
        return Optional.ofNullable(METHODSTACK.get().peek());
    }

    public static Class<?> getCallerClass() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        try {
            StackTraceElement caller = CallStack.findCaller(stElements);
            return CallStack.loadClass(caller.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not determine caller class", e);
        }
    }

    private static StackTraceElement findCaller(StackTraceElement[] stElements) {
        int len = stElements.length - 1;
        for (int i = 1; i < len; ++i) {
            StackTraceElement ste = stElements[i];
            if (THIS_NAME.equals(ste.getClassName())) continue;
            if (stElements[i + 1].getMethodName().matches("access\\$\\d+")) {
                return stElements[i + 2];
            }
            return stElements[i + 1];
        }
        return stElements[stElements.length - 1];
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader ctxCL = Thread.currentThread().getContextClassLoader();
        if (ctxCL == null) {
            return Class.forName(className);
        }
        return ctxCL.loadClass(className);
    }
}

