/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicecatalog.handler;

import io.dekorate.Handler;
import io.dekorate.Resources;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.servicecatalog.config.EditableServiceCatalogConfig;
import io.dekorate.servicecatalog.config.ServiceCatalogConfig;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import io.dekorate.servicecatalog.decorator.AddServiceBindingResourceDecorator;
import io.dekorate.servicecatalog.decorator.AddServiceInstanceResourceDecorator;
import java.util.Arrays;

@Description(value="Adds service instance and binding and inject binding info to container environment.")
public class ServiceCatalogHandler
implements Handler<ServiceCatalogConfig> {
    private final Resources resources;

    ServiceCatalogHandler() {
        this(new Resources());
    }

    public ServiceCatalogHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 410;
    }

    public String getKey() {
        return "svcat";
    }

    public void handle(ServiceCatalogConfig config) {
        Arrays.stream(config.getInstances()).forEach(i -> {
            this.resources.decorate((Decorator)new AddServiceInstanceResourceDecorator((ServiceCatalogInstance)i));
            if (i.getBindingSecret() != null) {
                this.resources.decorate((Decorator)new AddServiceBindingResourceDecorator((ServiceCatalogInstance)i));
                this.resources.decorate((Decorator)new AddEnvVarDecorator((Env)((EnvBuilder)new EnvBuilder().withSecret(i.getBindingSecret())).build()));
            }
        });
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(ServiceCatalogConfig.class) || type.equals(EditableServiceCatalogConfig.class);
    }
}

