/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicecatalog.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.servicecatalog.config.Parameter;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluent;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Description(value="Add a ServiceInstance resource(s) to the list of generated resources.")
public class AddServiceInstanceResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private ServiceCatalogInstance instance;

    public AddServiceInstanceResourceDecorator(ServiceCatalogInstance instance) {
        this.instance = instance;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        list.addToItems((VisitableBuilder)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((ServiceInstanceBuilder)((ServiceInstanceFluent.MetadataNested)new ServiceInstanceBuilder().withNewMetadata().withName(meta.getName())).endMetadata()).withNewSpec().withClusterServiceClassExternalName(this.instance.getServiceClass())).withClusterServicePlanExternalName(this.instance.getServicePlan())).withParameters(AddServiceInstanceResourceDecorator.toMap(this.instance.getParameters()))).endSpec());
    }

    protected static Map<String, Object> toMap(Parameter ... parameters) {
        return Arrays.asList(parameters).stream().collect(Collectors.toMap((? super T p) -> p.getKey(), (? super T p) -> p.getValue()));
    }
}

