package io.dekorate.servicecatalog.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServiceCatalogInstanceFluentImpl<A extends io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<A>> extends BaseFluent<A> implements io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<A> {

    private String name;
    private String serviceClass;
    private String servicePlan;
    private List<ParameterBuilder> parameters =  new ArrayList<ParameterBuilder>();
    private String bindingSecret = "";

    public ServiceCatalogInstanceFluentImpl() {
    }

    public ServiceCatalogInstanceFluentImpl(io.dekorate.servicecatalog.config.ServiceCatalogInstance instance) {
        this.withName(instance.getName()); 
        this.withServiceClass(instance.getServiceClass()); 
        this.withServicePlan(instance.getServicePlan()); 
        this.withParameters(instance.getParameters()); 
        this.withBindingSecret(instance.getBindingSecret()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public A withServiceClass(String serviceClass) {
        this.serviceClass=serviceClass; return (A) this;
    }

    public Boolean hasServiceClass() {
        return this.serviceClass != null;
    }

    public A withNewServiceClass(String arg1) {
        return (A)withServiceClass(new String(arg1));
    }

    public A withNewServiceClass(StringBuilder arg1) {
        return (A)withServiceClass(new String(arg1));
    }

    public A withNewServiceClass(StringBuffer arg1) {
        return (A)withServiceClass(new String(arg1));
    }

    public String getServicePlan() {
        return this.servicePlan;
    }

    public A withServicePlan(String servicePlan) {
        this.servicePlan=servicePlan; return (A) this;
    }

    public Boolean hasServicePlan() {
        return this.servicePlan != null;
    }

    public A withNewServicePlan(String arg1) {
        return (A)withServicePlan(new String(arg1));
    }

    public A withNewServicePlan(StringBuilder arg1) {
        return (A)withServicePlan(new String(arg1));
    }

    public A withNewServicePlan(StringBuffer arg1) {
        return (A)withServicePlan(new String(arg1));
    }

    public A withParameters(io.dekorate.servicecatalog.config.Parameter... parameters) {
        if (this.parameters != null) {this.parameters.clear();}
        if (parameters != null) {for (io.dekorate.servicecatalog.config.Parameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    
/**
 * This method has been deprecated, please use method buildParameters instead.
 */
@Deprecated public io.dekorate.servicecatalog.config.Parameter[] getParameters() {
        int size = parameters != null ? parameters.size() : 0;
        io.dekorate.servicecatalog.config.Parameter[] result = new io.dekorate.servicecatalog.config.Parameter[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (VisitableBuilder<? extends io.dekorate.servicecatalog.config.Parameter,?> builder : parameters) {
            result[index++]=builder.build();
        }
        return result;
    }

    public io.dekorate.servicecatalog.config.Parameter[] buildParameters() {
        int size = parameters != null ? parameters.size() : 0;
        io.dekorate.servicecatalog.config.Parameter[] result = new io.dekorate.servicecatalog.config.Parameter[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (VisitableBuilder<? extends io.dekorate.servicecatalog.config.Parameter,?> builder : parameters) {
            result[index++]=builder.build();
        }
        return result;
    }

    public io.dekorate.servicecatalog.config.Parameter buildParameter(int index) {
        return this.parameters.get(index).build();
    }

    public io.dekorate.servicecatalog.config.Parameter buildFirstParameter() {
        return this.parameters.get(0).build();
    }

    public io.dekorate.servicecatalog.config.Parameter buildLastParameter() {
        return this.parameters.get(parameters.size() - 1).build();
    }

    public io.dekorate.servicecatalog.config.Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate) {
        for (ParameterBuilder item: parameters) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate) {
        for (ParameterBuilder item: parameters) { if(predicate.test(item)){ return true;} } return false;
    }

    public A addToParameters(int index,io.dekorate.servicecatalog.config.Parameter item) {
        if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
        io.dekorate.servicecatalog.config.ParameterBuilder builder = new io.dekorate.servicecatalog.config.ParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
    }

    public A setToParameters(int index,io.dekorate.servicecatalog.config.Parameter item) {
        if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
        io.dekorate.servicecatalog.config.ParameterBuilder builder = new io.dekorate.servicecatalog.config.ParameterBuilder(item);
        if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
        if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
         return (A)this;
    }

    public A addToParameters(io.dekorate.servicecatalog.config.Parameter... items) {
        if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
        for (io.dekorate.servicecatalog.config.Parameter item : items) {io.dekorate.servicecatalog.config.ParameterBuilder builder = new io.dekorate.servicecatalog.config.ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A addAllToParameters(Collection<io.dekorate.servicecatalog.config.Parameter> items) {
        if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
        for (io.dekorate.servicecatalog.config.Parameter item : items) {io.dekorate.servicecatalog.config.ParameterBuilder builder = new io.dekorate.servicecatalog.config.ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(io.dekorate.servicecatalog.config.Parameter... items) {
        for (io.dekorate.servicecatalog.config.Parameter item : items) {io.dekorate.servicecatalog.config.ParameterBuilder builder = new io.dekorate.servicecatalog.config.ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeAllFromParameters(Collection<io.dekorate.servicecatalog.config.Parameter> items) {
        for (io.dekorate.servicecatalog.config.Parameter item : items) {io.dekorate.servicecatalog.config.ParameterBuilder builder = new io.dekorate.servicecatalog.config.ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate) {
        if (parameters == null) return (A) this;
        final Iterator<ParameterBuilder> each = parameters.iterator();
        final List visitables = _visitables.get("parameters");
        while (each.hasNext()) {
          ParameterBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public Boolean hasParameters() {
        return parameters != null && !parameters.isEmpty();
    }

    public A addNewParameter(String key,String value) {
        return (A)addToParameters(new Parameter(key, value));
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> addNewParameter() {
        return new ParametersNestedImpl();
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> addNewParameterLike(io.dekorate.servicecatalog.config.Parameter item) {
        return new ParametersNestedImpl(-1, item);
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> setNewParameterLike(int index,io.dekorate.servicecatalog.config.Parameter item) {
        return new ParametersNestedImpl(index, item);
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> editParameter(int index) {
        if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
        return setNewParameterLike(index, buildParameter(index));
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> editFirstParameter() {
        if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
        return setNewParameterLike(0, buildParameter(0));
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> editLastParameter() {
        int index = parameters.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
        return setNewParameterLike(index, buildParameter(index));
    }

    public ServiceCatalogInstanceFluent.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate) {
        int index = -1;
        for (int i=0;i<parameters.size();i++) { 
        if (predicate.test(parameters.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
        return setNewParameterLike(index, buildParameter(index));
    }

    public String getBindingSecret() {
        return this.bindingSecret;
    }

    public A withBindingSecret(String bindingSecret) {
        this.bindingSecret=bindingSecret; return (A) this;
    }

    public Boolean hasBindingSecret() {
        return this.bindingSecret != null;
    }

    public A withNewBindingSecret(String arg1) {
        return (A)withBindingSecret(new String(arg1));
    }

    public A withNewBindingSecret(StringBuilder arg1) {
        return (A)withBindingSecret(new String(arg1));
    }

    public A withNewBindingSecret(StringBuffer arg1) {
        return (A)withBindingSecret(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceCatalogInstanceFluentImpl that = (ServiceCatalogInstanceFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (serviceClass != null ? !serviceClass.equals(that.serviceClass) :that.serviceClass != null) return false;
        if (servicePlan != null ? !servicePlan.equals(that.servicePlan) :that.servicePlan != null) return false;
        if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
        if (bindingSecret != null ? !bindingSecret.equals(that.bindingSecret) :that.bindingSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  serviceClass,  servicePlan,  parameters,  bindingSecret,  super.hashCode());
    }

    public class ParametersNestedImpl<N> extends ParameterFluentImpl<ServiceCatalogInstanceFluent.ParametersNested<N>> implements ServiceCatalogInstanceFluent.ParametersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ParameterBuilder builder;
        private final int index;

            ParametersNestedImpl(int index,io.dekorate.servicecatalog.config.Parameter item) {
                this.index = index;
                this.builder = new ParameterBuilder(this, item);
                        
            }

            ParametersNestedImpl() {
                this.index = -1;
                this.builder = new ParameterBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceCatalogInstanceFluentImpl.this.setToParameters(index,builder.build());
            }

            public N endParameter() {
                return and();
            }
    }


}
