package io.dekorate.servicecatalog.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Boolean;

public interface ServiceCatalogInstanceFluent<A extends io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<A>> extends Fluent<A> {


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getServiceClass();
    public A withServiceClass(String serviceClass);
    public Boolean hasServiceClass();
    public A withNewServiceClass(String arg1);
    public A withNewServiceClass(StringBuilder arg1);
    public A withNewServiceClass(StringBuffer arg1);
    public String getServicePlan();
    public A withServicePlan(String servicePlan);
    public Boolean hasServicePlan();
    public A withNewServicePlan(String arg1);
    public A withNewServicePlan(StringBuilder arg1);
    public A withNewServicePlan(StringBuffer arg1);
    public A withParameters(io.dekorate.servicecatalog.config.Parameter... parameters);
    
/**
 * This method has been deprecated, please use method buildParameters instead.
 */
@Deprecated public io.dekorate.servicecatalog.config.Parameter[] getParameters();
    public io.dekorate.servicecatalog.config.Parameter[] buildParameters();
    public io.dekorate.servicecatalog.config.Parameter buildParameter(int index);
    public io.dekorate.servicecatalog.config.Parameter buildFirstParameter();
    public io.dekorate.servicecatalog.config.Parameter buildLastParameter();
    public io.dekorate.servicecatalog.config.Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate);
    public Boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate);
    public A addToParameters(int index,io.dekorate.servicecatalog.config.Parameter item);
    public A setToParameters(int index,io.dekorate.servicecatalog.config.Parameter item);
    public A addToParameters(io.dekorate.servicecatalog.config.Parameter... items);
    public A addAllToParameters(Collection<io.dekorate.servicecatalog.config.Parameter> items);
    public A removeFromParameters(io.dekorate.servicecatalog.config.Parameter... items);
    public A removeAllFromParameters(Collection<io.dekorate.servicecatalog.config.Parameter> items);
    public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate);
    public Boolean hasParameters();
    public A addNewParameter(String key,String value);
    public ServiceCatalogInstanceFluent.ParametersNested<A> addNewParameter();
    public ServiceCatalogInstanceFluent.ParametersNested<A> addNewParameterLike(io.dekorate.servicecatalog.config.Parameter item);
    public ServiceCatalogInstanceFluent.ParametersNested<A> setNewParameterLike(int index,io.dekorate.servicecatalog.config.Parameter item);
    public ServiceCatalogInstanceFluent.ParametersNested<A> editParameter(int index);
    public ServiceCatalogInstanceFluent.ParametersNested<A> editFirstParameter();
    public ServiceCatalogInstanceFluent.ParametersNested<A> editLastParameter();
    public ServiceCatalogInstanceFluent.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate);
    public String getBindingSecret();
    public A withBindingSecret(String bindingSecret);
    public Boolean hasBindingSecret();
    public A withNewBindingSecret(String arg1);
    public A withNewBindingSecret(StringBuilder arg1);
    public A withNewBindingSecret(StringBuffer arg1);
    public interface ParametersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParameterFluent<ServiceCatalogInstanceFluent.ParametersNested<N>> {

            public N and();
            public N endParameter();    }


}
