package io.dekorate.servicecatalog.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class ServiceCatalogInstance {

    private String name;
    private String serviceClass;
    private String servicePlan;
    private io.dekorate.servicecatalog.config.Parameter[] parameters = new io.dekorate.servicecatalog.config.Parameter[0];
    private String bindingSecret = "";

    public ServiceCatalogInstance() {
    }

    public ServiceCatalogInstance(String name,String serviceClass,String servicePlan,io.dekorate.servicecatalog.config.Parameter[] parameters,String bindingSecret) {
        this.name = name;
        this.serviceClass = serviceClass;
        this.servicePlan = servicePlan;
        this.parameters = parameters != null ? parameters : new io.dekorate.servicecatalog.config.Parameter[0];
        this.bindingSecret = bindingSecret != null ? bindingSecret : "";
    }

    public String getName() {
        return this.name;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public String getServicePlan() {
        return this.servicePlan;
    }

    public io.dekorate.servicecatalog.config.Parameter[] getParameters() {
        return this.parameters;
    }

    public String getBindingSecret() {
        return this.bindingSecret;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceCatalogInstance that = (ServiceCatalogInstance) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (serviceClass != null ? !serviceClass.equals(that.serviceClass) :that.serviceClass != null) return false;
        if (servicePlan != null ? !servicePlan.equals(that.servicePlan) :that.servicePlan != null) return false;
        if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
        if (bindingSecret != null ? !bindingSecret.equals(that.bindingSecret) :that.bindingSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  serviceClass,  servicePlan,  parameters,  bindingSecret,  super.hashCode());
    }

}
