package io.dekorate.servicecatalog.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class ServiceCatalogConfig extends Configuration {

    private io.dekorate.servicecatalog.config.ServiceCatalogInstance[] instances = new io.dekorate.servicecatalog.config.ServiceCatalogInstance[0];

    public ServiceCatalogConfig() {
    }

    public ServiceCatalogConfig(Project project,Map<ConfigKey,Object> attributes,io.dekorate.servicecatalog.config.ServiceCatalogInstance[] instances) {
        super(project, attributes);
        this.instances = instances != null ? instances : new io.dekorate.servicecatalog.config.ServiceCatalogInstance[0];
    }

    public io.dekorate.servicecatalog.config.ServiceCatalogInstance[] getInstances() {
        return this.instances;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCatalogConfig that = (ServiceCatalogConfig) o;
        if (instances != null ? !instances.equals(that.instances) :that.instances != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(instances,  super.hashCode());
    }

}
