package io.dekorate.servicecatalog.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class Parameter {

    private String key;
    private String value;

    public Parameter() {
    }

    public Parameter(String key,String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Parameter that = (Parameter) o;
        if (key != null ? !key.equals(that.key) :that.key != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(key,  value,  super.hashCode());
    }

}
